//
//  error_result_helper.h
//  gaeaLwp
//
//  Created by guodi.ggd on 2019/6/18.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef error_result_helper_h
#define error_result_helper_h

#include <stdio.h>
#include <string>

#include "gaea/base/error_result.h"
#include "gaea/lwp/error_code_helper.h"
#include "gaea/lwp/gaea_define.h"

namespace gaea {
  namespace idl {
    class ServiceException;
  }
}

GAEA_LWP_NAMESPACE_BEGIN
class ErrorResultHelper {
public:
  static void FillErrorWithException(
      gaea::base::ErrorResult &error_result,
      gaea::idl::ServiceException& exception);
  
  static gaea::base::ErrorResult BuildLocalError(
      const gaea::lwp::ErrorCode& code_type);
  
  static gaea::base::ErrorResult BuildLocalError(
      const std::string& code,
      const std::string& reason);
  
  static gaea::base::ErrorResult BuildLocalError(
      const std::string& code,
      const std::string& reason,
      const std::string& develop_msg);

  static gaea::base::ErrorResult BuildLocalError(
      const std::string& scope,
      int status,
      const std::string& code,
      const std::string& reason,
      const std::string& develop_msg);
  
  static gaea::base::ErrorResult BuildError(
      bool is_local_error,
      const std::string& scope,
      int status,
      const std::string& code,
      const std::string& reason,
      const std::string& develop_msg);
  
  static gaea::base::ErrorResult BuildUnpackError();
};
GAEA_LWP_NAMESPACE_END


#endif /* error_result_helper_hpp */

