//
//  event_loop.hpp
//  GaeaLwp
//
//  Created by Herb on 2019/4/18.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef Gaea_Lwp_Event_Loop_h
#define Gaea_Lwp_Event_Loop_h

#include <map>
#include <string>
#include <memory>
#include <thread>
#include "gaea/base/async_task_manager.h"
#include "gaea/base/logging.h"
#include "gaea/lwp/common/timer.h"

GAEA_LWP_NAMESPACE_BEGIN

class DispatchCenter;
typedef std::shared_ptr<DispatchCenter> DispatchCenterPtr;

class EventLoop : public std::enable_shared_from_this<EventLoop> {
public:
  EventLoop(bool need_be_host = false);
  ~EventLoop();
  
public:
  /**
   * @function Start
   * @brief 启动
   */
  void Start();
  
  /**
   * @function Shutdown
   * @brief 关闭
   */
  void Shutdown();
  
  /**
   * @brief 设置托管中心
   */
  void set_dispath_center(DispatchCenterPtr dispath_center);
  
  /**
   * @function name
   * @brief 设置线程名
   */
  const std::string& name() const { return name_; }
  void set_name(const std::string& name) { name_ = name; }

  /**
   * @function is_stop
   * @brief 判断是否设置了停止
   */
  bool is_stop() const { return is_stop_; }
  
  /**
   * @function IsCurrentThread
   * @brief 判断是否当前线程
   */
  bool IsCurrentThread();
  /**
   * @function shutdown_completed
   * @brief 标识是否完整关闭
   */
  bool shutdown_completed() const { return shutdown_completed_; }
  
  /**
   * @function AddTask
   * @brief 添加任务
   */
  bool AddTask(gaea::base::AsyncTaskPtr task);
  
  /**
   * @function CancelTask
   * @brief 删除任务
   */
  bool CancelTask(gaea::base::AsyncTaskPtr task);
  
  /**
   * @function Process
   * @brief 循环处理任务
   */
  void Process();
  
  /**
   * @function PollTimer
   * @brief 循环遍历定时器
   */
  void PollTimer();
  
  /**
   * @function PollTimer
   * @brief 循环遍历定时器
   */
  Timer::TimerId AddTimer(std::chrono::milliseconds timeout,
                          std::function<void()> callback);
  void RemoveTimer(Timer::TimerId timerId);
  
  /**
   * @function Clear
   * @brief 清理 EventLoop 中缓存
   */
  void Clear();
  
  gaea::base::AsyncTaskManager& tasks_manager() { return tasks_manager_; }
  Timer& timer_manager() { return timer_manager_; }
  void SetRunThreadId(std::thread::id thread_id) {
    if (need_be_host_) {
      thread_id_ = thread_id;
    }
  }
  
  void set_unique_mark(const std::string& mark);
  
  /**
   * @brief 触发当前 eventloop stop 退出
   */
  void CheckAndTrigerExist();
  
private:
  void Run();
  void Wakeup();
  
  /**
   * 停止定时器
   */
  void ClearTimer();
  
private:
  gaea::base::Logger logger_;
  bool is_stop_;
  bool shutdown_completed_;
  std::string name_;
  gaea::base::AsyncTaskManager tasks_manager_;
  
  std::mutex loop_mutext;
  std::condition_variable loop_cond;
  
  Timer timer_manager_;
  std::thread* thread_;
  std::thread::id thread_id_;
  
  bool need_be_host_;
  DispatchCenterPtr dispath_center_;
  
  std::string unique_mark_;
};

typedef std::shared_ptr<EventLoop> EventLoopPtr;
  
GAEA_LWP_NAMESPACE_END

#endif /* Gaea_Lwp_Event_Loop_h */
