//
//  file_upload_result.h
//  Atlas
//
//  Created by jinxi on 8/4/16.
//  Copyright © 2016 jinxi. All rights reserved.
//

#ifndef Gaea_Lwp_FileUploadResult_h
#define Gaea_Lwp_FileUploadResult_h

#include <string>
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class FileUploadResult {
public:
  FileUploadResult() : is_quick_transfer_(false) {}
  ~FileUploadResult() {}

public:
  const std::string& media_id() const { return media_id_; }
  void set_media_id(const std::string& mediaId) { media_id_ = mediaId; }

  const std::string& media_id_v2() const { return media_id_v2_; }
  void set_media_id_v2(const std::string& media_id_v2) { media_id_v2_ = media_id_v2; }
  
  bool is_quick_transfer() const { return is_quick_transfer_; }
  void set_is_quick_transfer(bool is_quick_transfer) { is_quick_transfer_ = is_quick_transfer; }

  const std::string& content_md5() const { return content_md5_; }
  void set_content_md5(const std::string& content_md5) { content_md5_ = content_md5; }

  const std::string ToString() const;
private:
  std::string media_id_;
  std::string media_id_v2_;
  bool is_quick_transfer_;
  std::string content_md5_;
};

GAEA_LWP_NAMESPACE_END

#endif /* Gaea_Lwp_FileUploadResult_h */
