//
//  gaea_config.h
//  gaeaLwp
//
//  Created by guodi.ggd on 2019/5/8.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GaeaConfig_h
#define GaeaConfig_h

#include <assert.h>
#include <memory>

#include "gaea/base/singleton.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class ConfigBase {
 public:
  ConfigBase();
  virtual ~ConfigBase() {}
  
  virtual void Setup() {}
  
  ConnectionPlugType plug_type() { return plug_type_; }
  static const std::string GetConnPlugDescript(ConnectionPlugType type);
  
 protected:
  ConnectionPlugType plug_type_;
};
typedef std::shared_ptr<ConfigBase> ConfigBasePtr;
  

class GaeaConfig : public gaea::base::Singleton<GaeaConfig> {
 public:
  GaeaConfig();
  virtual ~GaeaConfig();
  void AddConfigImplement(ConnectionPlugType plug_type, const ConfigBasePtr& impl);
  void Setup();
  void Reset();
  
 private:
  void CheckConfig();
  void GlobalInitial();
  
 private:
  std::map<ConnectionPlugType, ConfigBasePtr> impl_map_;
  gaea::base::Logger logger_;
};

GAEA_LWP_NAMESPACE_END

#endif /* GaeaConfig_h */
