//
//  gaea_define.h
//  gaeaLwp
//
//  Created by Herb on 2019/5/6.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_DEFINE_H_
#define GAEA_DEFINE_H_

#include <functional>
#include <memory>
#include "gaea/base/error_result.h"
#include "gaea/base/logging.h"



#define GAEA_LWP_NAMESPACE gaea::lwp
#define GAEA_LWP_LOGNAME "gaea.lwp"
#define GAEA_TRACE_VERSION  "1"

#ifdef _WIN32

#if defined(GAEA_EXPORT)
#define GAEA_DECL __declspec(dllexport)
#else
#define GAEA_DECL __declspec(dllimport)
#endif

#else

#if defined(GAEA_EXPORT)
#define GAEA_DECL __attribute__ ((visibility ("default")))
#else
#define GAEA_DECL
#endif

#endif // _WIN32


namespace gaea {
namespace base {


class ErrorResult;

class AsyncTask;
typedef std::shared_ptr<AsyncTask> AsyncTaskPtr;

}
}

namespace gaea {
namespace service {

class TraceInterface;
typedef std::shared_ptr<TraceInterface> TraceInterfacePtr;

class UserAgentInterface;
typedef std::shared_ptr<UserAgentInterface> UserAgentInterfacePtr;

class AsrInterface;
typedef std::shared_ptr<AsrInterface> AsrInterfacePtr;

}
}

namespace gaea {
namespace lwp {

enum SiteType {
  kUndefineSite = 0,
  kMainSite = 1,
  kUploadSite = 2,
  kDownloadSite = 3,
  kHugeUploadSite = 4,
  kHugeDownloadSite = 5,
  kProxyAgentTestSite = 6
};

enum LwpConnectionStatus {
  kLwpUnconnected = 1,
  kLwpConnecting = 2,
  kLwpConnected = 3,
  kLwpAuthing = 4,
  kLwpAuthed = 5
};

typedef enum ConnectionPlugType {
  kUnknownConnectionPlug = 0,
  kAccsConnectionPlug = 1,        /** 虚拟连接：只支持主通道 */
  kBifrostConnectionPlug = 2,     /** 物理连接: 支持主通道 & 文件通道(http) */
  kDingTalkFileConnectionPlug = 3,/** 走物理连接：支持文件通道(Lwp) */
} ConnectionPlugType;

typedef enum LocalIPStackType {
  kLocalIPStackUnknown = 0,
  kLocalIPStackIPv4 = 1,
  kLocalIPStackIPv6 = 2,
  kLocalIPStackDual = 3,
} LocalIPStackType;

enum IpAddressType {
  kIPInvaild = -1,
  kIPv4 = 0,
  kIPv6 = 1,
};

enum LinkType {
  kUndefineLinkType = -1,
  kLongLink = 0,
  kShortLink = 1
};

enum SecurityProtocol {
  kUndefineProtocol = -1,
  kSecurityTls = 0,
  kSecurityLws = 1
};

enum ServerGroup {
  kServerOfUndefine = -1,
  kServerOfMain = 0,
  kServerOfDefault = 1,
  kServerOfCandidate = 2,
  kServerOfDisaster = 3,
  kServerOfDebug = 4
};

class UserContext;
typedef std::shared_ptr<UserContext> UserContextPtr;

class Session;
class FileUploadResult;
class FileDownloadResult;
class FileProgress;

class FileUploadTask;
typedef std::shared_ptr<FileUploadTask> FileUploadTaskPtr;

class FileDownloadTask;
typedef std::shared_ptr<FileDownloadTask> FileDownloadTaskPtr;

class FileServiceInterface;
typedef std::shared_ptr<FileServiceInterface> FileServiceInterfacePtr;

class PushListenerBase;
typedef std::shared_ptr<PushListenerBase> PushListenerBasePtr;

class Message;
typedef std::shared_ptr<Message> MessagePtr;

class Request;
typedef std::shared_ptr<Request> RequestPtr;

class Response;
typedef std::shared_ptr<Response> ResponsePtr;

class RequestContext;
typedef std::shared_ptr<RequestContext> RequestContextPtr;

class EventLoop;
typedef std::shared_ptr<EventLoop> EventLoopPtr;

class DispatchCenter;
typedef std::shared_ptr<DispatchCenter> DispatchCenterPtr;

class UserAgent;
typedef std::shared_ptr<UserAgent> UserAgentPtr;
typedef std::weak_ptr<UserAgent> UserAgentWeakPtr;

class SubscribeExternInfo;
typedef std::shared_ptr<SubscribeExternInfo> SubscribeExternInfoPtr;

class TranslateService;
typedef std::shared_ptr<TranslateService> TranslateServicePtr;

class MessageFilter;
typedef std::shared_ptr<MessageFilter> MessageFilterPtr;

typedef std::function<void (bool succ, const gaea::base::ErrorResult& err)> CheckAuthCallback;
typedef std::function<const std::string(void)> OnGetTokenHandler;
typedef std::function<void (const gaea::base::ErrorResult& error_result)> OnAsyncGetTokenHandler;

} // end of namepsace lwp
} // end of namepsace gaea

#define GAEA_LWP_REQUEST_REG    "/reg"
#define GAEA_LWP_REQUEST_PING   "/!"

//#if defined(DEBUG)
//#define UTEST_PREPROCESS_MODULE 1
//#endif

#ifdef __cplusplus
extern "C" {
#endif

extern const char* kGaeaFileClientScope;
extern const char* kGaeaFileServerScope;
extern const char* kGaeaAppNetScope;

#ifdef __cplusplus
}
#endif

/** namespace gaea::lwp */
#define GAEA_LWP_NAMESPACE_BEGIN \
namespace gaea {                 \
namespace lwp {

#define GAEA_LWP_NAMESPACE_END \
}                              \
}
#endif /* GAEA_DEFINE_H_ */
