//
//  idl_context.h
//  GaeaLwp
//
//  Created by Herb on 2019/4/25.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef idl_context_h
#define idl_context_h

#include <stdio.h>
#include <memory>
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class IdlContext {
public:
  IdlContext(UserAgentPtr user_agent, RequestContextPtr request_context);
  virtual ~IdlContext() {}
  
  void set_request_context(RequestContextPtr request_context) { request_context_ = request_context; }
  RequestContextPtr request_context() { return request_context_; }
  
  void set_user_agent(UserAgentPtr user_agent) { user_agent_ = user_agent; }
  UserAgentPtr user_agent() { return user_agent_; }
  
private:
  RequestContextPtr request_context_;
  UserAgentPtr user_agent_;
};

typedef std::shared_ptr<IdlContext> IdlContextPtr;

GAEA_LWP_NAMESPACE_END

#endif /* idl_context_h */
