//
//  message.h
//  gaea
//
//  Created by guodi.ggd on 2019/1/7.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_MESSAGE_H_
#define GAEA_LWP_MESSAGE_H_

#include <stdint.h>
#include <map>
#include <memory>
#include <time.h>
#include <set>
#include <vector>
#include "gaea/base/trace_context.h"
#include "gaea/interface/useragent/useragent_interface.h"
#include "gaea/lwp/mid.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

enum MessageStatus {
  kStatusLocalException   = -1,
  kStatusUnknwon          = 0,
  kStatusTrying           = 100,
  kStatusPartialSuccess   = 102,
  kStatusSuccess          = 200,
  kStatusBadRequest       = 400,
  kStatusUnauthorized     = 401,
  kStatusForbidden        = 403,
  kStatusNotFound         = 404,
  kStatusTimeout          = 408,
  kStatusTryLater         = 418,
  kStatusServiceException = 500,
};

enum ConnectionType{
  kLws = 1,
  kTls = 2,
  kTcp = 3
};

class Message : public gaea::service::BaseMessage {
public:
  typedef std::multimap<std::string, std::string> Headers;
  typedef int32_t ConnectionId;
  
  enum {
    kUnsetConnectionId = 0,
    kConnectionIdStartIndex = 1,
  };
  
  enum MessageType {
    kRequest = 0,
    kResponse = 1,
  };
  
  static size_t CompressThreshold;

public:
  Message();
  virtual ~Message();
  
  int type() const { return type_; }
  void set_type(int type) { type_ = type; }
  
  int length() const { return length_; }
  void set_length(int length) { length_ = length; }
  
  const Mid& mid() const { return mid_; }
  void set_mid(const Mid& mid) { mid_ = mid; }
  Mid& mutalbe_mid() { return mid_; }
  
  int zip() const { return zip_; }
  void set_zip(bool zip) { zip_ = zip; }
  
  const std::string& body();
  void set_body(const std::string& body) { body_ = body; }
  
  const bool from_wire() const { return from_wire_; }
  void set_from_wire(bool fromWire) { from_wire_ = fromWire; }
  
  const ConnectionId connection_id() const { return connection_id_; }
  void set_connection_id(const ConnectionId& connection_id) { connection_id_ = connection_id; }

  virtual bool IsHeaderExistWithName(const std::string& name) const;
  virtual std::string GetHeaderValueByName(const std::string& name) const;
  
  virtual void AddHeader(const std::string& name, const std::string& value);
  virtual void SetHeader(const std::string& name, const std::string& value);
  virtual void RemoveHeaderByName(const std::string& name);
  
  virtual std::set<std::string> GetHeaderNames() const;
  virtual std::vector<std::string> GetHeaderValues(const std::string& name) const;
  
  gaea::base::TraceContext& trace_context() { return trace_context_; }
  void set_trace_context(const gaea::base::TraceContext& context) { trace_context_ = context; }
  
  virtual const std::multimap<std::string, std::string>& headers() const { return headers_; }
  virtual void set_headers(const std::multimap<std::string, std::string>& headers) { headers_ = headers; }
  
  void GenerateMid();
  virtual const std::string StartLine() { return ""; }
  std::string Dumps(bool hasBody = true);

  virtual std::string ToString();
  
  int64_t lifetime() const { return lifetime_; }
  void set_lifetime(int64_t lifetime) { lifetime_ = lifetime; }
  bool Expired() { return lifetime_ > 0 && lifetime_ < time(NULL); }
protected:
  bool zip_;
  bool from_wire_;
  int type_;
  int length_;
  Mid mid_;
  int64_t lifetime_;
  Headers headers_;
  std::string body_;
  ConnectionId connection_id_;
  gaea::base::TraceContext trace_context_;
};
typedef std::shared_ptr<Message> MessagePtr;

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_MESSAGE_H_ */
