//
//  push_listener.h
//  gaea
//
//  Created by guodi.ggd on 2019/1/8.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_PUSH_LISTENER_H_
#define GAEA_LWP_PUSH_LISTENER_H_

#include "gaea/lwp/request.h"
#include "gaea/lwp/response.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

#define GAEA_PUSH_LISTENER_LOGNAME   "PushListener"
class UserAgent;
class Response;
typedef std::shared_ptr<Response> ResponsePtr;

class PushListenerContext
{
public:
  PushListenerContext();
  
  UserAgent* user_agent() {
    return user_agent_;
  };
  void set_user_agent(UserAgent *user_agent) {
    user_agent_ = user_agent;
  };
private:
  UserAgent *user_agent_;
};


class PushListenerBase {
 public:
  PushListenerBase() { logger_ = gaea::base::LoggerFactory::GetInstance()->GetLogger(GAEA_PUSH_LISTENER_LOGNAME); }
  virtual ~PushListenerBase() {}
  
  virtual void OnRecvRequest(RequestPtr request) = 0;
  virtual void SendResponse(RequestPtr request, int code);
  virtual void SendResponse(RequestPtr request, ResponsePtr response);
  void SetUserAgent(UserAgent *user_agent);
  
  PushListenerContext& context();
  
  void BeforeRecvRequest() {}
  void AfterRecvRequest() {}
 protected:
  UserAgent* GetUserAgent();
  gaea::base::Logger logger_;
  
private:
  PushListenerContext context_;
};
  
typedef std::shared_ptr<PushListenerBase> PushListenerBasePtr;

class AckStatus {
 public:
  AckStatus(RequestPtr request);
  virtual ~AckStatus() {}
  // 引用, 后续待移除
  void AckSuccess(UserAgent& userAgent) { SendAckWithStatus(200, userAgent); }
  void AckInvalid(UserAgent& userAgent) { SendAckWithStatus(400, userAgent); }
  void AckException(UserAgent& userAgent) { SendAckWithStatus(500, userAgent); }
  void SendAckWithStatus(int code, UserAgent& userAgent);
  // 指针
  void AckSuccess(UserAgent* userAgent) { SendAckWithStatus(200, userAgent); }
  void AckInvalid(UserAgent* userAgent) { SendAckWithStatus(400, userAgent); }
  void AckException(UserAgent* userAgent) { SendAckWithStatus(500, userAgent); }
  void SendAckWithStatus(int code, UserAgent* userAgent);
  
  RequestPtr mutable_request() { return request_; }
  
 private:
  RequestPtr request_;
  gaea::base::Logger logger_;
};
typedef std::shared_ptr<AckStatus> AckStatusPtr;
  

template <class PushModel>
class PushListener : public PushListenerBase {
 public:
  PushListener() {}
  virtual ~PushListener() {}
  
  virtual void OnRecvRequest(RequestPtr request) override {
    if (!request) {
      GAEA_LOG_WARN(logger_, "unexpect, recv null request?");
      return;
    }
    std::string body = request->body();
    PushModel push_model;
    if (!push_model.Unpack(body)) {
      GAEA_LOG_WARN(logger_, "unpackb failed for push topic=" << request->request_line()
                    << ", peek bytes=" << gaea::base::StringUtil::HexDump(body.substr(0, 4))
                    << ", body length=" << body.length());
      ResponsePtr response(new Response(kStatusBadRequest));
      const gaea::base::ErrorResult err = gaea::lwp::ErrorResultHelper::BuildLocalError(TO_STR_CODE(kErrorUnknown), "", "unpack error");
      response->set_local_error_result(err);
      SendResponse(request, response);
      return ;
    }
    AckStatusPtr ack(new AckStatus(request));
    Dispatch(request, push_model, ack);
  }
  
  virtual void Dispatch(RequestPtr request, const PushModel& push_model, AckStatusPtr ack) { Dispatch(push_model, ack); }
  virtual void Dispatch(const PushModel& push_model, AckStatusPtr ack) = 0;
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_PUSH_LISTENER_H_ */
