//
//  request.h
//  gaea
//
//  Created by guodi.ggd on 2019/1/7.
//  Copyright © 2019 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_REQUEST_H_
#define GAEA_LWP_REQUEST_H_

#include <stdio.h>

#include "gaea/lwp/message.h"

GAEA_LWP_NAMESPACE_BEGIN

class RequestContext;
typedef std::shared_ptr<RequestContext> RequestContextPtr;

class Request : public Message {
 public:
  Request();
  Request(const std::string& requestLine);
  ~Request();

  void set_need_auth(bool need_auth = true);
  bool need_auth();
  
  const void set_enable_retry(bool enable_retry) { enable_retry_ = enable_retry; }
  const bool enable_retry() { return enable_retry_; }
  
  void set_enable_auto_cache_key(bool enable_auto_cache_key) { enable_auto_cache_key_ = enable_auto_cache_key; }
  bool IsEnableAutoCacheKey() const { return enable_auto_cache_key_; }
  
  const std::string& request_line() const { return request_line_; }
  void set_request_line(const std::string& request_line) { request_line_ = request_line; }
  
  SiteType site_id() const { return site_id_; }
  void set_site_id(SiteType site_id) { site_id_ = site_id; }
  
  void set_cache_key(const std::string& cache_key) { cache_key_ = cache_key; }
  std::string cache_key();
  
  void set_remain_retry_count(int remain_retry_count) { remain_retry_count_ = remain_retry_count; }
  int remain_retry_count() { return remain_retry_count_--; }
  
  RequestContextPtr context() { return context_; }
  void set_context(RequestContextPtr context) { context_ = context; }
  
  std::string ToString() override;
  const void set_avalanche_limit(bool is_limit) { avalanche_limit_ = is_limit; }
  const bool avalanche_limit() { return avalanche_limit_; }
  
 protected:
  const std::string StartLine() override;
  void Initial();
  
 private:
  SiteType site_id_;
  bool need_auth_;
  std::string cache_key_;
  std::string request_line_;
  bool enable_auto_cache_key_;
  bool  enable_retry_;
  int remain_retry_count_;
  bool avalanche_limit_;
  RequestContextPtr context_;
};

typedef std::shared_ptr<Request> RequestPtr;

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_REQUEST_H_ */
