//
//  runtime_center.h
//  GaeaLwp
//
//  Created by Herb on 2019/5/22.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_RUNTIME_CENTER_H_
#define GAEA_LWP_RUNTIME_CENTER_H_
#include <mutex>
#include <string>
#include <thread>
#include "gaea/base/singleton.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN
  
class RunTimeCenter : public gaea::base::Singleton<RunTimeCenter>  {
 public:
  RunTimeCenter();
  virtual ~RunTimeCenter();
  
  /**
   * @brief 获取服务器时间
   */
  int64_t service_time();
  void set_service_time(int64_t service_time, int64_t rt_cost);
  
  bool IsInForeground() { return in_foreground_; }
  void EnterForeground();
  void EnterBackground();
  
 private:
  void UpdateLocalSetting();
  bool LoadLocalSetting();
  static const std::string kServiceTime;
  static const std::string kLocalTimeStamp;
  static const std::string kRtCost;
  
 private:
  bool in_foreground_;
  
  std::mutex timer_mutex_;
  int64_t service_time_;
  int64_t local_timestamp_;
  int64_t sys_start_timestamp_;
  int64_t rt_cost_;
  gaea::base::Logger logger_;
  std::string cache_file_;
};
  
GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_RUNTIME_CENTER_H_ */
