//
//  ua_util.h
//  GaeaLwp
//
//  Created by 司沐 on 2020/8/24.
//  Copyright © 2020 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_UA_UTIL_H_
#define GAEA_LWP_UA_UTIL_H_

#include <stdio.h>
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

class UA {
 public:
  UA();
  virtual ~UA();
  
  const std::string GenUA(std::string *err_msg = nullptr) const;
  
  const std::string &ua_version() const { return ua_version_; }
  void set_ua_version(const std::string &ua_version) { ua_version_ = ua_version; }
  
  const std::string &sdk_version() const { return sdk_version_; }
  void set_sdk_version(const std::string &sdk_version) { sdk_version_ = sdk_version; }
  
  const std::string &os_name() const { return os_name_;}
  void set_os_name(const std::string &os_name) { os_name_ = os_name; }

  const std::string &os_version() const { return os_version_; }
  void set_os_version(const std::string &os_version) { os_version_ = os_version; }

  const std::string &device_name() const { return device_name_; }
  //void set_device_name(const std::string &device_name) { device_name_ = device_name; }

  const std::string &device_type() const { return device_type_; }
  void set_device_type(const std::string &device_type) { device_type_ = device_type; }

  const std::string &device_locale() const { return device_locale_; }
  void set_device_locale(const std::string &device_locale) { device_locale_ = device_locale; }

  const std::string &app_name() const { return app_name_; }
  void set_app_name(const std::string &app_name) { app_name_ = app_name; }

  const std::string &app_version() const { return app_version_; }
  void set_app_version(const std::string &app_version) { app_version_ = app_version; }

  const std::string &app_locale() const { return app_locale_; }
  void set_app_locale(const std::string &app_locale) { app_locale_ = app_locale; }
  
 private:
  bool CheckSettings(std::string *err_msg = nullptr) const;
  const std::string JoinUASettingsToString() const;
  
 private:
  gaea::base::Logger logger_;
  
  std::string ua_version_;
  std::string os_name_;
  std::string os_version_;
  std::string device_name_;
  std::string device_type_;
  std::string device_locale_;
  std::string app_name_;
  std::string app_version_;
  std::string sdk_version_;
  std::string app_locale_;
};

GAEA_LWP_NAMESPACE_END

#endif /* GAEA_LWP_UA_UTIL_H_ */
