//
//  UserContext.hpp
//  GaeaLwp
//
//  Created by Herb on 2019/7/19.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef UserContext_hpp
#define UserContext_hpp

#include <stdio.h>
#include <string>
#include "gaea/service/aladdin_service.h"
#include "gaea/lwp/gaea_define.h"
#include "gaea/lwp/event_loop.h"
#include "gaea/lwp/setting.h"
#include "gaea/interface/trace/trace_interface.h"
#include "gaea/interface/setting/setting_interface.h"

GAEA_LWP_NAMESPACE_BEGIN

class UserContext {
public:
  const std::string DeviceId();
  /** 当前配置生效的配置信息 */
  UserAgentSettingPtr user_agent_setting_;
  std::function<void (const std::string& dye_mid, const std::string& trace_id)> CommitRelatedEvent_;
  EventLoopPtr session_eventloop_;
  EventLoopPtr file_eventloop_;
  EventLoopPtr net_eventloop_;
  EventLoopPtr callback_eventloop_;
  EventLoopPtr global_eventloop_;
  service::TraceInterfacePtr trace_service_;
  std::string unique_mark_;
  // extern config service
  service::SettingInterfacePtr setting_service_;
  gaea::lwp::AladdinServicePtr aladdin_service_;
};
typedef std::shared_ptr<UserContext> UserContextPtr;

GAEA_LWP_NAMESPACE_END

#endif /* UserContext_hpp */
