//
//  virtual_socket.h
//  DTOpenIMTaobaoContainerDemo
//
//  Created by guodi.ggd on 2019/5/13.
//  Copyright © 2019 dingtalk.com. All rights reserved.
//

#ifndef virtual_socket_h
#define virtual_socket_h

#include <memory>
#include <string>
#include "gaea/lwp/transfer_context.h"
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN
  // 其他的错误类型都认为异常错误
  enum ConnErrorType {
    kNoError    = 0,
    kConnFailed = 1,
    kDisconnect = 2,
    kNetworkChange = 3,
    kSendError  = 4,
    kOther      = 100
  };
  
  class VirtualSocketDelegate {
  public:
    virtual void OnRecv(const std::string& payload, TransferContextPtr transfer_context) = 0;
    virtual void OnConneted() = 0;
    virtual void OnError(ConnErrorType err_type) = 0;
  };
  typedef std::shared_ptr<VirtualSocketDelegate> VirtualSocketDelegatePtr;
  
  class VirtualSocket {
   public:
    VirtualSocket();
    virtual ~VirtualSocket() {};
    
    virtual void set_delegate(VirtualSocketDelegate* delegate) { delegate_ = delegate; };
    virtual int SendData(const std::string& data, TransferContextPtr transfer_context) = 0;
    virtual void Connect() = 0;
    virtual void Disconnect() = 0;
    
    static const std::string GetConnErrorTypeDescript(ConnErrorType err_type);
    
   protected:
    VirtualSocketDelegate* delegate_;
  };
  typedef std::shared_ptr<VirtualSocket> VirtualSocketPtr;
GAEA_LWP_NAMESPACE_END
#endif /* virtual_socket_h */
