//
//  network_service.h
//  GaeaLwp
//
//  Created by Herb on 2019/5/8.
//  Copyright © 2019年 DingTalk. All rights reserved.
//

#ifndef GAEA_LWP_NET_NETWORK_SERVICE_H_
#define GAEA_LWP_NET_NETWORK_SERVICE_H_

#include <functional>
#include <memory>
#include <string>

#include "gaea/base/logging.h"
#include <gaea/base/singleton.h>
#include "gaea/lwp/gaea_define.h"

GAEA_LWP_NAMESPACE_BEGIN

typedef enum {
  NET_NOT_REACHABLE = 0,
  NET_WIFI          = 1,
  NET_WIRE          = 2,
  NET_2G            = 3,
  NET_3G            = 4,
  NET_4G            = 5,
  NET_5G            = 6,
  NET_OTHER         = 100
} NetType;

class NetworkInterface {
public:
  /**
   * @function IsNetworkAvailable
   * @brief 表示当前连接的网络是否可用
   * @return true 网络可用; false 网络不可用;
   */
  virtual bool IsNetworkAvailable() = 0;
  virtual NetType net_type() = 0;
  virtual LocalIPStackType LocalIpstack() { return kLocalIPStackIPv4; }
};
typedef std::shared_ptr<NetworkInterface> NetworkInterfacePtr;
typedef std::function<void (bool)> NetworkChangeNotifyFunc;
  
class NetworkServiceDelegate {
public:
  NetworkServiceDelegate() {}
  virtual ~NetworkServiceDelegate() {}
  /**
   * @brief 接收底层网络状态变更通知
   */
  virtual void OnNetworkStatusChange(bool is_network_valid) {}
};
typedef std::shared_ptr<NetworkServiceDelegate> NetworkServiceDelegatePtr;
  
typedef std::function<void (bool netowrk_available)> NetworkChangeHookHanlder;
class NetworkService : public gaea::base::Singleton<NetworkService> {
public:
  NetworkService();
  virtual ~NetworkService() {}
  
  void set_impl(const NetworkInterfacePtr& network_impl);
//  void set_deleagte(NetworkServiceDelegatePtr delegate) { network_delegate_ = delegate; }
  
  virtual void OnNetworkStatusChange(bool is_network_valid);
  virtual void NotifyNetworkStatusChange(bool is_network_valid);
  /**
   * @function IsNetworkAvailable
   * @brief 表示当前连接的网络是否可用
   * @return true 网络可用; false 网络不可用;
   */
  virtual bool IsNetworkAvailable();
  
  bool RegisterListener(uint64_t listener_key, NetworkChangeHookHanlder);
  bool RemoveListener(uint64_t listener_key);
  
  virtual NetType net_type();
  std::string NetTypeName();
  void SetNetworkChangeNotifyFunc(NetworkChangeNotifyFunc net_change_callback);
  
  LocalIPStackType LocalIpstack();
private:
  gaea::base::Logger logger_;
  std::mutex mutex_;
  NetworkInterfacePtr network_impl_;
  NetworkServiceDelegatePtr network_delegate_;
  NetworkChangeNotifyFunc net_change_callback_;
  std::map<uint64_t, NetworkChangeHookHanlder> listener_map_;
};
    
GAEA_LWP_NAMESPACE_END


#endif /* GAEA_LWP_NET_NETWORK_SERVICE_H_ */
