function formatMoney(text) {
    if (!isRealNum(text)) return text;

    if (text > 1000000000000.0) {
        return (text / 1000000000000.0).toFixed(2) + "万亿";
    } else if (text > 100000000.0) {
        return (text / 100000000.0).toFixed(2) + "亿";
    } else if (text > 10000.0) {
        return (text / 10000.0).toFixed(2) + "万";
    } else if (text < -1000000000000.0) {
        return (text / 1000000000000.0).toFixed(2) + "万亿";
    } else if (text < -100000000.0) {
        return (text / 100000000.0).toFixed(2) + "亿";
    } else if (text < -10000.0) {
        return (text / 10000.0).toFixed(2) + "万";
    } else {
        return (text / 1.0).toFixed(2) + "";
    }
}

function formatMoneySimple(text) {
    if (!isRealNum(text)) return text;
    return (text / 100000000.0).toFixed(2);
}

function doubleFormat(text) {
    if (!isRealNum(text)) return text;
    return (text / 1.0).toFixed(2);
}

function isRealNum(val) {
    // isNaN()函数 把空串 空格 以及NUll 按照0来处理 所以先去除，
    if (val === "" || val == null) {
        return false;
    }
    if (!isNaN(val)) {
        //对于空数组和只有一个数值成员的数组或全是数字组成的字符串，isNaN返回false，例如：'123'、[]、[2]、['123'],isNaN返回false,
        //所以如果不需要val包含这些特殊情况，则这个判断改写为if(!isNaN(val) && typeof val === 'number' )
        return true;
    } else {
        return false;
    }
}