[[FX]]

// Samplers
sampler2D buf0 = sampler_state
{
	Address = Clamp;
};

// Uniforms
float postEffectTime = 0.0;

// Contexts
context FINALPASS
{
	VertexShader = compile GLSL VS_FSQUAD;
	PixelShader = compile GLSL FS_FINALPASS;
	
	ZWriteEnable = false;
}


[[VS_FSQUAD]]
// =================================================================================================

uniform mat4 projMat;
attribute vec3 vertPos;
varying vec2 texCoords;
				
void main( void )
{
	texCoords = vertPos.xy; 
	gl_Position = projMat * vec4( vertPos, 1 );
}



[[FS_FINALPASS]]
// =================================================================================================

uniform float postEffectTime;
uniform sampler2D buf0;
uniform vec2 frameBufSize;
varying vec2 texCoords;

vec2 curve(vec2 uv)
{
	uv = (uv - 0.5) * 2.0;
	uv *= 1.1;	
	uv.x *= 1.0 + pow((abs(uv.y) / 5.0), 2.0);
	uv.y *= 1.0 + pow((abs(uv.x) / 4.0), 2.0);
	uv  = (uv / 2.0) + 0.5;
	uv =  uv *0.92 + 0.04;
	return uv;
}               

void main(void)
{    
    vec2 q = gl_FragCoord.xy / frameBufSize.xy;
    vec2 uv = q;
    uv = curve( uv );
    
    vec3 oricol = texture2D( buf0, vec2(q.x,q.y) ).xyz;
    vec3 col;
	float x =  sin(0.3*postEffectTime+uv.y*21.0)*sin(0.7*postEffectTime+uv.y*29.0)*sin(0.3+0.33*postEffectTime+uv.y*31.0)*0.0017;

    col.r = texture2D(buf0,vec2(x+uv.x+0.001,uv.y+0.001)).x+0.05;
    col.g = texture2D(buf0,vec2(x+uv.x+0.000,uv.y-0.002)).y+0.05;
    col.b = texture2D(buf0,vec2(x+uv.x-0.002,uv.y+0.000)).z+0.05;
    col.r += 0.08*texture2D(buf0,0.75*vec2(x+0.025, -0.027)+vec2(uv.x+0.001,uv.y+0.001)).x;
    col.g += 0.05*texture2D(buf0,0.75*vec2(x+-0.022, -0.02)+vec2(uv.x+0.000,uv.y-0.002)).y;
    col.b += 0.08*texture2D(buf0,0.75*vec2(x+-0.02, -0.018)+vec2(uv.x-0.002,uv.y+0.000)).z;

    col = clamp(col*0.6+0.4*col*col*1.0,0.0,1.0);

    float vig = (0.0 + 1.0*16.0*uv.x*uv.y*(1.0-uv.x)*(1.0-uv.y));
	col *= vec3(pow(vig,0.3));

    // fenyesebb
    col *= vec3(0.95,1.05,0.95);
	col *= 3.8;

	float scans = clamp( 0.35+0.35*sin(3.5*postEffectTime+uv.y*frameBufSize.y*1.5), 0.0, 1.0);
	
	float s = pow(scans,1.7);
	col = col*vec3( 0.4+0.2*s) ;

    col *= 1.0+0.01*sin(110.0*postEffectTime);
	if (uv.x < 0.0 || uv.x > 1.0)
		col = vec3(0.0);
	if (uv.y < 0.0 || uv.y > 1.0)
		col = vec3(0.0);
	
	col*=1.0-0.65*vec3(clamp((mod(texCoords.x, 2.0)-1.0)*2.0,0.0,1.0));
	
	// Remove the next line to stop cross-fade between original and postprocess
    //float comp = smoothstep( 0.1, 0.9, sin(postEffectTime) );
	//col = mix( col, oricol, comp );

    gl_FragColor = vec4(col,1.0);
}