[[FX]]

// Samplers
sampler2D albedoMap;

// Uniforms
float effectFactor = 1;
float vertexOffsetX = 0;
float vertexOffsetY = 0;
float texOffsetX = 0;
float4 colorize = { 1.0, 1.0, 1.0, 1.0 };

// Contexts
context SPRITES
{
	VertexShader = compile GLSL VS_SPRITES;
	PixelShader = compile GLSL FS_SPRITES;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context ROAD
{
	VertexShader = compile GLSL VS_ROAD;
	PixelShader = compile GLSL FS_ROAD;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context SPRITES_LIGHTNESS
{
	VertexShader = compile GLSL VS_SPRITES_LIGHTNESS;
	PixelShader = compile GLSL FS_SPRITES;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context GAME_HSV
{
	VertexShader = compile GLSL VS_SPRITES;
	PixelShader = compile GLSL FS_GAME_HSV;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}


context SPRITES_HIGHP_TC
{
	VertexShader = compile GLSL VS_SPRITES_HIGHP_TC;
	PixelShader = compile GLSL FS_SPRITES_HIGHP_TC;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context SPRITES_TEX_OFFSET
{
	VertexShader = compile GLSL VS_SPRITES_TEX_OFFSET;
	PixelShader = compile GLSL FS_SPRITES;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context SPRITES_NO_COLORS
{
	VertexShader = compile GLSL VS_SPRITES_NO_COLORS;
	PixelShader = compile GLSL FS_SPRITES_NO_COLORS;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context GAMESPRITES
{
	VertexShader = compile GLSL VS_SPRITES;
	PixelShader = compile GLSL FS_GAMESPRITES;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}

context GAMESPRITES_LERP
{
	VertexShader = compile GLSL VS_SPRITES;
	PixelShader = compile GLSL FS_GAMESPRITES_LERP;
	
	ZWriteEnable = false;
	BlendMode = Blend;
}


[[VS_SPRITES]]

uniform mat4 viewProjMat;
uniform float vertexOffsetX;
uniform float vertexOffsetY;
attribute vec2 vertPos;
attribute vec2 texCoords0;
attribute vec4 vertColor;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
	vcolor = vertColor * (1.0/255.0);
	texCoords = texCoords0;
	gl_Position = viewProjMat * vec4( vertPos.x + vertexOffsetX, vertPos.y + vertexOffsetY, 1, 1 );
}

[[VS_SPRITES_LIGHTNESS]]

uniform mat4 viewProjMat;
uniform float vertexOffsetX;
uniform float vertexOffsetY;
uniform vec4 colorize;
attribute vec2 vertPos;
attribute vec2 texCoords0;
attribute vec4 vertColor;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
	vcolor = (colorize * vertColor) * (1.0/255.0);
	texCoords = texCoords0;
	gl_Position = viewProjMat * vec4( vertPos.x + vertexOffsetX, vertPos.y + vertexOffsetY, 1, 1 );
}


[[VS_SPRITES_HIGHP_TC]]

uniform mat4 viewProjMat;
uniform float vertexOffsetX;
uniform float vertexOffsetY;
attribute vec2 vertPos;
attribute vec2 texCoords0;
attribute vec4 vertColor;
varying highp vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
	vcolor = vertColor * (1.0/255.0);
	texCoords = texCoords0;
	gl_Position = viewProjMat * vec4( vertPos.x + vertexOffsetX, vertPos.y + vertexOffsetY, 1, 1 );
}



[[VS_SPRITES_TEX_OFFSET]]

uniform mat4 viewProjMat;
uniform float texOffsetX;
attribute vec2 vertPos;
attribute vec2 texCoords0;
attribute vec4 vertColor;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
	vcolor = vertColor * (1.0/255.0);
	texCoords = vec2(texCoords0.x+texOffsetX, texCoords0.y); 
	gl_Position = viewProjMat * vec4( vertPos.x, vertPos.y, 1, 1 );
}


[[FS_SPRITES]]

uniform lowp sampler2D albedoMap;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
	gl_FragColor = texture2D( albedoMap, texCoords ) * vcolor;
}


[[VS_ROAD]]

uniform mat4 viewProjMat;
attribute vec2 vertPos;
attribute vec2 texCoords0;
attribute vec4 vertColor;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;
varying highp vec2 world_vertex_pos;

void main( void )
{
	vcolor = vertColor * (1.0/255.0);

    world_vertex_pos = vertPos;
	texCoords = texCoords0;
	gl_Position = viewProjMat * vec4( vertPos.x, vertPos.y, 1, 1 );
}

[[FS_ROAD]]

uniform lowp sampler2D albedoMap;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;
varying highp vec2 world_vertex_pos;

uniform highp float vertexOffsetX;
uniform highp float vertexOffsetY;
uniform highp float effectFactor;

void main( void )
{
    // R: nem hasznalt    
    // G: a maszk (0 ha nem kell szinezni, 1 ha igen)
    // B: szurkearnyalatoskent a kep

    lowp vec4 texture_color = texture2D( albedoMap, texCoords );

    // hullamok
    const mediump float scale = 0.2;
    const mediump float speed = 3.0;
    highp float x = (world_vertex_pos.x - vertexOffsetX) / (150.0*scale);
    highp float y = (world_vertex_pos.y - vertexOffsetY) / (100.0*scale);
    mediump float r = sqrt((x*x) + (y*y));
    mediump float wave = 0.8 + 0.2*sin(r - effectFactor*speed);

    
    x = 0.75 + 0.25*sin(x*1.5);
    y = 0.75 + 0.25*sin(y);
    lowp vec3 col1 = vec3(x, y, 0.75 + 0.25*sin(3.0*effectFactor));

    lowp vec4 water_color = vec4(col1 * (texture_color.a*wave), texture_color.a);//texture_color * vcolor;
    lowp vec4 road_color = vec4(vec3(texture_color.b)*texture_color.a, texture_color.a) * vcolor;
        
    gl_FragColor = mix(road_color, water_color, texture_color.g);
}


[[FS_SPRITES_HIGHP_TC]]

uniform lowp sampler2D albedoMap;
varying highp vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
	gl_FragColor = texture2D( albedoMap, texCoords ) * vcolor;
}


[[VS_SPRITES_NO_COLORS]]

uniform mat4 viewProjMat;
uniform float vertexOffsetX;
uniform float vertexOffsetY;
attribute vec2 vertPos;
attribute vec2 texCoords0;
varying mediump vec2 texCoords;

void main( void )
{
	texCoords = texCoords0;
	gl_Position = viewProjMat * vec4( vertPos.x + vertexOffsetX, vertPos.y + vertexOffsetY, 1, 1 );
}


[[FS_SPRITES_NO_COLORS]]

uniform lowp sampler2D albedoMap;
varying mediump vec2 texCoords;

void main( void )
{
	gl_FragColor = texture2D( albedoMap, texCoords );
}


[[FS_GAMESPRITES]]

uniform lowp sampler2D albedoMap;
uniform lowp vec4 colorize;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
    lowp vec4 albedo = texture2D( albedoMap, texCoords ) * vcolor;
    lowp vec3 greyscale = vec3(dot(albedo.rgb, vec3(0.3, 0.59, 0.11)));
    gl_FragColor = vec4(greyscale, albedo.a) * colorize;
}


[[FS_GAMESPRITES_LERP]]
uniform lowp float effectFactor;
uniform lowp sampler2D albedoMap;
uniform lowp vec4 colorize;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
    lowp vec4 albedo = texture2D( albedoMap, texCoords ) * vcolor;
    lowp vec3 greyscale = vec3(dot(albedo.rgb, vec3(0.3, 0.59, 0.11)));
    lowp vec4 gcolor = vec4(greyscale, albedo.a) * colorize;
    lowp vec4 result = mix(albedo, gcolor, effectFactor);
    result.a = albedo.a;

    gl_FragColor = result;
}


[[FS_GAME_HSV]]

precision lowp float;

// Converts the rgb value to hsv, where H's range is -1 to 5
vec3 rgb_to_hsv(vec3 RGB)
{
    float r = RGB.x;
    float g = RGB.y;
    float b = RGB.z;

    float minChannel = min(r, min(g, b));
    float maxChannel = max(r, max(g, b));

    float h = 0.0;
    float s = 0.0;
    float v = maxChannel;

    float delta = maxChannel - minChannel;

    if (delta != 0.0) { 
        s = delta / v;

        if (r == v) h = (g - b) / delta;
        else if (g == v) h = 2.0 + (b - r) / delta;
        else /* b == v */ h = 4.0 + (r - g) / delta;
    }

    return vec3(h, s, v);
}

vec3 hsv_to_rgb(vec3 HSV)
{
    vec3 RGB = vec3(HSV.z);

    float h = HSV.x;
    float s = HSV.y;
    float v = HSV.z;

    float i = floor(h);
    float f = h - i;

    float p = (1.0 - s);
    float q = (1.0 - s * f);
    float t = (1.0 - s * (1.0 - f));

    if (i == 0.0) { RGB = vec3(1.0, t, p); }
    else if (i == 1.0) { RGB = vec3(q, 1.0, p); }
    else if (i == 2.0) { RGB = vec3(p, 1.0, t); }
    else if (i == 3.0) { RGB = vec3(p, q, 1.0); }
    else if (i == 4.0) { RGB = vec3(t, p, 1.0); }
    else /* i == -1.0 */ { RGB = vec3(1.0, p, q); }

    RGB *= v;

    return RGB;
}

uniform lowp float effectFactor;
uniform sampler2D albedoMap;
varying mediump vec2 texCoords;
varying mediump vec4 vcolor;

void main( void )
{
    vec4 albedo = texture2D( albedoMap, texCoords ) * vcolor;

    vec4 col = albedo;
    mediump vec3 hsv = rgb_to_hsv(col.xyz);

    hsv.x += effectFactor*6.0;    // 0..6

    // Put the hue back to the -1, 5 range
    if (hsv.x > 5.0)
        hsv.x -= 6.0;

    gl_FragColor = vec4(hsv_to_rgb(hsv), col.w);
}
