

var $ = require('../utils/jquery');


function ActionSheet(options) {
	this.initDom();
	this.init(options);
}

$.extend(ActionSheet.prototype, {
	initDom: function() {
		if (document.querySelector('#actionsheet-style')) {
			return;
		}
		var style = document.createElement('style');
		style.id = 'actionsheet-style';
		style.innerHTML = [
				'#hui-mask{position:fixed; z-index:20; background:rgba(0,0,0, 0.4); width:100%; left:0px; top:0px; height:100%;}',
				/*actionsheet*/
				'@keyframes hui-a-down{0%{bottom:-35px;} 100%{bottom:0}}',
				'@-moz-keyframes hui-a-down{0%{bottom:-35px;} 100%{bottom:0}}',
				'@-webkit-keyframes hui-a-down{0%{bottom:-35px;} 100%{bottom:0}}',
				'@-o-keyframes hui-a-down{0%{bottom:-35px;} 100%{bottom:0}}',
				'#hui-action-sheet{width:90%; position:fixed; z-index:21; left:5%; bottom:10px; background:#FFFFFF; animation:hui-a-down 100ms linear; -webkit-animation:hui-a-down 100ms linear; -moz-animation:hui-a-down 100ms linear; -o-animation:hui-a-down 100ms linear; border-radius:6px;}',
				'#hui-action-sheet li{width:100%; overflow:hidden; text-align:center; height:52px; line-height:52px; border-bottom:1px solid #EBEBEB; font-size:16px;color:#3388FF}',
				'#hui-action-sheet-cancel{border-top:3px solid #EBEBEB; color:#3388FF !important;}',
				'#hui-action-sheet.action_wrapper{background:transparent;width:96%;left:2%}#hui-action-sheet.action_wrapper ul{background:#fff;border-radius:10px}#hui-action-sheet.action_wrapper ul:first-child li:last-child{border:0}#hui-action-sheet.action_wrapper ul:last-child{margin-top:10px}#hui-action-sheet.action_wrapper ul:last-child li{border:0}'
			].join('');

		document.querySelector('head').appendChild(style);
	},
	init: function(options){
		this.actionSheet(options.menus,options.cancel,options.callback,options.options)
	},
	actionSheet: function(menus,cancel,callback,options) {
		 	var _that = this;
			this.maskShow();
			_that.options = options;
			_that.fixBody(true,_that.options);
			var huiActionSheet = document.getElementById('hui-action-sheet');
			if(!huiActionSheet){
				var huiActionSheet = document.createElement('div');
				huiActionSheet.setAttribute('id', 'hui-action-sheet');
				huiActionSheet.setAttribute('class', 'action_wrapper');
				document.body.appendChild(huiActionSheet);
				huiActionSheet = document.getElementById('hui-action-sheet');
			}
			var actionSheets = '<ul>';
			for(var i = 0; i < menus.length; i++){actionSheets += '<li huiASId="'+i+'">'+menus[i]+'</li>';}
			// huiActionSheet.innerHTML = actionSheets + '<li id="hui-action-sheet-cancel" huiASId="-1">'+cancel+'</li></ul>';
			huiActionSheet.innerHTML = actionSheets + '</ul>'+'<ul> <li id="hui-action-sheet-cancel" huiASId="-1">'+cancel+'</li></ul>';
			this.mask.removeEventListener('click', _that.actionSheetClose.bind(_that));
			this.mask.addEventListener('click',_that.actionSheetClose.bind(_that));
			
			$(huiActionSheet).find('li').click(function(){
				this.index = this.getAttribute('huiASId');  _that.actionSheetClose();callback(this);
			})
	
	},
	maskShow: function(){
		this.mask = document.getElementById('hui-mask');
		if(!this.mask){
			this.mask = document.createElement('div');
			this.mask.setAttribute('id', 'hui-mask');
			document.body.appendChild(this.mask);
		}
	},
	maskHide :function(){if(this.mask){document.body.removeChild(this.mask);}},
	actionSheetClose: function(){
		var _that = this;
		// console.log(this);
		this.maskHide();
		_that.fixBody(false,_that.options);
		var huiActionSheet = document.getElementById('hui-action-sheet');
		if(huiActionSheet){document.body.removeChild(huiActionSheet);}
	},
	fixBody: function(isFixed,options){
		var bodyEl = document.body
		var  top = options.top;
		if (isFixed) {
			bodyEl.style.position = 'fixed'
			bodyEl.style.top = -top + 'px';
			bodyEl.style.left = 0 + 'px';
			bodyEl.style.right = 0 + 'px';
			
		} else {
			bodyEl.style.position = '';
			bodyEl.style.top = '';
			bodyEl.style.left = '';
			bodyEl.style.right = '';
			window.scrollTo(0, top) // 回到原先的top
		}
	}
});


module.exports = function(options) {
    // new ActionSheet({
    //     menus: ['微信', '支付宝'],
    //     cancel: '取消',
    //     callback: function(e){
    //        if(e.index === 0){ //微信对应的函数}
    //        if(e.index === 1){ //支付宝对应的函数}
    // if(e.index === -1){ 取消对应的函数}
    //     }
    // });
	return new ActionSheet(options);
};