

var hosts = require('../utils/hosts');
var app = require('../utils/app_api');
var tool = require('../utils/tool');
var $ = require('../utils/jquery');
var mobile = require('../utils/mobile');
var apis = require('./apis');
var maps = require('./maps');
var xalert = require('../utils/xalert');

module.exports.pageonload = function() {
	$('#pre-loading').remove();
	// $('#wrapper').removeClass('hide');
	$('#wrapper').addClass('in');
}

module.exports.networkError = function(message) {
	app.hideWaiting();
	xalert({
		content: message ? message : '网络异常，请检查您的网络状态！',
		button: {
			ok: {
				text: '好的',
				callback: function() {
					this.remove();
				}
			},
			no:{
				text:''
			}
		}
	});
}

module.exports.getMyScore = function(success) {
	app.ajax({
		url: apis.myScore,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			if (response.State == 1) {
				success && success(response.Result);
			}
			else if (response.State == 100) {
				success && success(0);
			}
		},
		error: function(e) {
			module.exports.networkError();
		}
	});
}

module.exports.itemslist = function(options) {
	var self = this,
		options = $.extend(true, {
			container: null,
			params: {
				webSiteId: mobile.appInfo().cityId,
				category: '',
				pageIndex: 1,
				pageSize: 10
			}
		}, options);

	if (!options.container) {
		return;
	}

	this.IsRenderedIndex = false;//首页数据是否已经加载完毕
	this.curSiteConfig = [];//配置项html字串

	this.getItems = function(isAppend) {
		var $appendloading;
		if (self.itemsLoading) {
			return;
		}
		self.itemsLoading = true;
		options.params.pageIndex = isAppend ? options.params.pageIndex + 1 : options.params.pageIndex;
		
		if (isAppend) {
			options.container.append('<div class="loading" style="text-align:center; padding: 20px 0; color: #666; font-size: 14px;">加载中...</div>');
		}

		app.ajax({
			url: apis.items,
			params: options.params,
			success: function(response) {
				if (!response) {
					return;
				}
				if (typeof response == 'string') {
					response = JSON.parse(response);
				}
				if (response.State == 1) {
					// console.log(response.List)
					self.getItemsSuccess(response, isAppend);
					// if(!isAppend){
						// 删除兑吧的商品
					// 	self.getDuibaItems();
					// }
				}
				else if (response.State == 100) {
					self.getItemsFail(response, isAppend);
				}
			},
			error: function() {
				module.exports.networkError();
			},
			complete: function() {
				options.container.find('.loading').remove();
				self.itemsLoading = false;
			}
		});
	};

	this.getDuibaItems = function(){
		var self = this;
		app.ajax({
			url : "http://exshop.108sq.net/access/duiba/freelanding?dbredirect=http%3A%2F%2Fhome.m.duiba.com.cn%2Ffloor%2F3%2F0%3FduibaPageId%3D3%26floorId%3D677%26skinId%3D881%26_%3D1533189846019%26callback%3Djsonp3",
			
			type : 'GET',
			params : {
				
			},
	
			success : function(response){
				
			


				if(response.code == 1){
					window.jsonp3 = function(res){
						// alert(res);
						if(res.success){
							var list  = res.list;
								// list{image link title credits}
							
							options.container.append(self.getDuibaHTMLItems(list));
						}
						
					};
					var script = document.createElement('script');
					script.src = response.data;
					document.body.appendChild(script);

					
				}
			},
			error  : function(){
				
			}
		})
	};

	this.getDuibaHTMLItems = function(data) {
		var items = [];

		//计算图片高度
		var imgHeght =($(document).width() -12)/2 -12;

		var self = this;
		$.each(data, function(index) {		
			var type = '', code = this.Code, status = this.Status, lotteryStatus = this.LotteryStatus,classStyle='goods-price-icon',rmb='积分',scoreClass = 'goods-price';
	
			var score = this.credits;
			var href = 'http:' + this.link;
			var image = 'http:'+ this.image;
		
			items.push('<a class="list-grid-goods" href="' + href + '"><div class="goods-image goods-image1 flex flex-center" style="height:'+imgHeght+'px;">' + type + '<img src="' + image + '" width="100%"  ></div><div class="goods-title textoverflow">' + this.title + '</div><b class="'+scoreClass+'">' + score + '</b><i class="'+classStyle+'">'+rmb+'</i></a>');
			
			
		});

		
		return items.join('');
		
	};

	this.getItemsSuccess = function(response, isAppend) {
		var self = this;
		if (isAppend) {
			options.container.append(self.getHtmlItems(response.List));
		}
		else {

			this.IsRenderedIndex = true;
			var items = self.getHtmlItems(response.List,true);
			if(self.curSiteConfig.length){
				var imgHeght =($(document).width() -12)/2 -12;
				for(var i=0;i<self.curSiteConfig.length;i++){
					var order = parseInt(self.curSiteConfig[i]['order']) - 1;
					if(items[order]){
						items.splice(order,0,self.getConfigItem(self.curSiteConfig[i],imgHeght))
					}else{
						items.push(self.getConfigItem(self.curSiteConfig[i],imgHeght))
					}
				}
			}
			options.container.html(items.join(''));
		}
		var scrollLoadEvent = function() {
			self.loadAppendItems();
		};
		if (!isAppend && response.PagedProps.PageCount > options.params.pageIndex) {
			$(document).get(0).onscroll = scrollLoadEvent;
		}
		if (response.PagedProps.PageCount <= options.params.pageIndex) {
			$(document).get(0).onscroll = null;//off('scroll', scrollLoadEvent);
		}
	};
	this.getItemsFail = function(response, isAppend) {
		if (response.List.length === 0) {
			self.showEmpty();
		}
	};
	this.showEmpty = function() {
		options.container.html('<div class="list-grid-empty"><div class="list-grid-empty-icon"></div><p>备货中...</p></div>');
	};
	this.loadAppendItems = function() {
		var self = this;

		if (($(window).height() + $(window).scrollTop()) >= ($(document).height() - 10)) {
			self.getItems(true);
		}
	};
	this.getTime = function(datetime) {
		var date = datetime.replace(/T|:/g, '-').split('-');
		return new Date(date[0], date[1] - 1, date[2], date[3], date[4], date[5]).getTime()
	};
	this.getHtmlItems = function(data,bool) {
		var items = [];

		//计算图片高度
		var imgHeght =($(document).width() -12)/2 -12;

		var self = this;
		$.each(data, function(index) {
			/*if(!self.isfirstline){ //第一行不加分割线
				self.isfirstline =true;
			}else{
				if(index%2 == 0 && self.isfirstline){
					items.push('<div class="line"></div>');
				}
			}*/
				
			var type = '', code = this.Code, status = this.Status, lotteryStatus = this.LotteryStatus,classStyle='goods-price-icon',rmb='积分',scoreClass = 'goods-price';
			if ((this.Status == 1 && this.ItemType == 1)) {
				type = '<span class="goods-type goods-type-convert">兑换</span>';
			}
			else if(this.Status == 1 && this.ItemType == 4){
				type = '<span class="goods-type goods-type-preferential">优惠购</span>';
				classStyle = "goods-price-rmbicon";
				scoreClass ='goods-rmbPrice';
				rmb = "元";
			}
			else if (this.Status == 1 && this.ItemType == 2) {
				type = '<span class="goods-type goods-type-lottery">抽奖</span>';
			}
			else if (this.Status == 1 && this.ItemType == 3 /*&& this.ItemCount > 0*/) {
				var hour12 = 12 * 60 * 60 * 1000;
				var time = {
					start: self.getTime(this.StartTime),
					end: self.getTime(this.EndTime),
					now: self.getTime(this.NowTime)
				};

				if (time.start - time.now > hour12) {
					type = '<span class="goods-type goods-type-rush">抢兑</span>';
				}
				// 即将开抢
				else if (time.start > time.now && time.start - time.now < hour12) {
					type = '<span class="goods-type goods-type-rush">即将开抢</span>';
				}
				// 立即兑换
				else if (time.start < time.now && time.end > time.now) {
					type = '<span class="goods-type goods-type-rush">抢兑中</span>';
				}
				else {
					type = '<span class="goods-type goods-type-end">备货中</span>';
				}
				// type = '<span class="goods-type goods-type-rush">抢兑</span>';
				// if (this.EndTime) {
				// 	var eTime = this.EndTime.replace(/T|:/g, '-').split('-');
				// 	var timestampEnd = new Date(eTime[0], eTime[1], eTime[2], eTime[3], eTime[4], eTime[5]).getTime();
				// 	var timestampNow = new Date().getTime();
				// 	if (timestampNow > timestampEnd) {
				// 		type = '<span class="goods-type goods-type-end">备货中</span>';
				// 	}
				// }
			}
			else if (this.Status == 2) {
				type = '<span class="goods-type goods-type-end">备货中</span>';
				
				if(this.ItemType == 4){
					classStyle = "goods-price-rmbicon";
					scoreClass ='goods-rmbPrice';
					rmb = "元";
				}
			}

			// else if (this.Status == 3) {
			// 	type = '<span class="goods-type goods-type-end">已售罄</span>';
			// }
			// module.exports.limitBuy({
			// 	code: code,
			// 	status: status,
			// 	lotteryStatus: lotteryStatus,
			// 	before: function() {
			// 		type = '<span class="goods-type goods-type-end">即将开抢</span>';
			// 	},
			// 	now: function() {
			// 		type = '<span class="goods-type goods-type-convert">兑换</span>';
			// 	},
			// 	after: function() {
			// 		type = '<span class="goods-type goods-type-end">备货中</span>';
			// 	},
			// 	empty: function() {
			// 		type = '<span class="goods-type goods-type-end">抢完了</span>';
			// 	}
			// });
			
			var score = this.Score;
			var href = maps.detail(this.Id, this.Name);
			if (this.Name == '0积分免费抽奖') {
				//score = 0;
				//href = 'scratch_card.html';
				//items.push('<a class="list-grid-goods" href="indiana/index.html"><div class="goods-image" style="height:'+imgHeght+'px;"><img src="' + this.ImageUrl + '" width="100%" height="'+imgHeght+'"></div><div class="goods-title">积分夺宝，透明开奖</div><b class="'+scoreClass+'"></b><i class="'+classStyle+'" style="margin:0;">凑齐人数就开奖~</i></a>');
			}else{
				items.push('<a class="list-grid-goods" href="' + href + '"><div class="goods-image" style="height:'+imgHeght+'px;">' + type + '<img src="' + this.ImageUrl + '" width="100%" height="'+imgHeght+'"></div><div class="goods-title">' + this.Name + '</div><b class="'+scoreClass+'">' + score + '</b><i class="'+classStyle+'">'+rmb+'</i></a>');
			}
			
		});

		if(bool){
			return items;
		}else{
			return items.join('');
		}
	};
	this.renderConfig = function(){
		var self = this;
		if(tool.isBeforeVersion('3.11.2')){
			return;
		}
		var siteId= tool.appInfo().cityId;
		
		tool.loadScript(hosts.common+'/ZT/config/integral_shop_newconfig.js',function(){
			//计算图片高度
			var imgHeght =($(document).width() -12)/2 -12;
			var config = window.integral_shop_config;
			var curSiteConfig = config['common'];
			/*$.each(config,function(){
				if(options.params.category == this.category){
					item.push('<a class="list-grid-goods" href="'+this.link+'" data-isLogin="'+this.isLogin+'"><div class="goods-image" style="height:'+imgHeght+'px;"><img src="' + this.ImageUrl + '" width="100%" height="'+imgHeght+'"></div><div class="goods-title">'+this.title+'</div><b class="goods-price"></b><i class="goods-price-icon" style="margin:0;">'+this.descript+'</i></a>');
				}
			})
			if(self.IsRenderedIndex){
				if(options.container.find('.list-grid-goods').length){
					options.container.prepend(item.join(''))
				}
			}else{
				self.configHtmlStr = item.join('');
			}*/
			if(config['site_'+siteId]){
				curSiteConfig = config['common'].concat(config['site_'+siteId])
			}
			curSiteConfig.sort(function(a,b){
				return a.order - b.order;
			})
			if(self.IsRenderedIndex){
				if(options.container.find('.list-grid-goods').length){
					
					$.each(curSiteConfig,function(){
						if(options.params.category == this.category){
							var $flagEle = options.container.find('.list-grid-goods').eq(parseInt(this.order)-1);
							var str = self.getConfigItem(this,imgHeght);
							if($flagEle && $flagEle.length){
								$flagEle.before(str);
							}else{
								options.container.append(str)
							}
						}
					})
				}
			}else{
				self.curSiteConfig = curSiteConfig;
			}

			options.container.on('click','.list-grid-goods[data-config]',function(e){
				if (!app.getToken()) {
					if($(this).attr('data-isLogin') == "true"){
						app.toLogin(true);
						e.preventDefault();
						return;
					}
				}
				if($(this).attr('data-ajax') == "true"){
					e.preventDefault();
					var _this = this;
					if($(_this).hasClass('sending')){
						return;
					}
					$(_this).addClass('sending');
					app.ajax({
						url: $(_this).attr('href'),
						params: {},
						success: function(response) {
							if(response.code  == 1){
								location.href = response.data;
							}else{
								module.exports.networkError(response.message);
							}
						},
						error: function() {
							module.exports.networkError();
						},
						complete: function() {
							$(_this).removeClass('sending');
						}
					})
				}
			})
		})	
	};
	this.configTypeArray={
		'兑换':'goods-type-convert',
		'优惠购':'goods-type-preferential',
		'抽奖':'goods-type-lottery',
		'抢兑':'goods-type-rush',
		'即将开抢':'goods-type-rush',
		'抢兑中':'goods-type-rush',
		'备货中':'goods-type-end',
		'卡券':'goods-type-kq',
		'default':'goods-type-default'
	};
	this.getConfigItem = function(data,imgHeght){
		if(data.tag != options.params.category && options.params.category !='热门推荐'){
			return '';
		}
		var typeArray=self.configTypeArray;
		var type = typeArray[data.tag] ? typeArray[data.tag] : typeArray['default'];
		var link = data.link;
		var isAjax = '';
		if(data.from == "duiba"){
			var link = data.link;
			isAjax = true;
		}
		return [
			'<a class="list-grid-goods" href="'+link+'" data-isLogin="'+data.isLogin+'" data-ajax="'+isAjax+'" data-config="true">',
				'<div class="goods-image" style="height:'+imgHeght+'px;">',
					data.tag ? '<span class="goods-type '+type+'">'+data.tag+'</span>' : '',
					'<img src="' + data.ImageUrl + '" width="100%" height="'+imgHeght+'">',
				'</div>',
				'<div class="goods-title">'+data.title+'</div>',
				'<b class="goods-price"></b>',
				'<i class="goods-price-icon" style="margin:0;">'+data.descript+'</i>',
			'</a>'
		].join('');
	}

	this.getItems();
	this.renderConfig();
}

$(document).on('ChangJSBridgeReady', function() {
	app.hideMoreMenu();
});

module.exports.limitBuy = function(options) {
	var options = $.extend({}, {
		code: '',
		status: '',
		lotteryStatus: '',
		before: '',
		now: '',
		after: '',
		empty: ''
	}, options);
	if (options.code && options.code == 'HF-CZKQD10') {
		// if (options.lotteryStatus > 1) {
			if (options.lotteryStatus == 2) {
				options.before && options.before();
			}
			else if (options.status == 1 && options.lotteryStatus == 3) {
				options.now && options.now();
			}
			else if (options.lotteryStatus == 4) {
				options.empty && options.empty();
			}
			else {
				options.after && options.after();
			}
		// }
		// else if (options.lotteryStatus == 1) {
		// 	options.after && options.after();
		// }
	}
}

module.exports.isVersionBefore = function(versionRefer) {
	var version = app.getAppInfo().version;
	var versionArr = version.split('.');
	var versionReferArr = versionRefer.split('.');
	var result = false;
	for (var i = 0; i < versionReferArr.length; i++) {
		var diff = versionArr[i] - versionReferArr[i];
		if (diff > 0){
			result = false;
			break;
		} else if (diff < 0){
			result = true;
			break;
		}
	}
	return result;
}

module.exports.CONST_PAY_TYPES = {
	1: '积分',
	2: '金币'
}

module.exports.ScoreGoodType = 1; // 福利抢兑
module.exports.LotteryGoodType = 2; // 积分抽奖
module.exports.RedpackGoodType = 3; // 红包兑换
module.exports.CashGoodType = 4; // 现金兑换
module.exports.NewUserGoodType = 5; // 新人专享

// 物品类型
module.exports.GoodsTypeCash = 1; // 现金
module.exports.GoodsTypeCharge = 2; // 话费
module.exports.GoodsTypePhysical = 4; // 实物
module.exports.GoodsTypeCoupon = 6; // 优惠券
module.exports.GoodsTypeRedpack = 7; // 消费红包
