var hosts = require('../../utils/hosts');
var app = require('../../utils/app_api');
var $ = require('../../utils/jquery');
var mobile = require('../../utils/mobile');
var xalert = require('../../utils/xalert');

var apis={
	lotteryResult : hosts.duobao + "/api/Reward/RewardResult",//本期开奖结果:phaseId={phaseId}
	lotteryResultList : hosts.duobao + "/api/Reward/RewardList",//往期开奖列表:pageIndex={pageIndex}&pageSize={pageSize}&actionId={actionId}
	indianaList : hosts.duobao + "/api/Duobao/DuobaoList",//夺宝商品列表:pageIndex={pageIndex}&pageSize={pageSize}&siteId={siteId}
	indiana : hosts.duobao + "/api/Order/Buy",//夺宝:phaseId={phaseId}&buyNumber={buyNumber}
	myJoinIndianaCount: hosts.duobao + "/api/Order/MyOrderCount",//我参与的夺宝次数:phaseId={phaseId}
	myJoinIndiana: hosts.duobao + "/api/Order/MyOrder",//我这期参与的夺宝:pageIndex={pageIndex}&pageSize={pageSize}&phaseId={phaseId}
	myAllIndiana:hosts.duobao + "/api/Order/MyAllOrder",//我参与的所有夺宝，分已揭晓和为揭晓。
	indianaDetail:hosts.duobao + "/api/Duobao/ItemInfo",//夺宝详情:phaseId={phaseId}
	indianaDescript:hosts.duobao + "/api/Duobao/ItemIntro",//商品描述:phaseId={phaseId}
	recentIndiana:hosts.duobao + "/api/Duobao/LastDuobaoPhaseId",//最新一期:actionId={actionId}
	countDetail:hosts.duobao + "/api/Reward/RewardInfo",//计算详情
	myScore: hosts.shop + '/API/shop/MyScore', //积分
	isBindMobile:hosts.main + '/Api/AppUserInfo' //检测是否绑定手机
}

/*
 *本期开奖结果
	{
	"State": 1,
	"Result": {"DuobaoPhaseId": 1,"UserId": 2,"UserName": "sample string 3","OrderId": 4,"DuobaoPeopleNumber": 5,"RewardTime": 6}
	}
*/
module.exports.lotteryResult = function(params,success) {
	app.ajax({
		url: apis.lotteryResult,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			success && success(response);
		},
		error: function(e) {
			module.exports.networkError();
		}
	});
}

/*
 *往期开奖列表
	{
	  "State": 1,
	  "PagedProps": {"Count": 1,"PageCount": 2,"PageSize": 3,"PageIndex": 2},
	  "List": [{}]
	 }
*/
module.exports.lotteryResultList = function(params,success,error) {
	app.ajax({
		url: apis.lotteryResultList,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*
 *商品列表
 {
  "State": 1,
  "PagedProps": {"Count": 1,"PageCount": 2,"PageSize": 3,"PageIndex": 2},
  "List": [{"DuobaoPhaseId": 0,"DuobaoPrice": 2.0,"DuobaoMaxBuyNumber": 3,"DuobaoBuyNumber": 4,"PhaseStatus": 0,"ActionId": 5,"ActionName": "sample string 6","ItemImages": "sample string 7","ItemPrice": 8.0}]
 }
*/
module.exports.indianaList = function(params,success,error) {
	var params =$.extend({
		siteId: mobile.appInfo().cityId,
		pageIndex: 1,
		pageSize: 10
	},params);
	app.ajax({
		url: apis.indianaList,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*
 *夺宝
 {
  "State": 1,
  "Result": {"DuobaoPhaseId": 1,"OrderTime": 2,"OrderCode": "sample string 3"}
 }
*/
module.exports.indiana = function(params,success,error) {
	app.ajax({
		url: apis.indiana,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*
 *夺宝次数
 {
  "State": 0,
  "Result": 1
}
*/
module.exports.myJoinIndianaCount = function(params,success,error) {
	app.ajax({
		url: apis.myJoinIndianaCount,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*
 *本期夺宝记录
 {
  "State": 1,
  "PagedProps": {"Count": 1,"PageCount": 2,"PageSize": 3,"PageIndex": 2},
  "List": [{}]
 }
*/
module.exports.myJoinIndiana = function(params,success,error) {
	app.ajax({
		url: apis.myJoinIndiana,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*
 *所有夺宝记录
 {
  "State": 1,
  "PagedProps": {"Count": 1,"PageCount": 2,"PageSize": 3,"PageIndex": 2},
  "List": [{}]
 }
*/
module.exports.myAllIndiana = function(params,success,error) {
	app.ajax({
		url: apis.myAllIndiana,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}


/*
 *夺宝详情
*/
module.exports.indianaDetail = function(params,success,error) {
	app.ajax({
		url: apis.indianaDetail,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}


/*
 *计算详情
*/
module.exports.countDetail = function(params,success,error) {
	app.ajax({
		url: apis.countDetail,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}
/*
 *商品描述
*/
module.exports.indianaDescript = function(params,success,error) {
	app.ajax({
		url: apis.indianaDescript,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

module.exports.networkError = function(msg) {
	app.hideWaiting();
	xalert({
		content: msg || '网络异常，请检查您的网络状态！',
		button: {
			ok: {
				text: '好的',
				callback: function() {
					this.remove();
				}
			},
			no:{
				text:''
			}
		}
	});
}
/*
 *获得我的积分
*/
module.exports.getMyScore = function(success) {
	app.ajax({
		url: apis.myScore,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			if (response.State == 1) {
				success && success(response.Result);
			}
			else if (response.State == 100) {
				success && success(0);
			}
		},
		error: function(e) {
			//module.exports.networkError();
		}
	});
}

/*
 *最新一期
*/
module.exports.recentIndiana = function(params,success,error) {
	app.ajax({
		url: apis.recentIndiana,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*
 *检测是否绑定手机
*/
module.exports.isBindMobile = function(params,success,error) {
	app.ajax({
		url: apis.isBindMobile,
		params : params,
		success: function(response) {
			if (!response) {
				return;
			}
			if (typeof response == 'string') {
				response = JSON.parse(response);
			}
			
			success && success(response);
		},
		error: function(e) {
			error && error();
			module.exports.networkError();
		}
	});
}

/*toast提示*/
module.exports.tips =function(message){
	var str= ['<section class="tips" id="tips">',
			   	message,
			   '</section>'].join('');
	var tips = $(str);
	$('body').append(tips);
	var tid = window.setTimeout(function() {
			tips.css({'-webkit-opacity':1,'opacity':1});
			tid = window.setTimeout(function() {
				tips.css('opacity', 0);
				tid = window.setTimeout(function() {
					tips.remove();
					tid = null;
				}, 1000);
			}, 2000);
	}, 10);
}

module.exports.pageonload = function() {
	$('#pre-loading').remove();
}

// if (navigator.userAgent.toLowerCase().indexOf('pc') >= 0) {
// 	app.getToken = function() {
// 		return 'asdas';
// 	};
// 	app.getUserId = function() {
// 		return '14261';
// 	};
// 	app.ajax = function(options) {
// 		var options = $.extend({}, {
// 			type: 'GET',
// 			url: '',
// 			params: {},
// 			success: null,
// 			error: null,
// 			complete: null
// 		}, options);

// 		$.ajax({
// 			type: options.type,
// 			url: options.url,
// 			data: options.params,
// 			dataType:'jsonp',
// 			success: function(response) {
// 				options.success && options.success(response);
// 			},
// 			error: function(response) {
// 				options.error && options.error(response);
// 			},
// 			complete: function(response) {
// 				options.complete && options.complete(response);
// 			}
// 		});
// 	};
// 	window.onload = function() {
// 		window.bridgeEvent = document.createEvent('Event');
// 		window.bridgeEvent.initEvent('ChangJSBridgeReady', false, false);
// 		document.dispatchEvent(window.bridgeEvent);
// 	};
// }

