(function(global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
        typeof define === 'function' && define.amd ? define(factory) :
        global.moment = factory()
}(this, function() {
    'use strict';

    return {
        _hasMethod: function(name) {
            return !!window['ChangShuoJSBridge'] && !!window['ChangShuoJSBridge'][name];
        },
        _callMethod: function(name) {
            if (!this._hasMethod(name)) {
                return;
            }
            return window['ChangShuoJSBridge'][name].apply(window['ChangShuoJSBridge'], Array.prototype.slice.call(arguments).slice(1));
        },
        appWebShare: function(json) {
            /*
                {isShow:true,title:"",describe:"",shareImg:"",link:"",immediate:false}
            */
            return this._callMethod('appWebShare', JSON.stringify(json));
        },
        pay: function(payInfo, payType) {
            return this._callMethod('pay', payInfo, payType);
        },
        showWaiting: function(sTips) {
            return this._callMethod('showWaiting', sTips);
        },
        showToast: function(message) {
            return this._callMethod('showToast', message);
        },
        hideWaiting: function() {
            return this._callMethod('hideWaiting');
        },
        toLogin: function(isReloadOnSuccess) {
            return this._callMethod('toLogin', isReloadOnSuccess);
        },
        getToken: function() {
            return this._callMethod('getToken');
        },
        getEncryptMobile: function() {
            return this._callMethod('getEncryptMobile');
        },
        getEncodeMobileFlag: function() {
            return this._callMethod('getEncodeMobileFlag');
        },
        getUTDID: function() {
            return this._callMethod('getUTDID');
        },
        getImeiID: function() {
            return this._callMethod('getImeiID');
        },
        getWeixinToken: function() {
            return this._callMethod('getWeixinToken');
        },
        hideMoreMenu: function() {
            return this._callMethod('hideMoreMenu');
        },
        getUserId: function() {
            return this._callMethod('getUserId');
        },
        getUserName: function() {
            return this._callMethod('getUserName');
        },
        getAppInfo: function () {
            var ua = window.navigator.userAgent,
                isAndroid = /android/i.test(ua),
                isIPhone = /iphone/i.test(ua),
                isDebug = /pc/i.test(ua);
            if (/108sq/i.test(ua)) {
                var reg = /108sq\/([^/]*)\/([^/]*)\/([^/]*)\/([^/]*)$/i;
                var match = ua.match(reg);
                return {
                    name: '108sq',
                    version: match ? match[1] : '',
                    cityId: match ? match[2] : '',
                    channelName: match ? match[3] : '',
                    netType: match ? match[4] : '',
                    isAndroid: isAndroid,
                    isIPhone: isIPhone,
                    isDebug: isDebug
                };
            }
            else {
                return null;
            }
        },
        isShareable: function() {
            return this._hasMethod('shareWebPageToWeiXin');
        },
        shareWebPageToWeiXin: function(title, titleUrl, content, imageUrl) { //titleUrl必填
            return this._callMethod('shareWebPageToWeiXin', title, titleUrl, content, imageUrl);
        },
        shareWebPageToWeiXinFriends: function(title, titleUrl, imageUrl) { //titleUrl必填
            return this._callMethod('shareWebPageToWeiXinFriends', title, titleUrl, '', imageUrl);
        },
        closePopAct: function() { //关闭网页发帖插件页面方法
            return this._callMethod('closePopAct');
        },
        openNativePub: function(json) { //{forumTag:'',//板块标签forumName:'',//板块别名topic:'',//话题content:'',//帖子内容images:'' //图片链接，多张以逗号隔开}
            return this._callMethod('openNativePub', JSON.stringify(json));
        },
        hideRightNav: function(bool) { //true隐藏，false不隐藏
            return this._callMethod('hideRightNav', bool);
        },
        shareWebPage: function(config) {
            //config={
            // 	"title":"",
            //	"titleUrl":"",
            //	"content":"",
            //	"imageUrl":"",
            //	"shareType":1:QQ分享2:QQ空间分享3:微信分享4:微信朋友圈分享 int
            //	"infoid":"" 非必填
            //  "isImage": 默认false:不是纯图片，true:是纯图片
            // }
            return this._callMethod('shareWebPage', JSON.stringify(config)); //
        },
        startNewWebView: function(url) {
            if (this._hasMethod('startNewWebView')) {
                return this._callMethod('startNewWebView', url);
            } else {
                location.href = url;
            }
        },
        getSiteDomain: function() {
            return this._callMethod('getSiteDomain');
        },
        getSiteCityName: function() {
            return this._callMethod('getSiteCityName');
        },
        webStatistics: function(jsonstr) {
            return this._callMethod('webStatistics', jsonstr);
        },
        updateUserInfo:function(type){//积分商城设置用户挂件和购买封面成功，通知客户端更新用户信息。type:ser/buy
            return this._callMethod('updateUserInfo',type);
        },
        openWebWindow : function(url, params){
            return this._callMethod('openWebWindow', url, params || '');
        },
        closeWebWindow: function(config){
            if (typeof config === 'object') {
                config = JSON.stringify(config);
            }
            return this._callMethod('closeWebWindow', config);
        },
        openWidget: function(params) {
            var callbackName = '';
            if (params.callback) {
                var random = parseInt(Math.random() * 1000000000000 + 1000000000000);
                callbackName = 'OPEN_WIDGET_' + random;
                window[callbackName] = params.callback;
            }
            var params = {
                widgetName: params.widgetName,
                widgetPath: params.widgetPath,
                isClose: params.isClose !== undefined ? params.isClose : false,
                toLogin: params.toLogin !== undefined ? params.toLogin : false,
                callback: callbackName
            };
            // return 0: 成功，1: 失败。
            return this._callMethod('openWidget', JSON.stringify(params));
        },
        openImagesWithIndex:function(config){
             /**
              * 查看图片详情
              * 客户端 3.14.0增加此方法
              * @param {Object} config - 参数对象
              *   @param {Array} config.images - 图片url数组，不带域名的情况下客户端会默认加上photoshow的域名
              *   @param {Number} config.index - 当前需要展示的图片所在的images的index
             */
            var _defalut = {
                index: config.index || 0,
                images: config.images ? config.images.join(',') : ''
            }
            return this._callMethod('openImagesWithIndex', JSON.stringify(_defalut))
        },
        ajax: function(configs) {

            var defaults = {
                    type: 'GET',
                    url: '',
                    waiting: '',
                    params: {},
                    success: null,
                    error: null,
                    complete: null,
                    isNeedDecode: false
                },
                options = {};
            for (var i in defaults) {
                options[i] = configs.hasOwnProperty(i) ? configs[i] : defaults[i];
            }
            var j2p = function(json) {
                var a = [];
                for (var i in json) a.push(i + '=' + json[i]);
                return a.join('&');
            };
            var random  =  parseInt(Math.random()  *  1000000000000  +  1000000000000);
            var success = '',
                error = '',
                complete = '';
            if (options.success) {
                success = 'APP_CALLBACK_SUCCESS_' + random;
                window[success] = function(response) {
                    if (typeof response == 'string') {
                        response = JSON.parse(response);
                    }
                    options.success && options.success.call(window, response);
                };
            }
            if (options.error) {
                error = 'APP_CALLBACK_ERROR_' + random;
                window[error] = function() {
                    options.error && options.error.call(window);
                };
            }
            if (options.complete) {
                complete = 'APP_CALLBACK_COMPLETE_' + random;
                window[complete] = function() {
                    options.complete && options.complete(window);
                };
            }

            var params = {
                type: options.type.toUpperCase(),
                url: options.url,
                isNeedDecode: options.isNeedDecode,
                waiting: options.waiting,
                params: j2p(options.params),
                success: success,
                error: error,
                complete: complete
            };
            //判断是否是本地文件

            //this._callMethod('ajax', JSON.stringify(params));
            if (!this._hasMethod('ajax')) {
                alert('您的客户端版本过低，请升级客户端！');
                return;
            }
            this._callMethod('ajax', JSON.stringify(params));

        },
        jajax: function(params, data) {
            var self = this;
            $.ajax({
                type: params.type,
                url: params.url,
                data: data,
                headers: {
                    'Access-Token': self.getToken()
                },
                success: window[params.success],
                error: window[params.error],
                complete: window[params.complete]
            });
        },
        multiImageUpload:function(configs){//多图上传，3.13版本开始支持
            var defaults = {
                    // 最大边长
                    maxwidth: 0,

                    // 图片质量 0-100
                    quality: 100,

                    dataType: 'json',
                    images:[],
                    maxNum:9,
                    start: null,
                    cancel: null,
                    complete: null
                },
                options = {};
            for (var i in defaults) {
                options[i] = configs.hasOwnProperty(i) ? configs[i] : defaults[i];
            }
            var j2p = function(json) {
                var a = [];
                for (var i in json) a.push(i + '=' + json[i]);
                return a.join('&');
            };
            var random  =  parseInt(Math.random()  *  1000000000000  +  1000000000000);
            var start = '',
                cancel = '',
                complete = '';
            if (options.start) {
                start = 'APP_UPLOAD_CALLBACK_START_' + random;
                window[start] = function(response) {
                    if (options.dataType == 'json' && typeof response !== 'object') {
                        response = JSON.parse(response);
                    } else if (options.dataType == 'text') {
                        if (typeof response == 'object') {
                            response = JSON.stringify(response);
                        }
                    }
                    options.start &&  options.start.call(window, response);
                };
            }
            if (options.cancel) {
                cancel = 'APP_UPLOAD_CALLBACK_CANCEL_' + random;
                window[cancel] = function() {
                    options.cancel && options.cancel(window);
                };
            }
            if (options.complete) {
                complete = 'APP_UPLOAD_CALLBACK_COMPLETE_' + random;
                window[complete] = function(response) {
                    if(response){
                        if (options.dataType == 'json' && typeof response !== 'object') {
                            response = JSON.parse(response);
                        } else if (options.dataType == 'text') {
                            if (typeof response == 'object') {
                                response = JSON.stringify(response);
                            }
                        }
                    }
                    options.complete &&  options.complete.call(window, response);
                };
            }
            var params = {
                maxwidth: options.maxwidth,
                quality: options.quality,
                maxNum:options.maxNum,
                images:options.images,
                start: start,
                cancel: cancel,
                complete: complete
            };
            this._callMethod('multiImageUpload', JSON.stringify(params));
        },
        openUpload: function(configs) {
            var defaults = {
                    url: '',
                    waiting: '',
                    // 最大边长
                    maxwidth: 0,

                    // 图片质量 0-100
                    quality: 100,

                    dataType: 'json',
                    params: {},
                    start: null,
                    cancel: null,
                    success: null,
                    failure: null,
                    complete: null
                },
                options = {};
            for (var i in defaults) {
                options[i] = configs.hasOwnProperty(i) ? configs[i] : defaults[i];
            }
            var j2p = function(json) {
                var a = [];
                for (var i in json) a.push(i + '=' + json[i]);
                return a.join('&');
            };
            var random  =  parseInt(Math.random()  *  1000000000000  +  1000000000000);
            var start = '',
                cancel = '',
                success = '',
                failure = '',
                complete = '';
            if (options.start) {
                start = 'APP_UPLOAD_CALLBACK_START_' + random;
                window[start] = function() {
                    options.start && options.start(window);
                };
            }
            if (options.cancel) {
                cancel = 'APP_UPLOAD_CALLBACK_CANCEL_' + random;
                window[cancel] = function() {
                    options.cancel && options.cancel(window);
                };
            }
            if (options.complete) {
                complete = 'APP_UPLOAD_CALLBACK_COMPLETE_' + random;
                window[complete] = function() {
                    options.complete && options.complete(window);
                };
            }
            if (options.success) {
                success = 'APP_UPLOAD_CALLBACK_SUCCESS_' + random;
                window[success] = function(response) {
                    if (options.dataType == 'json' && typeof response !== 'object') {
                        response = JSON.parse(response);
                    } else if (options.dataType == 'text') {
                        if (typeof response == 'object') {
                            response = JSON.stringify(response);
                        }
                    }
                    options.success && options.success.call(window, response);
                };
            }
            if (options.failure) {
                failure = 'APP_UPLOAD_CALLBACK_FAILURE_' + random;
                window[failure] = function(response) {
                    if (options.dataType == 'json' && typeof response !== 'object') {
                        response = JSON.parse(response);
                    } else if (options.dataType == 'text') {
                        if (typeof response == 'object') {
                            response = JSON.stringify(response);
                        }
                    }
                    options.failure && options.failure.call(window, response);
                };
            }
            if (options.complete) {
                complete = 'APP_CALLBACK_COMPLETE_' + random;
                window[complete] = function() {
                    options.complete && options.complete(window);
                };
            }

            var params = {
                url: options.url,
                waiting: options.waiting,
                params: j2p(options.params),
                maxwidth: options.maxwidth,
                quality: options.quality,
                start: start,
                cancel: cancel,
                success: success,
                failure: failure,
                complete: complete
            };
            this._callMethod('openUpload', JSON.stringify(params));
        },
        subscribeTouchAction:function(config){//定制下拉刷新或上滑加载
            var trigger;
            var random  =  parseInt(Math.random()  *  1000000000000  +  1000000000000);

            if (config.trigger) {
                trigger = 'APP_CALLBACK_TOUCHTRIGGER_' + random;
                window[trigger] = function(type) {
                    config.trigger && config.trigger(type);
                };
            }
            var params = {
                refresh:config.refresh ? true : false,
                load:config.load ? true : false,
                trigger: trigger ? trigger : ''
            }

            return this._callMethod('subscribeTouchAction',JSON.stringify(params));
        },
        completeTouchAction:function(type){
            type = type ? type : '';
            return this._callMethod('completeTouchAction',type);
        },
        showErrorPage:function(){
            return this._callMethod('showErrorPage');
        },
        checkOpenPromotion:function() {
            return this._callMethod('checkOpenPromotion');
        },
        playRewardVideoAd:function (params) {//视频签到播放视频
            return this._callMethod('playRewardVideoAd',JSON.stringify(params));
        },
        // 前往任务中心页
        toTaskCenter: function () {
            return this._callMethod('toTaskCenter');
        },
        // 显示获得金币的提示
        showGoldCoinTip: function(config){
            if (typeof config === 'object') {
                config = JSON.stringify(config);
            }
            return this._callMethod('showGoldCoinTip', config);
        },
        // 刷新「我的页面」红点状态
        refreshCount: function(){
            return this._callMethod('refreshCount');
        }
    };
}));
