

(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    global.moment = factory()
}(this, function () { 'use strict';
	var $ = require('./zepto');
	
	var debug = /debug/.test(navigator.userAgent);

	var mobile = {};
	$.extend(mobile, {
		alert: function(message) {
			if (!debug) return;
			alert(message);
		},
		getQueryString: function(k, s) {
		     var r, t, s = s || '?';
		     k = k.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
		     r = new RegExp("[\\" + s + "&]" + k + "=([^&#]*)");
		     t = r.exec(window.location.href);
		     return (null == t) ? "": t[1];
		},
		// getQueryString: function(name) {
		//     var reg = new RegExp('[?&]' + name + '=(.*?)(&|$)', 'i');
		//     var match = location.search.match(reg);
		//     return match ? decodeURIComponent(match[1]) : '';
		// },
		appInfo: function() {
	        var ua = window.navigator.userAgent;
			if (/108sq/i.test(ua)) {
		        var reg = /108sq\/([^/]*)\/([^/]*)\/([^/]*)\/([^/]*)$/i;
		        var match = ua.match(reg);
		        return {
		            name : '108sq',
		            version : match ? match[1] : '',
		            cityId : match ? match[2] : '',
		            channelName : match ? match[3] : '',
		            netType : match ? match[4] : ''
		        };
			}
			else {
				return null;
			}
	    },
	    isMobile: function() {
			var userAgentInfo = navigator.userAgent;  
			var Agents = new Array("Android", "iPhone", "SymbianOS", "Windows Phone", "iPad", "iPod");  
			var flag = false;  
			for (var v = 0; v < Agents.length; v++) {  
			   if (userAgentInfo.indexOf(Agents[v]) > 0) { flag = true; break; }  
			}  
			return flag; 
		},
		isAndroid: function() {
			return /android/i.test(navigator.userAgent);
		},
		isIPhone: function() {
			return /iphone/i.test(navigator.userAgent);
		},
		isIPad: function() {
			return /ipad/i.test(navigator.userAgent);
		},
		isWeixin: function() {
			return /micromessenger/i.test(navigator.userAgent);
		},
		validator: {
			phone: function(number) {
				return /^1[3|4|5|8|7][0-9]\d{8}$/.test(number);
			}
		},
		beforeVersion: function(version) {
			var appInfo = this.appInfo();
			if (appInfo && appInfo.version) {
				var thisVersions = appInfo.version.split('.'),
					versions = version.split('.');
				for(var i = 0, l = versions.length; i < l; i ++) {
					if (parseInt(versions[i]) > parseInt(thisVersions[i])) {
		                return true;
		            }
		            else if (parseInt(versions[i]) == parseInt(thisVersions[i])) {
		                continue;
		            }
		            else {
		                return false;
		            }
				}
			}
			return false;
		}
	});
	
	/**
	 * mobile.encodeHTML & mobile.decodeHTML
	 */
	;(function() {

		if (mobile.encodeHTML) return;

		var $window = $(window), $document = $(document);

		var htmlDecodeDict = { "quot": '"', "lt": "<", "gt": ">", "amp": "&", "nbsp": " " };
		var htmlEncodeDict = { '"': "quot", "<": "lt", ">": "gt", "&": "amp", " ": "nbsp" };

		$.extend(mobile, {
			/**
			 * HTML解码
			 * @param {String} html
			 */
			decodeHTML: function(html) {
				return String(html).replace(/&(quot|lt|gt|amp|nbsp);/ig, function(all, key) {
					return htmlDecodeDict[key];
				}).replace(/&#u([a-f\d]{4});/ig, function(all, hex) {
					return String.fromCharCode(parseInt("0x" + hex));
				}).replace(/&#(\d+);/ig, function(all, number) {
					return String.fromCharCode(+number);
				});
			},

			/**
			 * HTML编码
			 * @param {String} html 
			 */
			encodeHTML: function(html) {
				return String(html).replace(/["<>& ]/g, function(all) {
					return "&" + htmlEncodeDict[all] + ";";
				});
			}
		});

	}) ();

	/**
	 * mobile.dialog
	 */
	;(function() {

		if (mobile.dialog) return;

		var $window = $(window), $document = $(document);

		var defaults = {
			content: '',
			width: 0,
			minWidth: 0,
			height: 0,
			minHeight: 0,
			no: '',
			ok: '',
			callback: {
				init: null,
				close: null,
				hide: null,
				show: null,
				no: null,
				ok: null
			}
		};

		function Dialog(options) {
			
			var self = this, options = $.extend(true, {}, defaults, options);

			self.wrap = $('<div class="x-dialog"><div class="x-dialog-layout"><div class="x-dialog-content"></div><div class="x-dialog-button"><a class="x-dialog-no" href="javascript:;"></a><a class="x-dialog-ok" href="javascript:;"></a></div></div></div>');
			self.wrap.content = self.wrap.find('.x-dialog-content');
			self.wrap.layout = self.wrap.find('.x-dialog-layout');

			self.setWrapHeight = function() {
				self.wrap.css('height', Math.max($document.height(), $window.height(), document.documentElement.clientHeight));
			};
			self.init = function() {

				$document.find('body').append(self.wrap);

				// self.listenScrollEvent();

				// $(window).resize(function() {
				// 	self.listenScrollEvent();
				// });
				
				self.setWrapHeight();
				self.wrap.layout.css({
					marginTop: - (self.wrap.layout.height() / 2)
				});
				self.show();

				$window.on('resize', self.setWrapHeight);
				options.callback.init && options.callback.init.apply(self);
			}
			self.show = function() {
				self.wrap.addClass('x-dialog-in');
				// self.listenScrollEvent();
				options.callback.show && options.callback.show.apply(self);
			};
			self.hide = function(timeout) {
				self.wrap.removeClass('x-dialog-in');
				setTimeout(function() {
					self.wrap.hide();
					timeout && timeout();
				}, 200);
				// self.unListenScrollEvent();
				options.callback.hide && options.callback.hide.apply(self);
			};
			self.close = function() {
				self.hide(function() {
					self.wrap.remove();
					$window.off('resize', self.setWrapHeight);
				});

				// self.unListenScrollEvent();
				options.callback.close && options.callback.close.apply(self);
			};
			self.content = function(html) {
				self.wrap.find('.x-dialog-content').html(html);
			};
			// self.unListenScrollEvent = function() {
			// 	options.timerScrollTop && window.clearInterval(options.timerScrollTop);
			// };
			// self.listenScrollEvent = function() {

			// 	options.timerScrollTop = window.setInterval(function() {
			// 		self.wrap.css('top', $window.scrollTop())
			// 		self.wrap.css('height', $window.height());
			// 	}, 20);

			// 	window.setTimeout(function() {
			// 		self.unListenScrollEvent();
			// 	}, 1000);
			// };

			self.initStyle = function() {
				var style = document.createElement('style');
				style.id = 'x-dialog-style';
				style.innerHTML = ['.x-dialog { width: 100%; text-align: center; background: rgba(0, 0, 0, 0.5); overflow: hidden; position: absolute; top: 0; left: 0;bottom: 0; right:0;z-index:1000; opacity: 0; -webkit-transition: opacity 0.2s ease-out;}',
				'.x-dialog-in { opacity: 1; }',
				'.x-dialog-layout { display: inline-block; font-size: 17px; line-height: 1.6em; background: #FFFFFF; position: fixed; top: 50%; left: 10px; right: 10px; border-radius: 5px;}',
				'.x-dialog-content { text-align: center; padding: 20px; box-sizing: border-box;}',
				'.x-dialog-button { padding: 0 0 20px;}',
				'.x-dialog-no, .x-dialog-ok { display: inline-block; min-width: 90px; height: 32px; line-height: 32px; font-size: 14px; color: #20ce5a; vertical-align: middle; padding: 0 10px; margin: 0 15px; background: #FFFFFF; border: 1px solid #20ce5a; border-radius: 5px; box-sizing: border-box;}',
				'.x-dialog-ok { color: #FFFFFF; background: #20ce5a; border: none;}'].join('');

				$('head').append(style);
			};
			if ($('#x-dialog-style').size() == 0) {
				self.initStyle();
			}

			self.content(options.content);

			options.width && self.wrap.content.css('width', options.width);
			options.minWidth && self.wrap.content.css('minWidth', options.minWidth);
			options.height && self.wrap.content.css('height', options.height);
			options.minHeight && self.wrap.content.css('minHeight', options.minHeight);

			if (options.no) {
				self.wrap.find('.x-dialog-no').html(options.no).click(function() {
					self.close();
					options.callback.no && options.callback.no.apply(self);
				});
			}
			else {
				self.wrap.find('.x-dialog-no').remove();
			}

			if (options.ok) {
				self.wrap.find('.x-dialog-ok').html(options.ok).click(function() {
					options.callback.ok && options.callback.ok.apply(self);;
				});
			}
			else {
				self.wrap.find('.x-dialog-ok').remove();
			}

			if (!options.no && !options.ok) {
				self.wrap.find('.x-dialog-button').remove();
			}

			self.wrap.on({
				'touchmove': function(event) {
					// event.preventDefault();
				}
			});
			// alert($window.scrollTop())

			self.init();
		}

		$.extend(mobile, {
			dialog: function(options) {
				return new Dialog(options);
			}
		});

	}) ();

	
	return mobile;
}));