/*
 
 File: AppSpecificValues.h
 Abstract: Basic introduction to GameCenter
 
 Version: 1.1
 
 Disclaimer: IMPORTANT:  This Apple software is supplied to you by Apple Inc.
 ("Apple") in consideration of your agreement to the following terms, and your
 use, installation, modification or redistribution of this Apple software
 constitutes acceptance of these terms.  If you do not agree with these terms,
 please do not use, install, modify or redistribute this Apple software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Apple grants you a personal, non-exclusive license, under
 Apple's copyrights in this original Apple software (the "Apple Software"), to
 use, reproduce, modify and redistribute the Apple Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Apple Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Apple Software.
 Neither the name, trademarks, service marks or logos of Apple Inc. may be used
 to endorse or promote products derived from the Apple Software without specific
 prior written permission from Apple.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Apple herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Apple Software may be
 incorporated.
 
 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2010 Apple Inc. All Rights Reserved.
 
 */

//These constants are defined in iTunesConnect, and will function as long
//  as this sample is built/run with the existing bundle identifier
//  (com.appledts.GKTapper).  If you want to experiment with this sample and
//  iTunesConnect, you'll need to define you're own bundle ID and iTunes
//  Connect configurations.  This sample uses reverse DNS for Leaderboards
//  and Achievement IDs, but this is not a requirement.  Any string that
//  iTunes Connect will accept will work fine.


#if (CC_TARGET_PLATFORM != CC_PLATFORM_ANDROID)


#define LW1PLUS 0
#define LW1 0
#define LW2 1
#define LW3 0
#define LWZ 0
#define ANDROID 0

//Leaderboard Category IDs
#define kLeaderboard1ID  @"grp.at.ner.lepsWorld2.LeaderPoints"  //at.ner.lepsWorld2.LeaderPointsP
#define kLeaderboard2ID  @"grp.at.ner.lepsWorld2.LeaderCoins"   //at.ner.lepsWorld2.LeaderCoinsP
#define kLeaderboard3ID  @"grp.at.ner.lepsWorld2.LeaderLevels"  //at.ner.lepsWorld2.LeaderLevelsP
#define kLeaderboard4ID  @"grp.at.ner.lepsWorld2.LeaderKills"   //at.ner.lepsWorld2.LeaderKillsP
#define kLeaderboard5ID  @"grp.at.ner.lepsWorld2.LeaderBlocks"  //at.ner.lepsWorld2.LeaderBlocksP

#define kLeaderboard6ID  @"grp.at.ner.lepsWorld2.LeaderBlocks"  //at.ner.lepsWorld2.LeaderBlocksP


//Achievement IDs
#define kAchievement1         @"grp.at.ner.lepsWorld2.Ach1"   // - 500 Coins
#define kAchievement2         @"grp.at.ner.lepsWorld2.Ach2"   // - 1.000 Coins
#define kAchievement3         @"grp.at.ner.lepsWorld2.Ach3"   // - 5.000 Coins
#define kAchievement4         @"grp.at.ner.lepsWorld2.Ach4"   // - 05 Stunden
#define kAchievement5         @"grp.at.ner.lepsWorld2.Ach5"   // - 10 Stunden
#define kAchievement6         @"grp.at.ner.lepsWorld2.Ach6"   // - Facebook
#define kAchievement7         @"grp.at.ner.lepsWorld2.Ach7"   // - Twitter
#define kAchievement8         @"grp.at.ner.lepsWorld2.Ach8"   // - Credits
#define kAchievement9         @"grp.at.ner.lepsWorld2.Ach9"   // - 1 min Speedrun
#define kAchievement10         @"grp.at.ner.lepsWorld2.Ach10"  // - all Stars
#define kAchievement11         @"grp.at.ner.lepsWorld2.Ach11"  // - 100 Items
#define kAchievement12         @"grp.at.ner.lepsWorld2.Ach12"  // - all levels
#define kAchievement13         @"grp.at.ner.lepsWorld2.Ach13"  // - World 1
#define kAchievement14         @"grp.at.ner.lepsWorld2.Ach14"  // - World 2
#define kAchievement15         @"grp.at.ner.lepsWorld2.Ach15"  // - World 3
#define kAchievement16         @"grp.at.ner.lepsWorld2.Ach16"  // - World 4
#define kAchievement17         @"grp.at.ner.lepsWorld2.Ach17"  // - World 5
#define kAchievement18         @"grp.at.ner.lepsWorld2.Ach18"  // - World 6
#define kAchievement19         @"grp.at.ner.lepsWorld2.Ach19"  // - World 7
#define kAchievement20         @"grp.at.ner.lepsWorld2.Ach20"  // - World 8
#define kAchievement21         @"grp.at.ner.lepsWorld2.Ach21"  // - 250 Kills
#define kAchievement22         @"grp.at.ner.lepsWorld2.Ach22"  // - 1.000 Kills

#else


#define LW1PLUS 0
#define LW1 0
#define LW2 1
#define LW3 0
#define LWZ 0
#define ANDROID 1

#if LW3

// Leaderboard Category IDs
    #define kLeaderboard1ID "CgkIzNXdxZAdEAIQAQ"
    #define kLeaderboard2ID "CgkIzNXdxZAdEAIQBQ"
    #define kLeaderboard3ID "CgkIzNXdxZAdEAIQBg" //easy levels
    #define kLeaderboard4ID "CgkIzNXdxZAdEAIQBw"
    #define kLeaderboard5ID "CgkIzNXdxZAdEAIQCA"
    #define kLeaderboard6ID "CgkIzNXdxZAdEAIQHA" //all level

    // Achievement IDs
    #define kAchievement1 "CgkIzNXdxZAdEAIQAg"   // - 500 Coins
    #define kAchievement2 "CgkIzNXdxZAdEAIQCQ"   // - 1.000 Coins
    #define kAchievement3 "CgkIzNXdxZAdEAIQCg"   // - 5.000 Coins
    #define kAchievement4 "CgkIzNXdxZAdEAIQCw"   // - 05 Stunden
    #define kAchievement5 "CgkIzNXdxZAdEAIQDA"   // - 10 Stunden
    #define kAchievement6 "CgkIzNXdxZAdEAIQDQ"   // - Facebook
    #define kAchievement7 "CgkIzNXdxZAdEAIQDg"   // - Twitter
    #define kAchievement8 "CgkIzNXdxZAdEAIQDw"   // - Credits
    #define kAchievement9 "CgkIzNXdxZAdEAIQEA"   // - 1 min Speedrun
    #define kAchievement10 "CgkIzNXdxZAdEAIQEQ"  // - all Stars
    #define kAchievement11 "CgkIzNXdxZAdEAIQEg"  // - 100 Items
    #define kAchievement12 "CgkIzNXdxZAdEAIQEw"  // - all levels
    #define kAchievement13 "CgkIzNXdxZAdEAIQFA"  // - World 1
    #define kAchievement14 "CgkIzNXdxZAdEAIQFQ"  // - World 2
    #define kAchievement15 "CgkIzNXdxZAdEAIQFg"  // - World 3
    #define kAchievement16 "CgkIzNXdxZAdEAIQFw"  // - World 4
    #define kAchievement17 "CgkIzNXdxZAdEAIQGA"  // - World 5
    #define kAchievement21 "CgkIzNXdxZAdEAIQGQ"  // - 250 Kills
    #define kAchievement22 "CgkIzNXdxZAdEAIQGg"  // - 1.000 Kills
    #define kAchievement18 "" //TODO: change
    #define kAchievement19 ""
    #define kAchievement20 ""


#elif LW1

// Leaderboard Category IDs
#define kLeaderboard1ID "CgkIjszxkrgBEAIQAQ" // - Points
#define kLeaderboard2ID "CgkIjszxkrgBEAIQAg" // - Coins
#define kLeaderboard3ID "CgkIjszxkrgBEAIQAw" // - Levels (new Easy Levels)
#define kLeaderboard4ID "CgkIjszxkrgBEAIQBA" // - Kills
#define kLeaderboard5ID "CgkIjszxkrgBEAIQBQ" // - Blocks
#define kLeaderboard6ID "CgkIjszxkrgBEAIQEA" // - All Levels


// Achievement IDs
#define kAchievement1 "CgkIjszxkrgBEAIQBg"   // - 1000 Coins
#define kAchievement2 "CgkIjszxkrgBEAIQBw"   // - first world
#define kAchievement3 "CgkIjszxkrgBEAIQCA"   // - 250 kills
#define kAchievement4 "CgkIjszxkrgBEAIQCQ"   // - facebook
#define kAchievement5 "CgkIjszxkrgBEAIQCg"   // - all levels
#define kAchievement6 "CgkIjszxkrgBEAIQCw"   // - Destroyer
#define kAchievement7 "CgkIjszxkrgBEAIQDA"   // - Invulnerable

//dummies
#define kAchievement8 ""
#define kAchievement9 ""
#define kAchievement10 ""
#define kAchievement11 ""
#define kAchievement12 ""
#define kAchievement13 ""
#define kAchievement14 ""
#define kAchievement15 ""
#define kAchievement16 ""
#define kAchievement17 ""
#define kAchievement18 ""
#define kAchievement19 ""
#define kAchievement20 ""
#define kAchievement21 ""
#define kAchievement22 ""

#elif LW2

// Leaderboard Category IDs
    #define kLeaderboard1ID "CgkIgJqk6OEIEAIQAQ"
    #define kLeaderboard2ID "CgkIgJqk6OEIEAIQAg"
    #define kLeaderboard3ID "CgkIgJqk6OEIEAIQAw"
    #define kLeaderboard4ID "CgkIgJqk6OEIEAIQBA"
    #define kLeaderboard5ID "CgkIgJqk6OEIEAIQBQ"
    #define kLeaderboard6ID "CgkIgJqk6OEIEAIQHQ"

    // Achievement IDs
    #define kAchievement1 "CgkIgJqk6OEIEAIQBg"   // - 500 Coins
    #define kAchievement2 "CgkIgJqk6OEIEAIQBw"   // - 1.000 Coins
    #define kAchievement3 "CgkIgJqk6OEIEAIQCA"   // - 5.000 Coins
    #define kAchievement4 "CgkIgJqk6OEIEAIQCQ"   // - 05 Stunden
    #define kAchievement5 "CgkIgJqk6OEIEAIQCg"   // - 10 Stunden
    #define kAchievement6 "CgkIgJqk6OEIEAIQCw"   // - Facebook
    #define kAchievement7 "CgkIgJqk6OEIEAIQDA"   // - Twitter
    #define kAchievement8 "CgkIgJqk6OEIEAIQDQ"   // - Credits
    #define kAchievement9 "CgkIgJqk6OEIEAIQDg"   // - 1 min Speedrun
    #define kAchievement10 "CgkIgJqk6OEIEAIQDw"  // - all Stars
    #define kAchievement11 "CgkIgJqk6OEIEAIQEA"  // - 100 Items
    #define kAchievement12 "CgkIgJqk6OEIEAIQEQ"  // - all levels
    #define kAchievement13 "CgkIgJqk6OEIEAIQEg"  // - World 1
    #define kAchievement14 "CgkIgJqk6OEIEAIQEw"  // - World 2
    #define kAchievement15 "CgkIgJqk6OEIEAIQFA"  // - World 3
    #define kAchievement16 "CgkIgJqk6OEIEAIQFQ"  // - World 4
    #define kAchievement17 "CgkIgJqk6OEIEAIQFg"  // - World 5
    #define kAchievement18 "CgkIgJqk6OEIEAIQFw"  // - World 6
    #define kAchievement19 "CgkIgJqk6OEIEAIQGA"  // - World 7
    #define kAchievement20 "CgkIgJqk6OEIEAIQGQ"  // - World 8
    #define kAchievement21 "CgkIgJqk6OEIEAIQGg"  // - 250 Kills
    #define kAchievement22 "CgkIgJqk6OEIEAIQGw"  // - 1.000 Kills

    #elif LWZ

    #define kLeaderboard1ID "CgkIr4ftzpIBEAIQAw"
    #define kLeaderboard2ID "CgkIr4ftzpIBEAIQBA"
    #define kLeaderboard3ID "CgkIr4ftzpIBEAIQAg"
    #define kLeaderboard4ID "CgkIr4ftzpIBEAIQBQ"
    #define kLeaderboard5ID "CgkIr4ftzpIBEAIQBg"
    #define kLeaderboard6ID "CgkIr4ftzpIBEAIQBg"

#endif

#endif