var $M=Emp;
Emp.Component = Emp.extend(Emp.Object, {
	getModelId : function() {
		return this.modelId
	},
	setId : function(id) {
		this.id = id;
		Emp.components[id] = this;
	},
	getId : function() {
		return this.id;
	},
	getChildObjectById : function(id) {
		if (id == this.getModelId()) {
			return this;
		}
		for ( var i = 0; i < this.children.lenght; i++) {
			return this.children[i].getChildObjectById(id);
		}
		return null;
	},
	addEvent : function(methodName, callback) {
		this.content.events.push(methodName + "");
		// 如果render之后直接调
		this.fireMethod("addEvent", methodName);
		// 加到js中去
		Emp.addEvent(this.modelId + methodName, callback, this)
	},
	removeEvent :function(eventType){
		delete Emp.events[this.modelId + eventType];
	},
	fireMethod : function(methodName, args) {
		if (!methodName) {
			return;
		}
		if (this.isRender) {
			var s = {};
			s.method = methodName;
			if (args != null) {
				s.value = args;
			}
		return	empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	init : function(json) {
		this.modelId = Emp.getObjectUUId();

		this.isRender = false;
		// log("对象init方法的Id："+getObjectId());
		if (json != undefined) {
			this.content = json;
			if (json.id != null)
					{
					Emp.components[json.id] = this;
						this.id=json.id;				
					}
			
		} else {
			this.content = {};
		}
		if (this.content.width == "100%") {
			this.content.width = Emp.ViewSize.FillParent;
			// this.setWeight(1);

		}
		if (this.content.height == "100%") {
			this.content.height = Emp.ViewSize.FillParent;
			// this.setWeight(1);

		}
		this.content.modelId = this.modelId;
		this.content.constructionInfo = {};
		this.content.constructionInfo = this.constructionInfo;
		this.children = [];
		this.content.events = [];
		this.content.animals = [];
		Emp.objects.modelId = this;
	},
	getHtmlType : function() {
		return this.content.constructionInfo.htmlType;
	},
	getAnimations : function() {
		return this.content.animals;
	}
});
Emp.View = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.View.superclass.init.call(this, params);
		Emp.View.superclass.addEvent.call(this, "onAnimationStart",
				function(i) {
					Emp.callback(i + "onAnimationStart");
				});
		Emp.View.superclass.addEvent.call(this, "onAnimationRepeat",
				function(i) {
					Emp.callback(i + "onAnimationRepeat");
				});
		Emp.View.superclass.addEvent.call(this, "onAnimationEnd", function(i) {
			Emp.callback(i + "onAnimationEnd");
		});
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'View'
		};
	},
	scrollByY : function(y) {
		this.fireMethod("scrollByY",  y+"");
	

	},
	scrollToY : function(y,during) {
		if(!y) return;
		during=during||1000;//实现during
		var s = {};
		s.method = "scrollToY";
		s.value = {
			'y' : y,
			'during'  : during
		};
		//this.fireMethod("scrollToY",  y+"");
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	scrollToX: function(x,during){
		if(!x) return;
		during=during||1000;
		var s = {};
		s.method = "scrollToX";
		s.value = { 
				'x':x,
				'during':during
		};
		
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	scrollTo: function(x,y,during){
		if(!x) return;
		if(!y) return;
		var s = {};
		during = during||1000;
		s.method = "scrollTo";
		s.value = {
				'x':x,
				'y':y,
				'during':during
		};
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setWidth : function(mvalue) {
		if (mvalue == "100%") {
			mvalue = Emp.ViewSize.FillParent;
		}
		this.content.width = mvalue;
		this.fireMethod("setWidth", this.content.width);
	},
	getWidth:function(){
		if(this.isRender){
			var s = {};
			s.method = "getWidth";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setHeight : function(mvalue) {
		if (mvalue == "100%") {
			mvalue = Emp.ViewSize.FillParent;

		}
		this.content.height = mvalue;
		this.fireMethod("setHeight", this.content.height);
	},
	setOffSetX:function(x)
	{
		this.content.offSetX = x;
		this.fireMethod("setOffSetX",this.content.offSetX);
	},
	getHeight:function(){
		if(this.isRender){
			var s = {};
			s.method = "getHeight";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setValue : function(mvalue) {
		this.content.value = mvalue;
		// this.fireMethod("setValue", this.content.value);
		if (this.isRender) {
			var s = {};
			s.method = "setValue";
			s.value = mvalue;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getValue : function() {
		if (this.isRender) {
			var s = {};
			s.method = "getValue";
			return empBridge
					.fireModelMethod(this.modelId, util.jsonToString(s));
		} else {
			return this.content.value;
		}
	},
	setTag : function(mvalue) {
		this.content.tag = mvalue;
		this.fireMethod("setTag", this.content.tag);
	},
	setAdapterTag: function(mvalue){
		this.content.adapterTag = mvalue;
	},
	getAdapterTag:function(){
		return this.content.adapterTag;
	},
	getTag : function() {
		return this.content.tag;
		if (this.isRender) {
			var s = {};
			s.method = "getTag";
			var str = empBridge.fireModelMethod(this.modelId, util
					.jsonToString(s));
			return str;
		}
	},
	setName : function(mvalue) {
		this.content.name = mvalue;
	},
	getName:function(){
		return this.content.name;
	},
	setAttrAdapter : function(attrAdapters) {
		if (attrAdapters instanceof Array) {
			this.content.attrAdapter = {};
			for ( var i = 0; i < attrAdapters.length; i++) {
				var value = attrAdapters[i].value;
				//mvalue = "emp" + value
				//delete attrAdapters[i].value;
				this.content.attrAdapter[value] = attrAdapters[i];
			}
		}
		this.content.attrAdapter1 = attrAdapters;
	},
	getAttrAdapter : function() {
		return this.content.attrAdapter1;
	},
	setClass : function(mvalue) {
		this.content.class = mvalue;
	},
	getClass : function() {
		return this.content.class;
	},
	setBackground : function(background,pressBackground) {
		var position = background.search(/#/i);
		if (position == 0) {
			this.setBackgroundColor(background);
		} else {
			this.setBackgroundImage(background,pressBackground);
		}
	},
	setBackgroundImage : function(backgroundImage, backgroundPress) {
		if (!backgroundImage) {
			return;
		}
		this.content['backgroundImage'] = backgroundImage;
		this.fireMethod("setBackgroundImage",
				this.content['backgroundImage']);
		if (backgroundPress) {
			this.setBackgroundPress(backgroundPress);
		}
		//this.fireMethod("setBackground");
	},
	getBackgroundImage:function(){
		return this.content.backgroundImage;
	},
	setBackgroundPress : function(backgroundPress){
		this.content['backgroundPress'] = backgroundPress;
		this.fireMethod("setPressBackgroundImage",this.content['backgroundPress']);
	},
	setBackgroundColor : function(mvalue) {
		this.content['backgroundColor'] = mvalue;
		this.fireMethod("setBackgroundColor", this.content['backgroundColor']);
	},
	getBackgroundColor:function(){
		return this.content.backgroundColor;
	},
	setBorderColor : function(mvalue) {
		this.content['borderColor'] = mvalue;
		this.fireMethod("setBorderColor", this.content['borderColor']);
	},
	setMargin : function(top, right, bottom, left) {
		// log("进入setMargin方法");
		len = arguments.length;
		// log("参数个数："+len);
		if (len == 4) {
			this.content['marginLeft'] = left;
			this.content['marginTop'] = top;
			this.content['marginRight'] = right;
			this.content['marginBottom'] = bottom;
		}
		if (len == 3) {
			this.content['marginLeft'] = right;
			this.content['marginTop'] = top;
			this.content['marginRight'] = right;
			this.content['marginBottom'] = bottom;
		}
		if (len == 2) {
			this.content['marginLeft'] = right;
			this.content['marginTop'] = top;
			this.content['marginRight'] = right;
			this.content['marginBottom'] = top;
		}
		if (len == 1) {
			this.content['marginLeft'] = top;
			this.content['marginTop'] = top;
			this.content['marginRight'] = top;
			this.content['marginBottom'] = top;
		}
		this.fireMethod("setMarginLeft", this.content['marginLeft']);
		this.fireMethod("setMarginRight", this.content['marginRight']);
		this.fireMethod("setMarginTop", this.content['marginTop']);
		this.fireMethod("setMarginBottom", this.content['marginBottom']);
	},
	setMarginLeft : function(left) {
		this.content['marginLeft'] = left;
		this.fireMethod("setMarginLeft", this.content['marginLeft']);
	},
	getMarginLeft : function() {
		if(this.isRender){
			var s = {};
			s.method = "getMarginLeft";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setMarginRight : function(right) {
		this.content['marginRight'] = right;
		this.fireMethod("setMarginRight", this.content['marginRight']);
	},
	getMarginRight : function() {
		if(this.isRender){
			var s = {};
			s.method = "getMarginRight";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setMarginTop : function(top) {
		this.content['marginTop'] = top;
		this.fireMethod("setMarginTop", this.content['marginTop']);
	},
	getMarginTop : function() {
		if(this.isRender){
			var s = {};
			s.method = "getMarginTop";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setMarginBottom : function(bootom) {
		this.content['marginBottom'] = bootom;
		this.fireMethod("setMarginBottom", this.content['marginBottom']);
	},
	getMarginBottom : function() {
		if(this.isRender){
			var s = {};
			s.method = "getMarginBottom";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setPadding : function(top, right, bottom, left) {
		// log("进入setMargin方法");
		len = arguments.length;
		// log("参数个数："+len);
		if (len == 4) {
			this.content['paddingLeft'] = left;
			this.content['paddingTop'] = top;
			this.content['paddingRight'] = right;
			this.content['paddingBottom'] = bottom;
		}
		if (len == 3) {
			this.content['paddingLeft'] = right;
			this.content['paddingTop'] = top;
			this.content['paddingRight'] = right;
			this.content['paddingBottom'] = bottom;
		}
		if (len == 2) {
			this.content['paddingLeft'] = right;
			this.content['paddingTop'] = top;
			this.content['paddingRight'] = right;
			this.content['paddingBottom'] = top;
		}
		if (len == 1) {
			this.content['paddingLeft'] = top;
			this.content['paddingTop'] = top;
			this.content['paddingRight'] = top;
			this.content['paddingBottom'] = top;
		}
		this.fireMethod("setPaddingLeft", this.content['paddingLeft']);
		this.fireMethod("setPaddingRight", this.content['paddingRight']);
		this.fireMethod("setPaddingTop", this.content['paddingTop']);
		this.fireMethod("setPaddingBottom", this.content['paddingBottom']);
	},
	setPaddingLeft : function(left) {
		this.content.paddingLeft = left;
		this.fireMethod("setPaddingLeft", this.content['paddingLeft']);
	},
	getPaddingLeft : function() {
		if(this.isRender){
			var s = {};
			s.method = "getPaddingLeft";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setPaddingRight : function(right) {
		this.content.paddingRight = right;
		this.fireMethod("setPaddingRight", this.content['paddingRight']);
	},
	getPaddingRight : function() {
		if(this.isRender){
			var s = {};
			s.method = "getPaddingRight";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setPaddingBottom : function(bottom) {
		this.content.paddingBottom = bottom;
		this.fireMethod("setPaddingBottom", this.content['paddingBottom']);
	},
	getPaddingBottom : function() {
		if(this.isRender){
			var s = {};
			s.method = "getPaddingBottom";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setPaddingTop : function(top) {
		this.content.paddingTop = top;
		this.fireMethod("setPaddingTop", this.content['paddingTop']);
	},
	getPaddingTop : function() {
		if(this.isRender){
			var s = {};
			s.method = "getPaddingTop";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setMinHeight : function(minHeight) {
		this.content.minHeight = minHeight;
		this.fireMethod("setMinHeight", this.content['minHeight']);
	},
	setMinWidth : function(minWidth) {
		this.content.minWidth = minWidth;
		this.fireMethod("setMinWidth", this.content['minWidth']);
	},
	setDisplay : function(mvalue) {
		if (mvalue == true) {
			this.content.display = "block";
		} else if(mvalue == false){
			this.content.display = "none";
		}
		if (this.isRender) {
			var s = {};
			s.method = "setDisplay";
			s.value = this.content.display;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
			return;
		}
	},
	getDisplay : function(){
		//modify by liulei fixed bug 44680 
		return this.content.display=="block"||this.content.display==undefined?true:false;
	},
	setVisibility : function(mvalue) {
		if (mvalue == true) {
			this.content.visibility = "visible";
		}
		if (mvalue == false) {
			this.content.visibility = "hidden";
		}
		if (this.isRender) {
			var s = {};
			s.method = "setVisibility";
			s.value = this.content.visibility;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
			return;
		}
	},
	getVisibility :function(){
		return this.content.visibility=="hidden"?false:true;
	},
	setWeight : function(weight) {
		this.content.weight = weight;
		if (this.isRender) {
			var s = {};
			s.method = "setWeight";
			s.value = weight;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getWeight :function(){
		return this.content.weight;
	},
	setOpacity : function(mvalue) {// 设置透明度
		this.content.opacity = mvalue;
		if (this.isRender) {
			var s = {};
			s.method = "setOpacity";
			s.value = this.content.opacity;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getOpacity :function(){
		return this.content.opacity;
	},
	setRender : function() {
		this.isRender = true;
		// log("孩子的大小："+this.children.length);
		for ( var i = 0; i < this.children.length; i++) {
			// log(this.children[i]);
			this.children[i].setRender();
		}
	},
	//private 私有方法 在form 中使用
	getKeyValueByName : function() {
		if (this.content.name) {
			var temp = {};
			temp["name"] = this.content.name;
			temp["value"] = this.getValue();
			Emp.formKeyValue.push(temp);
		}
		for ( var i = 0; i < this.children.length; i++) {
			this.children[i].getKeyValueByName();
		}
	},
	setPosition : function(value) {
		this.content.position = value;
	},
	getPosition :function(){
		return this.content.position==undefined?"absolute":this.content.position;
	},
	setTop : function(top) {
		this.content.top = top;
		this.fireMethod("setTop", this.content.top);
	},
	getTop:function(){
		if(this.isRender){
			var s = {};
			s.method = "getTop";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	setLeft : function(left) {
		this.content.left = left;
		this.fireMethod("setLeft", this.content.left);
	},	
	getLeft:function(){
		if(this.isRender){
			var s = {};
			s.method = "getLeft";
			return parseInt(empBridge
			.fireModelMethod(this.modelId, util.jsonToString(s)),10);
		} else
			return null;
	},
	addAnimation : function(animal) {
		if (!animal)
			return;
		this.content.animals.push(animal);
	},
	clearAnimation : function() {
		this.content.animals = [];
		this.fireMethod("clearAnimation", this.content.animals);
	},
	cleanAnimation : function() {
		this.content.animals = [];
		this.fireMethod("clearAnimation", this.content.animals);
	},
	startAnimation : function() {
		//alert(util.jsonToString(this.content.animals));
		this.fireMethod("setAnimal", this.content.animals);
	}
});

Emp.Container = Emp.extend(Emp.View, {
	add : function(arg1, arg2) {
		if (arg1==undefined) {// 没有参数
			return;
		}
		if(this.isRender==true)//如果render后添加子，将子控件的render标志设置为true
			__setRendered(arg1);
		if (arg2==undefined) {// 只有一个参数
			arg1.parent = this.getModelId();
			this.children.push(arg1);
			this.fireMethod("add", arg1);
			return;
		}
		// 如果有两个参数
		arg1.parent = this.getModelId();
		this.children.splice(arg2, 0, arg1);
		v = {};
		v.position = arg2;
		v.childJson = arg1;
		this.fireMethod("add", v);
	},
	remove : function(child) {
		var index;
		if (typeof (child) === 'number') { // 参数为数组下标
			index = child;
			child = this.children[index];
		} else if (typeof (child) === 'object') { // 参数为UI对象
			index = this.children.indexOf(child);
		}
		this.children.splice(index, 1);
		this.fireMethod("remove", child.modelId);
	},
	removeAll : function() {
		this.children = [];
		if (this.isRender) {
			var s = {};
			s.method = "removeAll";
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getChildren : function() {
		return this.children;
	}
});
Emp.Panel = Emp.extend(Emp.Container, {
	// constructionInfo:{type:'baseui',model:'NativePanel'},
	init : function(params) {
		Emp.Panel.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel'
		};
	},
	setLayout : function(layout) {
		this.content.layout = layout;
		this.fireMethod("setLayout", layout);
	},
	getLayout : function(){
		return this.content.layout==undefined?"HBox":this.content.layout;
	},
	setHAlign : function(align) {
		this.content['hAlign'] = align;
		this.fireMethod("setHAlign", align);
	},
	getHAlign : function(){
		return this.content.hAlign==undefined?"left":this.content.hAlign;
	},
	setVAlign : function(align) {
		this.content['vAlign'] = align;
		this.fireMethod("setVAlign", align);
	},
	getVAlign : function(){
		return this.content.vAlign==undefined?"top":this.content.vAlign;
	},
	moveTo:function(x,y,during)
	{
		v = {};
		v.x = x;
		v.y = y;
		v.during=during;
		this.fireMethod("moveTo", v);
	},
	moveToX:function(x,during)
	{
		v = {};
		v.x = x;
		v.during=during;
		this.fireMethod("moveToX", v);
	}
	,
	moveToY:function(y,during)
	{
		v = {};
		v.y = y;
		v.during=during;
		this.fireMethod("moveToY", v);
	},
	//2016年5月3日--罗登林修改（jira--EMP-147，为了解决调用setBounces方法报js错误）
	setBounces:function(bounces){
		this.content['bounces'] = bounces;
		this.fireMethod("setBounces",bounces);
	}
});

Emp.Label = Emp.extend(Emp.View, {
	// constructionInfo:{type:'baseui',model:'NativeLabel'},
	init : function(params) {
		Emp.Label.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeLabel'
		};
	},
	setLineSpace:function(lineSpace)
	{
		this.content['lineSpace']=lineSpace;
		this.fireMethod("setLineSpace", this.content['lineSpace']);	
	},
	setMaxWidth : function(width){
		this.content['maxWidth']=width;
		this.fireMethod("setMaxWidth", this.content['maxWidth']);
	},
	getMaxWidth :function(){
		return this.content.maxWidth==undefined?0:this.content.maxWidth;
	},
	setFontSize : function(size) {
		this.content['fontSize'] = size;
		this.fireMethod("setFontSize", this.content['fontSize']);
	},
	getFontSize : function(){
		return this.content.fontSize==undefined?16:this.content.fontSize;
	},
	setColor : function(color) {
		this.content.color = color;
		this.fireMethod("setColor", this.content.color);
	},
	getColor : function() {
		return this.content.color == undefined?"#333333":this.content.color;
	},
	setFontBold : function(mvalue) {
		this.content['fontBold'] = mvalue;
		this.fireMethod("setFontBold", this.content['fontBold']);
	},
	getFontBold : function() {
		return this.content['fontBold'] == undefined?false:this.content.fontBold;
	},
	setFontWeight : function(mvalue) {
		this.content['fontWeight'] = mvalue;
		this.fireMethod("setFontWeight", this.content['fontWeight']);
	},
	getFontWeight : function() {
		return this.content['fontWeight'] == undefined?0:this.content.fontWeight;
	},
	
	setFontFamily : function(mvalue) {
		this.content['fontFamily'] = mvalue;
		this.fireMethod("setFontFamily", this.content['fontFamily']);
	},
	setDisabled : function(mvalue) {
		this.content.disabled = mvalue;
		this.fireMethod("setDisabled", this.content.disabled);
	},
	getDisabled :function(){
		return this.content.disabled==undefined?false:this.content.disabled;
	},
	setReadonly : function(mvalue) {
		this.setDisabled(mvalue);
	},
	getReadonly :function(){
		return this.getDisabled();
	},
	setSingleLine : function(value) {
		if (value == true || value == 'true') {
			this.content.singleLine = true
		}
		if (value == false || value == 'false') {
			this.content.singleLine = false
		}
		this.fireMethod("setSingleLine", this.content.singleLine + "");
	},
	getSingleLine:function(){
		return this.content.singleLine==undefined?false:this.content.singleLine;
	}
});
Emp.SwitchButton=Emp.extend(Emp.Panel,{
	init:function(params){
		Emp.SwitchButton.superclass.init.call(this,params);
		this.content.constructionInfo={
			type:'baseui',
			model:'NativeSwitchButton'
		};
	},
	setSwitchStatus:function(flag){
		this.content.switchStatus=flag;
		this.fireMethod("setSwitchStatus",flag);
	},
	setOffBackgroundColor:function(color){
		this.content.offBackgroundColor=color;
		this.fireMethod("setOffBackgroundColor",color);
	},
	setOnBackgroundColor:function(color){
		this.content.onBackgroundColor=color;
		this.fireMethod("setOnBackgroundColor",color);		
	},
	setThumbColor:function(color){
		this.content.thumbColor=color;
		this.fireMethod("setThumbColor",color);
	},
	isRounded:function(flag){
		this.content.rounded=flag;
		this.fireMethod("isRounded",flag);
	}, 
	onChange:function(eventName,fn)
	{
		Emp.addEvent(this.modelId + "onChange", callback);
	},
});

Emp.YearCalendar=Emp.extend(Emp.Panel,{
	init:function(params){
		Emp.YearCalendar.superclass.init.call(this,params);
		this.content.constructionInfo={
			type:'baseui',
			model:'NativeYearCalendar'
		};
	},
	setYear:function(year){
		this.content.year = year;
		this.fireMethod("setYear",year);
	},
	setEventsDate:function(eventsDate){
		this.content.eventsDate = eventsDate;
		this.fireMethod("setEventsDate",eventsDate);
	}
	
});
Emp.Signature=Emp.extend(Emp.Panel,{
	init:function(params){
		Emp.Signature.superclass.init.call(this,params);
		this.content.constructionInfo={
			type:'baseui',
			model:'NativeSignature'
		};
	},
	saveImg:function(path){
		if(!path)
			path="sd://sign.jpg"
		this.content.path =path;
		this.fireMethod("saveImg",path);
	},
	clear:function(){
		this.fireMethod("clear",null);
	}
	
});
Emp.SeekBar=Emp.extend(Emp.Panel,{
	init:function(params){
		Emp.SeekBar.superclass.init.call(this,params);
		this.content.constructionInfo={
			type:'baseui',
			model:'NativeSeekBar'
		};
	},
	setOnColor:function(color){
		this.content.onColor=color;
		this.fireMethod("setOnColor",color);
	},
	setOffColor:function(color){
		this.content.offColor=color;
		this.fireMethod("setOffColor",color);
	},
	setThumbColor:function(color){
		this.content.thumbColor=color;
		this.fireMethod("setOnThumbColor",color);
	},
	setThumbRadius:function(r){
		this.content.thumbRadius=r;
		this.fireMethod("setThumbRadius",r);
	},
	setLineHeight:function(lineHeight){
		this.content.lineHeight=lineHeight;
		this.fireMethod("setLineHeight",lineHeight);
	},
	setProgress:function(progress){
		this.content.progress=progress;
		this.fireMethod("setProgress",progress);
	},
	onChange:function(eventName,fn)
	{
		Emp.addEvent(this.modelId + "onChange", callback);
	},
	setMin:function(minValue){
		this.content.minValue=minValue;
		this.fireMethod("setMin",minValue);
	},
	setMax:function(maxValue){
		this.content.maxValue=maxValue;
		this.fireMethod("setMax",maxValue);
	},
	setHint:function(isHint){
		this.content.isHint=isHint;
		this.fireMethod("setHint",isHint);
	},
	setHintColor:function(color){
		this.content.color=color;
		this.fireMethod("setHintColor",color);
	},
	setHintSize:function(size){
		this.content.size=size;
		this.fireMethod("setHintSize",size);
	},
	setStepLength:function(step){
		this.content.step=step;
		this.fireMethod("setStepLength",step);
	}
	
});
Emp.GesturePassword = Emp.extend(Emp.Panel, {
	// constructionInfo:{type:'baseui',model:'NativeLabel'},
	init : function(params) {
		Emp.GesturePassword.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeGesturePassword'
		};
	},
	setBigPointBackgroundColor:function(color){		
			this.content.bigPointBackgroundColor=color;
			this.fireMethod("setBigPointBackgroundColor", color);
		},
	setBigPointHighlightColor: function(bigPointHighlightColor){
        this.content.bigPointHighlightColor = bigPointHighlightColor;
        this.fireMethod('setBigPointHighlightColor',bigPointHighlightColor);
    },
    setSmallPointBackgroundColor: function(smallPointBackgroundColor){
        this.content.smallPointBackgroundColor = smallPointBackgroundColor;
        this.fireMethod('setSmallPointBackgroundColor',smallPointBackgroundColor);
    },
    setSmallPointHighlightColor: function(smallPointHighlightColor){
        this.content.smallPointHighlightColor = smallPointHighlightColor;
        this.fireMethod('setSmallPointHighlightColor',smallPointHighlightColor);
    },
    setLineBackgroundColor: function(lineBackgroundColor){
        this.content.lineBackgroundColor = lineBackgroundColor;
        this.fireMethod('setLineBackgroundColor',lineBackgroundColor);
    },
    setPointBorderBackgroundColor: function(pointBorderColor){
        this.content.pointBorderColor = pointBorderColor;
        this.fireMethod('setPointBorderBackgroundColor',pointBorderColor);
    },
    setPointBorderHighlightColor: function(pointBorderHighlightColor){
        this.content.pointBorderHighlightColor = pointBorderHighlightColor;
        this.fireMethod ('setPointBorderHighlightColor',pointBorderHighlightColor);
    },
    setLineWidth: function(lineWidth){
    this.content.lineWidth = lineWidth;
    this.fireMethod('setLineWidth',lineWidth);
    },
    getPassword:function(){
    	if(this.isRender){
    	var s = {};
		s.method = "getPassword";
		return empBridge.fireModelMethod(this.modelId, util.jsonToString(s));                         
    	}
	}
	});
//通信录索引
Emp.IndexBar = Emp.extend(Emp.Panel, {
	init : function(params) {
		Emp.IndexBar.superclass.init.call(this, params);
		this.content.constructionInfo = {
				type : 'baseui',
				model : 'NativeSideBar'
		};
	}	
});
Emp.Button = Emp.extend(Emp.Label, {
	init : function(params) {
		Emp.Button.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeButton'
		};
	}	
});
/*
Emp.Tab1 = Emp.extend(Emp.View, {
	// constructionInfo:{type:'baseui',model:'NativeTabHost'},
	init : function(params) {
		Emp.Tab.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeTabHost'
		};
	},
	setItems : function(items) {
		this.content.tabItems = items;
	},
	setSelectTabId : function(number) {
		this.content.selectTabId = number;
	},
	setTextSize : function(number) {
		this.content.textSize = number;
	},
	setTextColor : function(color) {
		this.content.textColor = color;
	},
	setBackgroundSelImage : function(backgroundSelImage) {
		this.content.backgroundSelImage = backgroundSelImage;
	},
	setBackgroundSelColor : function(backgroundSelColor) {
		this.content.backgroundSelColor = backgroundSelColor;
	}

});
*/
/**
 * 重置模板render状态
 * 
 * @param widget
 */
function __setRendered(widget) {
	widget.isRender = true
	var length = widget.children.length;
	for ( var i = 0; i < length; i++) {
		__setRendered(widget.children[i])
	}
}

/**
 * 
 * 列表控件
 * 
 */


Emp.ListView = Emp.extend(Emp.View,
				{
					init : function(params) {
						Emp.ListView.superclass.init.call(this, params);
						this.content.constructionInfo = {
							type : 'baseui',
							model : 'NativeListView'
						};
						// this.scroller=new
						// Emp.ListView.DefaultScroller({"modelId":this.modelId});

						this.setScroller(new Emp.ListView.DefaultScroller({
							"modelId" : this.modelId
						}));
						// this.setHeader(this.scroller.getHeader());
						// this.setFooter(this.scroller.getFooter());
						// 初始化滚动功能
						this.addEvent("onStartScrollDown", function() {
							// alert( this.scroller.onStartScrollDown)
							this.scroller.onStartScrollDown();
						});
						this.addEvent("onScrollDown", function(deltaY) {
							this.scroller.onScrollDown(deltaY);
						});
						this.addEvent("onEndScrollDown", function() {
							this.scroller.onEndScrollDown();
						});

						this.addEvent("onScrollDownRelease", function(deltaY) {
							this.scroller.onScrollDownRelease(deltaY)
						});

						this.addEvent("onScrollUp", function(deltaY) {
							this.scroller.onScrollUp(deltaY);
						});

						this.addEvent("onEndScrollUp", function() {
							this.scroller.onEndScrollUp();
						});

						this.addEvent("onStartScrollUp", function() {
							this.scroller.onStartScrollUp();
						});

						this.addEvent("onScrollUpRelease", function(deltaY) {
							this.scroller.onScrollUpRelease(deltaY);
						});

						this.content.events.push("onLoadMore");
						Emp.addEvent(this.modelId + "onLoadMore",
								function(type) {
									var r = this.scroller.onLoadMore(type);
									//if (r === false)
									//	return;
									//if (this.onLoadMore !== null) {
										//this.onLoadMore.apply(this, [ type ]);
									//}
									if (this.onPullDown !== null) {
										this.onLoadMore.apply(this, [ type ]);
									}

								}, this);

					},

					/**
					 * 触发加载事件
					 */
					fireLoadMore : function(type) {

						if (this.onLoadMore !== null) {
							this.onLoadMore.apply(this, [ type ]);
						}
					},
					resetScroller : function() {
						try{
							this.scroller.onResetScroller();
						}catch(e){
							log("listview resest :"+e);
						}
					},
					// 数据加载时充发事件
					onLoadMore : null,
					// 兼容以前版本 数据加载事件
					onPullDown : null,
					addEvent : function(methodName, callback) {
						if (methodName == "onLoadMore") {
							this.onLoadMore = callback;
							return;
						}
						if (methodName == "onPullDown") {
							this.onLoadMore = callback;
							return;
						}
						this.content.events.push(methodName + "");
						// 如果render之后直接调
						this.fireMethod("addEvent", methodName);
						// 加到js中去
						Emp.addEvent(this.modelId + methodName, callback, this)
					},

					/**
					 * 设置多模板
					 * 
					 */
					setTemplates : function(template) {
						var obj = {};
						for ( var key in template) {
							var t = template[key];
							if (t.__isTemplate == true) {
								t.children[0].setRender();
								obj[key] = t.children[0];
							} else {
								t.setRender();
								obj[key] = t;
							}
						}

						this.content.template = obj;
					},

					/**
					 * 设置模板
					 */
					setTemplate : function(tem,temId) {
						if (!this.content.template) {
							this.content.template = {};
						}
						if(!temId){
							temId= this.modelId+"NativeListView";
						}
						if (tem.__isTemplate == true) {
							tem.children[0].setRender();
							this.content.template[temId] = tem.children[0];
						} else {
							tem.setRender();
							this.content.template[temId] = tem;
						}
						if(this.isRender==true){		//modify by:loucj
							var s = {};					//bugId: 44239
							s.method = "setTemplate";	//desc: 增加render后setTemplate的能力
							s.value=this.content.template;
							var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
						}
					},

					setItems : function(json) {
						this.content.items = json;
						if(this.isRender==true){
							var s = {};
							s.method = "setItems";
							s.value=json;
							var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
						}
					},
					//更新单行数据 
					updateItem:function(row,item,group){
						if(this.isRender==true){
							var json = {};
							json.item= item;
							json.row=row;
							if(group){
								json.group= group;
							}
							var s = {};
							s.method = "updateItem";
							s.value=json;
							var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
						}
					},
					appendItems : function(json,position) {
						if(!position)
				            position="bottom";
				        if(position=="bottom"){
				            var temp = [];
				            temp=this.content.items.concat(json);
				            this.content.items=temp;
				         }else{
				            var temp = [];
				            temp=json.concat(this.content.items);
				            this.content.items=temp;
				         }
						if(this.isRender==true){
							var s = {};
							s.method = "appendItems";
							var temp={};
							temp.position=position;
							temp.items=json;
							s.value=temp;
							var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
						}
					},
					getItems : function() {
						if(this.isRender==true){
							var s = {};
							s.method = "getItems";
							var result = empBridge.fireModelMethod(this.modelId,  util.jsonToString(s)); 
							return util.stringToJson(result);
						}
						return this.content.items;
					},

					/**
					 * 是否划动到顶部
					 */
					isScrollTop : function(value) {
						var s = {};
						s.method = "isScrollTop";
						var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
						return ResultUtil.processResult(r)==="true";
					},

					/**
					 * 是否划动到底部
					 */
					isScrollBottom : function(value) {
						var s = {};
						s.method = "isScrollBottom";
						var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
						return ResultUtil.processResult(r)==="true";
					},
                    
					/**
					 * 设置listview是否能滚动
					 */
					setEnableScroll : function(enableScroll){
						
					},
					/**
					 * 设置允许下拉
					 */
					setEnablePullDown : function(value) {
						this.content.enablePullDown = value;
						this.fireMethod("setEnablePullDown",
								this.content.enablePullDown);
					},
					/**
					 * 设置充许上拉
					 */
					setEnablePullUp : function(value) {
						this.content.enablePullUp = value;
						this.fireMethod("setEnablePullUp",
								this.content.enablePullUp);
					},
					/**
					 * 重新加载数据
					 */
					reloadData : function() {
						this.isRender=true;
						this.resetScroller();
						var s = {};
						s.method = "reLoad";
						empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
//						this.fireMethod("reLoad");

					},
		
					setSelection : function(selection) {
						this.content.selection = selection;
						this.fireMethod("setSelection", this.content.selection);
					},
					/*
					 * setDividerHeight:function(value){
					 * this.content.dividerHeight = value;
					 * this.fireMethod("setDividerHeight",this.content.dividerHeight); },
					 * setDividerImage:function(value){
					 * this.content.dividerImage = value;
					 * this.fireMethod("setDividerImage",this.content.dividerImage); },
					 */
					setDividerVisible : function(value) {
						if (value == true) {
							this.content.dividerVisible = true;
						}
						if (value == false) {
							this.content.dividerVisible = false;
						}
						this.fireMethod("setDividerVisible",
								this.content.dividerVisible);
					},
					setDividerColor : function(value) {
						this.content.dividerColor = value;
						this.fireMethod("setDividerColor",
								this.content.dividerColor);
					},
					setOnclickTags : function(value) {
						this.content.onClickTags = value;
					},
					setOnClickModelId : function(value) {
						this.fireMethod("setOnClickModelId", value);
					},
					getElementByTag : function(tag, row,group) {
						var model = this.getModelByTag(tag, row, group);
						var bt;
						if ("emp-button" == model) {
							bt = new Emp.Button();
						} else if ("emp-panel" == model) {
							bt = new Emp.Panel();
						} else if ("emp-label" == model) {
							bt = new Emp.Label();
						} else if ("emp-text" == model) {
							bt = new Emp.Text();
						} else if ("emp-image" == model) {
							bt = new Emp.Image();
						}
						if(!bt) {
							log("控件不支持")
							return;
						}
						var _list = this;
						bt.setValue = function(value) {
							var s = {};
							s.method = "setValue";
							s.value = value;
							empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
							if (group!=undefined) {
								_list.content.items[group]['subList'][row][tag] = value;
								_list.updateItem(row,_list.content.items[group]['subList'][row],group);
							} else {
								_list.content.items[row][tag] = value;
								_list.updateItem(row,_list.content.items[row]);
							}
							//_list.setItems(_list.content.items);
						}
						if(group!=undefined){
							bt.content.modelId = tag + "" + row+""+group;
						}else{
							bt.content.modelId = tag + "" + row;
						}
						bt.modelId = bt.content.modelId;
						this.setOnClickModelId(bt.content.modelId);
						bt.setRender(true);
						return bt;
					},
					getModelByTag :function(tag,row,group){
						var s = {};
						s.method = "getModelByTag";
						s.value = {'tag':tag,'row':row,'group':group};
						return empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
					},
					/**
					 * 设置头部
					 */
					setHeader : function(tem) {

						if (tem.__isTemplate == true) {
							this.content.header = tem.children[0];
						} else {
							this.content.header = tem;
						}
						__setRendered(this.content.header);
					},
					setScroller : function(scroller) {
						var listview = this;
						this.scroller = scroller;
						this.scroller.getListview=function(){return listview;};
						this.setHeader(this.scroller.getHeader());
						this.setFooter(this.scroller.getFooter());
						this.content.pullDownEndDistance = scroller.pullDownEndDistance;
						this.content.pullDownDistance = scroller.pullDownDistance;
						this.content.pullUpEndDistance = scroller.pullUpEndDistance;
						this.content.pullUpDistance = scroller.pullUpDistance;

						this.scroller.fireLoadMore = function(type) {
							listview.fireLoadMore(type);
						}
					},
					/**
					 * 设置底部
					 */
					setFooter : function(tem) {

						if (tem.__isTemplate == true) {
							this.content.footer = tem.children[0];
						} else {
							this.content.footer = tem;
						}
						__setRendered(this.content.footer);
					}

				});
				
				
/**
 * Listview的缺省划动对象接口
 */
Emp.ListView.Scroller = Emp.extend(Emp.Component, {
	// 上拉加载触发点
	pullDownEndDistance : "90",
	// 上拉加载触发点
	pullDownDistance : "150",
	// 下拉加载触发点
	pullUpEndDistance : "2",
	// 下拉加载触发点
	pullUpDistance : "2",

	init : function(params) {
		this.__listviewId = params.modelId
	},
	/**
	 * 返回头部模型
	 */
	getHeader : function() {
		return new Emp.Panel({
			width : "100%",
			height : "80"
		});
	},

	/**
	 * 返回底部模型
	 */
	getFooter : function() {
		return new Emp.Panel({
			width : "100%",
			height : "80"
		});
	},

	/**
	 * 下拉下始
	 */
	onStartScrollDown : function() {

	},

	/**
	 * 下拉中....
	 */
	onScrollDown : function(deltaY) {

	},
	/**
	 * 下拉至加载临界点
	 */
	onEndScrollDown : function() {

	},

	/**
	 * 下拉释放
	 */
	onScrollDownRelease : function(deltaY) {

	},

	/**
	 * 上拉中
	 */
	onScrollUp : function(deltaY) {

	},

	/**
	 * 上拉到加载临界点
	 */
	onEndScrollUp : function() {

	},

	/**
	 * 开始上拉
	 */
	onStartScrollUp : function() {

	},

	/**
	 * 上拉释放
	 */
	onScrollUpRelease : function(deltaY) {

	},
	/**
	 * 加载更多事件被触发
	 */
	onLoadMore : function(type) {

	},
	/**
	 * 重新加载数据时
	 */
	onResetSroller : function() {

	}

});

/**
 * 缺省listview滑动实现
 */
Emp.ListView.DefaultScroller = Emp.extend(Emp.ListView.Scroller, {
    offset:0,
	headerContainer : null,
	headerIcon : null,
	headerUpdateTimer : null,
	headerPrompt : null,
	isStartDownRelease : true,
	getHeader : function() {
		var ifEnablePull = this.getListview().content.enablePullDown;
		if(ifEnablePull==true||ifEnablePull=='true')//如果设置允许下拉刷新，初始化header隐藏
			this.getListview().setPaddingTop("-80");
		var p = new Emp.Panel({
				height : 80
		});

		this.animation = new Emp.RotateAnimation({
			fromDegrees : 0,
			toDegrees : 180,
			duration : 200,
			pivotX : 0.5,
			pivotY : 0.5
		});

		this.headerContainer = new Emp.Panel({
			"id" : "myhead",
			"hAlign" : "center",
			"layout" : "HBox",
			"width" : "100%",
			"vAlign" : "middle",
			height : 80
			
		});

		this.headerIcon = new Emp.Image({

			"height" : "40",
			"width" : "30",
			"src" : "/images/widgets/listview/headArrow.png",
			"marginLeft" : -30
		});

		this.progress = new Emp.Progress({
			width : "30",
			height : "30"
		});
		this.headerContainer.add(this.progress);

		this.headerContainer.add(this.headerIcon);

		var _div_8838547 = new Emp.Panel({
			"marginLeft" : "20",
			"hAlign" : "center",
			"layout" : "VBox"
		});

		this.headerPrompt = new Emp.Label({
			"value" : "下拉更新",
			"fontSize" : "18"
		});

		_div_8838547.add(this.headerPrompt);

		this.headerUpdateTimer = new Emp.Label({

			"value" : "最后更新:-",
			"fontSize" : "14"
		});

		_div_8838547.add(this.headerUpdateTimer);
		this.headerContainer.add(_div_8838547);

		p.add(this.headerContainer);
		return p;
	},
	onStartScrollDown : function() {
		this.isScrollDownRelease=true;
		this.headerContainer.setVisibility(true);
		this.progress.setVisibility(false);
		this.headerPrompt.setValue("下拉更新")
		if (this.headerUpdateTimerValue != null)
			this.headerUpdateTimer.setValue("最后更新:"
					+ this.headerUpdateTimerValue);
		this.headerIcon.setVisibility(true);

		// this.headerIcon.clearAnimation();

	},
	  onScrollDown : function(deltaY) {
		//this.headerContainer.setHeight(deltaY + "px");
		//this.headerContainer.setMarginTop((deltaY-160)+"px");
		
		var y=this.offset-deltaY;
	    this.getListview().scrollByY(y);
		this.offset=deltaY;
	},

	onEndScrollDown : function() {
		this.headerIcon.addAnimation(this.animation);
		this.headerPrompt.setValue("释放刷新");
		this.scrollDownRelease=true;
		this.headerIcon.startAnimation();
	},

	onScrollDownRelease : function(deltaY) {
		this.offset=0;
		if(this.scrollDownRelease==true)
		{
		  this.scrollDownRelease=false;
		  this.isScrollDownRelease=false
		 
		   this.getListview().scrollToY(-80);
		  //this.headerContainer.moveToY(0,500);
		  }
		  else
		  {
		  if(this.isScrollDownRelease==true)
		  {
		    this.isScrollDownRelease=false
		    this.headerPrompt.setValue("正在加载..");
		    //this.headerContainer.moveToY(-80,500);
		    	  this.getListview().scrollToY(-1);
		  }
		  }
		  
	
	/*
		if (deltaY >= 0)
			this.headerContainer.setHeight(deltaY + "px")
		else
			this.headerContainer.setVisibility(false);
			*/
	},

	onLoadMore : function(type) {

		if (type == "pullDown") {
			var scroller=this
			 setTimeout(500,function(){ scroller.fireLoadMore("pullDown");})		
		
			this.headerIcon.setVisibility(false);
			this.progress.setVisibility(true);
			this.headerIcon.clearAnimation();
			this.headerIcon.setVisibility(false);
			this.headerUpdateTimerValue = new Date()
					.format("yyyy年MM月dd日  hh:mm")	
		} else {
			return false;
		}
	}, 
	getFooter : function() {
		var p = new Emp.Panel();
		this.footerContent = new Emp.Panel({

			height : 80,
			width : "100%",
			layout : "HBox",
			vAlign : "middle",
			hAlign : "center",
			top:"-80"
			
		});
		//modify by liulei 上拉的进度条变形
		var progress = new Emp.Progress({
			width : "30",
			height : "30"
		});
		this.footerContent.add(progress);

		var loading = new Emp.Label({
			"marginLeft" : 20,
			"value" : "正在加载......",
			"fontSize" : "18"
		});
		
		this.footerContent.add(loading);
		this.footerContainer = new Emp.Panel({
			height : 0,
			width : "100%"
		});
		this.footerContainer.add(this.footerContent);
		p.add(this.footerContainer)
		return p
	},
	onScrollUp : function(deltaY) {

	},

	onEndScrollUp : function() {

	},

	onStartScrollUp : function() {
		try{
			this.footerContainer.setHeight("80");
			this.isBottomReset=true;
			this.fireLoadMore("pullUp");
		}catch(e){}
	},

	onScrollUpRelease : function(deltaY) {

	},
	onResetScroller : function() {
		if(this.isBottomReset)
			{
			this.isBottomReset=false;
			this.footerContainer.setHeight("0");			
			}
		else
		{
		this.getListview().scrollToY(-1);
		    //this.headerContainer.moveToY(-80,500);	
		}
	}

});

Emp.GridView = Emp.extend(Emp.Panel, {
	// constructionInfo:{type:'baseui',model:'NativeNineGrid'},
	init : function(params) {
		params.width=params.width||"100%";
		params.height=params.height||"100%";
		Emp.GridView.superclass.init.call(this, params);
		this.tipVisible = params.tipVisible==undefined?true:params.tipVisible;
		this.textColor=this.textColor||"#000000";
		this.itemHeight=this.itemHeight||120;
		this.itemWidth=this.itemWidth||120;
		this.itemImageHeight=this.itemImageHeight||70;
		this.itemImageWidth=this.itemImageWidth||70;
		this.textSize=this.textSize||16;
		this.cells=[];
		//this.items=[{icon:"/images/app.png",text:"text",tag:"bbb"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text"},{icon:"/images/app.png",text:"text1"},{icon:"/images/app.png",text:"text1"},{icon:"/images/app.png",text:"text1"},{icon:"/images/app.png",text:"text1"},{icon:"/images/app.png",text:"text1"},{icon:"/images/app.png",text:"text1"},{icon:"/images/app.png",text:"text1"}];		
		this.items=this.items||[];
		this.onAddEvent=this.addEvent;
		this.addEvent=function(n,f){
		if(n=="onItemClick"){
			this.onItemClick=f;
		}
		else
		if(n=="onItemCreate"){
		   this.onItemCreate=f;
		   	}	else
		if(n=="onItemLongClick"){
		   this.onItemLongClick=f;
		   	}
		else
		   this.onAddEvent(n, f);
		}		 
   
		this.addEvent("afterRender", function(w,h){
		if(this.rendered==true) return;
		this.rendered=true; 
		this.afterRender(w, h)
		});	
	//$M.page.addEvent("onLoad",function(){alert(grid.getWidth())})
		 
	},
	setTextColor:function(textColor){
		this.textColor=textColor;
	},
	setItems:function(items){
		this.items=items;
	},
	
	addItem:function(item){
		this.items.push(item);
		var num=this.slide.getSelectedIndex();
		if(this.rendered==true)
		{	
			//this.cells=[];
		     //this.remove(0);
			//this.slidepage==null;	
		//当内容超出一页时或者是添加的第一个item时
		if(this.items.length==1||(this.items.length-1)%(this.column*this.row)==0){		
			var pageIndex=Math.floor(this.items.length/(this.column*this.row));//获取最新页数
			this.pageCount++;
			//创建一个新页面，并添加内容
			 var slidepage = new Emp.Panel({"layout":"VBox","hAlign":"left",width:"100%",height:"100%"});
			 
			 for(var rowIndex=0;rowIndex<this.row;rowIndex++){ 	
		  		var row = new Emp.Panel({width:"100%",height:"100%"});
		  			for(var cellIndex=0;cellIndex<this.column;cellIndex++)
		  				{
		  					var index=pageIndex*this.row*this.column+rowIndex*this.column+cellIndex;//从0开始，表示的是items数组中的下标		  				
		  					if(index<this.items.length){
		  						var cell=this.createCell(index); //调用函数创建单元格
		  						row.add(cell);	//在这一行中添加单元格
		  						this.cells.push(cell);		 //将这个单元格添加到数组cells中 		
		  					}			
		  				}  
		  			slidepage.add(row);		 
				 }
			  	this.slide.add(slidepage);	
			}
		//当内容在一页中时
		else{
			var pageIndex=Math.floor((this.items.length-1)/(this.column*this.row));//获取最新页数
			var slidepageObj=this.slide.content.pages[pageIndex];	
			var rowNum=Math.floor((this.items.length-1-(( this.pageCount-1)*this.column*this.row))/this.column);
			var row=slidepageObj.children[rowNum];//找到当前行
			var cell=this.createCell(this.items.length-1); 
		    this.cells.push(cell);			    
		    row.add(cell);
				}
			//this.afterRender(this.getWidth(), this.getHeight());
		}
	},
	removeItem:function(index){	
		var indexTemp=index;
		//从要删除的元素开始进行删除替换过程
		for(var i=index;i<=this.items.length;i++){
			var currentPage=Math.floor((i-1)/(this.column*this.row));//要删除的页数，从0开始计
			var currentRow=Math.floor((i-currentPage*this.column*this.row-1)/this.column);//计算要删除的行数，从0开始计
			var currentCol=((i-currentPage*this.column*this.row)-1)%this.column//计算要删除的列数，从0开始计
			//log("第"+i+"次循环page:"+currentPage+"row"+currentRow+"col"+currentCol);
			//如果是最后一个元素，则只删除，不添加
			if(i==this.items.length){
				this.slide.content.pages[currentPage].children[currentRow].remove(currentCol);
				}
				//不是最后一个元素，删除当前元素，添加下一个元素
			else{
				this.slide.content.pages[currentPage].children[currentRow].remove(currentCol);
				this.getCell(i).children[0].index=i-1;//因为cell的index同时表示cell在cells中的下标值，所以需要维护index与其在数组中的下标值一致
				this.slide.content.pages[currentPage].children[currentRow].add(this.getCell(i),currentCol);
				}
			}
		this.items.splice(indexTemp-1,1);
		this.cells.splice(indexTemp-1,1);
		//计算删除后的总页数
		var pageTemp=0;
		if(this.items.length!=0)
		{
			var mode=this.items.length%(this.row*this.column);
			if(mode!=0)
			pageTemp=(this.items.length-mode)/(this.row*this.column)+1;
				else
			pageTemp=(this.items.length-mode)/(this.row*this.column);			
		}	
		//如果删除单元格后总页数小于原来的页数，则删除掉多余的一页
		if(pageTemp<this.pageCount)	{
			this.slide.remove(this.pageCount-1);
			this.pageCount=pageTemp;
			}
		},
	reload:function(items){
		this.items=items||this.items;
		var selectedIndex= this.slide.getSelectedIndex();
		if(this.rendered==true)
		{	this.cells=[];
			this.remove(0);
			this.slidepage==null;
			this.afterRender(this.getWidth(), this.getHeight()); 
			this.slide.setSelectedIndex(selectedIndex);
		}
	},
	insertItem:function(item,index){
		//这里的index从1开始计
		//添加item和cell
		if(index<1)return;//下标必须从1开始
		this.items.splice(index-1,0,item);
		var cell=this.createCell(index-1);
		this.cells.splice(index-1,0,cell);
		for(var i=index-1;i<this.cells.length;i++){
				this.getCell(i).children[0].index=i;//设置插入后的cell的index值
			}
		//从当前元素开始添加单元格直到当前单元格的个数
		for(var i=index;i<=this.items.length;i++){
			var currentPage=Math.floor((i-1)/(this.column*this.row));//要删除的页数，从0开始计
			if(currentPage>this.pageCount-1){
				this.pageCount=currentPage+1;
		      var slidepage = new Emp.Panel({"layout":"VBox",width:"100%",height:"100%"});
				//先渲染所有需要的行数，每行的列数按需求添加
			 for(var rowIndex=0;rowIndex<this.row;rowIndex++)
			 {
			  	var row = new Emp.Panel({width:"100%",height:"100%"});
			  		slidepage.add(row);				
			 }
			 this.slide.add(slidepage);	 	
				}
			var currentRow=Math.floor((i-currentPage*this.column*this.row-1)/this.column);//计算要删除的行数，从0开始计
			var currentCol=((i-currentPage*this.column*this.row)-1)%this.column//计算要删除的列数，从0开始计
			if(this.items.length!=i){
				this.slide.content.pages[currentPage].children[currentRow].remove(currentCol); 
				}
			this.slide.content.pages[currentPage].children[currentRow].add(this.getCell(i-1),currentCol);
			}
		},
	getCell:function(index){
		return this.cells[index];
	},
	afterRender:function(width,height)
	{
	    this.isRender=true;
		if(this.column==null){
			 var wx=Utils.dp2px(this.itemWidth);
			this.column=(width-width%wx)/wx;
			}
		//计算列数
		if(this.row==null) {
			var wh=Utils.dp2px(this.itemHeight)
			this.row=(height-height%wh)/wh
			}
	    //计算分页
		this.pageCount=0;
		if(this.items.length!=0)
		{
			var mode=this.items.length%(this.row*this.column);
			if(mode!=0)
			 this.pageCount=(this.items.length-mode)/(this.row*this.column)+1;
				else
			 this.pageCount=(this.items.length-mode)/(this.row*this.column);			
		}
		 
		 this.slide = new Emp.SlidePage({width:"100%",height:"100%"});		
		 this.slide.setTipVisible(this.tipVisible);
		//当只有一页时，不显示tip
		 if(this.pageCount<=1){
			this.slide.setTipVisible(false);	
		 }
		for(var pageIndex=0;pageIndex< this.pageCount;pageIndex++)
		{
		 var slidepage = new Emp.Panel({"layout":"VBox",width:"100%",height:"100%"});
		//先渲染所有需要的行数，每行的列数按需求添加
		 for(var rowIndex=0;rowIndex<this.row;rowIndex++)
		 {
		  	var row = new Emp.Panel({width:"100%",height:"100%"});
		  		for(var cellIndex=0;cellIndex<this.column;cellIndex++)
		  			{
		  				var index=pageIndex*this.row*this.column+rowIndex*this.column+cellIndex;
		  				//按需求添加列数
		  				if(index<this.items.length){
		  				var cell=this.createCell(index);
		  				row.add(cell);	
		  				this.cells.push(cell);		  			
		  			}			
		  			}  
		  		slidepage.add(row);				
		 }
		 this.slide.add(slidepage);	 	
		}
		this.add(this.slide);
	},
	//创建单元格
	createCell:function(index)
	{
	    var gridCellContainer = new Emp.Panel({"height":"100%","vAlign":"middle","hAlign":"center","layout":"VBox","width":"100%"});		
	      gridCellContainer.setWidth(Utils.dp2px(this.itemWidth)+"px");//gggggggggggggggggggggggggggggggggggggggg
		var grid=this;
		if(index<this.items.length)//index从0开始计，表示cells数组或者items数组的下标
		{
		    var item=this.items[index];
		    var cell;
		    if(this.onItemCreate!=null) cell=this.onItemCreate(item.label, item.icon)
		    else 
			cell= this.defaultCellCreate(item.label, item.icon);		
			cell.index=index;	
		  	cell.addEvent("onClick",function(){
		  		//alert(this.index)
		  		if(grid.onItemClick!=null)
		  		{
		  			grid.onItemClick(this.index,grid.items[this.index].tag,grid.items[this.index]);
		  		}
		  	}); 
	  		cell.addEvent("onClickHold",function(){
		  		//alert(this.index)
		  		if(grid.onItemLongClick!=null)
		  		{
		  			grid.onItemLongClick(this.index,grid.items[this.index].tag,grid.items[this.index]);
		  		}
		  	}); 	
	  				
			gridCellContainer.add(cell)
		}
		return gridCellContainer;
	},  
	defaultCellCreate:function(text,icon,page,rowIndex,colIndex,index){		
		 var gridCell = new Emp.Panel({"height":this.itemHeight,"vAlign":"middle","hAlign":"center","layout":"VBox","width":this.itemWidth});
   		 var itemImg = new Emp.Image({"height":this.itemImageHeight,"width":this.itemImageWidth,"src":icon});
         gridCell.add(itemImg);
         if(text!=null){
         var itemInput = new Emp.Label({"singleLine":true,"value":text,"marginTop":5,"color":this.textColor,fontSize:this.textSize});
         gridCell.add(itemInput);}
            // gridCellContainer.add(gridCell);
         return gridCell; 
	}	   
	}); 
	
/*
Emp.GridView = Emp.extend(Emp.View, {
	// constructionInfo:{type:'baseui',model:'NativeNineGrid'},
	init : function(params) {
		Emp.GridView.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeNineGrid'
		};
	},
	setItems : function(json) {
		this.content.items = json;
		this.fireMethod("setItems", this.content.items);
	},
	setPageSize : function(pageSize) {
		this.content.pageSize = pageSize;
	},
	setColumn : function(column) {
		this.content.column = column;
	},
	setIconHeight : function(iconHeight) {
		this.content.iconHeight = iconHeight;
	},
	setIconWidth : function(iconWidth) {
		this.content.iconWidth = iconWidth;
		
	},
	setTextSize : function(textSize) {
		this.content.textSize = textSize;
	},
	setTextColor : function(textColor) {
		this.content.textColor = textColor;
	}

});*/
/*
Emp.ExpandListView = Emp
		.extend(Emp.ListView,
				{
					// constructionInfo:{type:'baseui',model:'NativeListView'},
					init : function(params) {
						Emp.ListView.superclass.init.call(this, params);
						this.content.constructionInfo = {
							type : 'baseui',
							model : 'NativeExpendListview'
						};
					},
					setTemplates : function(template) {
						var obj = {};
						for ( var key in template) {
							var t = template[key];
							if (t.__isTemplate == true) {
								obj[key] = t.children[0];
							} else {
								obj[key] = t;
							}
						}

						this.content.template = obj;
					},
					setTemplate : function(tem) {
						if (!this.content.template) {
							this.content.template = {};
						}
						if (tem.__isTemplate == true) {
							this.content.template[this.modelId
									+ "NativeListView"] = tem.children[0];
						} else {
							this.content.template[this.modelId
									+ "NativeListView"] = tem;
						}
					},
					setItems : function(json) {
						this.content.items = json;
					},

					reloadData : function() {
						this.isRender=true;
						var s = {};
						s.method = "reLoad";
						empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
					},
					setEnablePullDown : function(value) {
						this.content.enablePullDown = value;
						this.fireMethod("setEnablePullDown",
								this.content.enablePullDown);
					},
					setEnablePullUp : function(value) {
						this.content.enablePullUp = value;
						this.fireMethod("setEnablePullUp",
								this.content.enablePullUp);
					},
					setExpandGroup:function(value){
						this.content.expandGroup =value;
					}
				});
*/
Emp.ExpandListView = Emp.extend(Emp.ListView, {
	init : function(params) {
		Emp.ExpandListView.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeExpandListView'
		};
	},
	setExpandImg:function(img){
		this.content.expandImg = img;
	},
	setUnExpandImg:function(img){
		this.content.expandImg = img;
	},
	setExpandGroup:function(value){
		this.content.expandGroup =value;
		var s = {};
		s.method = "setExpandGroup";
		s.value=value;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}
});
Emp.DownLoadTask = Emp.extend(Emp.Component, {
	// constructionInfo:{type:'notui',model:'NativeDownFile'},
	init : function(params) {
		Emp.DownLoadTask.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'DownLoadTask'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	getRemoteUrl : function() {
		return this.content.remoteUrl;
	},
	getLocalPath : function() {
		return this.content.localPath;
	},
	getFileName : function() {
		return this.content.localPath.substr(this.content.localPath
				.lastIndexOf("/") + 1);
	},
	start : function() {
		this.fireMethod("setPro", util.jsonToString(this.content));
		this.fireMethod("start");
	},
	stop : function() {
		this.fireMethod("stop", this.content.localPath);
	},
	reStart : function() {
		a = {};
		a.url = this.content.remoteUrl;
		a.localPath = this.content.localPath;
		this.fireMethod("reStart", util.jsonToString(a));
	},
	getStatus : function() {
		s = {};
		s.path = this.getLocalPath();
		// 是一个数组
		obj1 = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "getTask",
				s).evalJSON();
		obj = obj1[0];
		if (obj == null) {
			return null;
		}
		return obj.status;
	},
	getProgress : function() {
		s = {};
		s.path = this.getLocalPath();
		// 是一个数组
		obj1 = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "getTask",
				s).evalJSON();
		obj = obj1[0];
		if (obj == null) {
			return 0;
		}
		return obj.progress;
	},
	getSize : function() {
		s = {};
		s.path = this.getLocalPath();
		// 是一个数组
		obj1 = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "getTask",
				s).evalJSON();
		obj = obj1[0];
		if (obj == null) {
			return 0;
		}
		return obj.size;
	},
	getTotalSize : function() {
		s = {};
		s.path = this.getLocalPath();
		// 是一个数组
		obj1 = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "getTask",
				s).evalJSON();
		obj = obj1[0];
		if (obj == null) {
			return 0;
		}
		return obj.totalSize;
	}
});

Emp.DownLoadManager = {};
Emp.DownLoadManager.downfiles = {};
Emp.DownLoadManager.isAbsolute = function(path) {
	if (path.indexOf("data/data") >= 0
			|| path.indexOf(Emp.getDownLoadDir())>=0||path.indexOf("sd://")>=0 ) {
		return true;
	}
	return false;
}
Emp.DownLoadManager.getSystemTaskList = function() {
	// return
	// BridgeUtil.invokeMethod("donwFileBridge","getSystemTaskList",{}).evalJSON();
	return BridgeUtil.invokeBridgeResultMethod("donwFileBridge",
			"getSystemTaskList").evalJSON();
	// return Emp.fireBridgeMothed
	// ("donwFileBridge","getSystemTaskList").evalJSON();
};
Emp.DownLoadManager.getAllTaskList = function() {
	return BridgeUtil.invokeBridgeResultMethod("donwFileBridge",
			"getAllTaskList").evalJSON();
};
Emp.DownLoadManager.getUserTaskList = function() {
	return BridgeUtil.invokeBridgeResultMethod("donwFileBridge",
			"getUserTaskList").evalJSON();
	// return Emp.fireBridgeMothed
	// ("donwFileBridge","getUserTaskList").evalJSON();
};
Emp.DownLoadManager.getSystemTask = function(fileName) {
	if (!Emp.DownLoadManager.isAbsolute(fileName)) {
		fileName = Emp.getDownLoadDir() + fileName;
	}
	s = {};
	s.path = fileName;
	// 是一个数组
	obj1 = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "getTask", s)
			.evalJSON();
	obj = obj1[0];
	if (obj == null) {
		return null;
	}
	var down;
	if (Emp.DownLoadManager.downfiles[obj.localPath]) {
		down = Emp.DownLoadManager.downfiles[obj.localPath];
	} else {
		down = new Emp.DownLoadTask();
	}
	down.content.localPath = obj.localPath;
	down.content.remoteUrl = obj.remoteUrl;
	down.content.name = obj.name;
	down.content.totalSize = obj.totalSize;
	down.content.size = obj.size;
	down.content.progress = obj.progress;
	down.content.status = obj.status;
	Emp.DownLoadManager.downfiles[obj.localPath] = down;
	return down;
};
Emp.DownLoadManager.getUserTask = function(localPath) {
	if (!Emp.DownLoadManager.isAbsolute(localPath)) {
		localPath = Emp.getUserDownFilePath(localPath);
	}
	s = {};
	s.path = localPath;
	// 是一个数组
	obj1 = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "getTask", s)
			.evalJSON();
	obj = obj1[0];
	// alert(util.jsonToString(obj));
	// obj = Emp.fireBridgeMothed
	// ("donwFileBridge","getTask",util.jsonToString(s)).evalJSON();
	if (obj == null) {
		return null;
	}
	var down;
	if (Emp.DownLoadManager.downfiles[obj.localPath]) {
		down = Emp.DownLoadManager.downfiles[obj.localPath];
	} else {
		down = new Emp.DownLoadTask();
	}
	down.content.localPath = obj.localPath;
	down.content.remoteUrl = obj.remoteUrl;
	down.content.name = obj.name;
	down.content.totalSize = obj.totalSize;
	down.content.size = obj.size;
	down.content.progress = obj.progress;
	down.content.status = obj.status;
	return down;
};
/**
 * 获取系统下载应用对象
 */
Emp.DownLoadManager.createSystemTask = function(remoteUrl, filename) {
	var down = new Emp.DownLoadTask();
	down.content.remoteUrl = remoteUrl;
	down.content.name = filename;
	if (!Emp.DownLoadManager.isAbsolute(filename)) {
		filename = Emp.getDownLoadDir() + filename;
	}
	down.content.localPath = filename;
	return down;
}
Emp.DownLoadManager.createUserTask = function(remoteUrl, localPath) {
	var down = new Emp.DownLoadTask();
	down.content.remoteUrl = remoteUrl;
	var path=localPath;
	if (!Emp.DownLoadManager.isAbsolute(localPath)) {
		path = Emp.getUserDownFilePath(localPath);
	}
	// alert(path);
	down.content.localPath = path;
	down.content.name = down.content.localPath.substr(down.content.localPath
			.lastIndexOf("/") + 1);
	return down;
}
/**
 * 删除用户自定义下载任务对象 return boolean
 */
Emp.DownLoadManager.deleteUserTask = function(localPath) {
	if (!Emp.DownLoadManager.isAbsolute(localPath)) {
		localPath = Emp.getUserDownFilePath(localPath);
	}
	s = {};
	s.path = localPath;
	// s = Emp.fireBridgeMothed
	// ("donwFileBridge","deleteDownFile",util.jsonToString(s));
	t = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "deleteDownFile",
			s);
	if ("true" == t) {
		return true;
	} else {
		return false;
	}
}
/**
 * 删除系统下载应用对象 return boolean
 */
Emp.DownLoadManager.deleteSystemTask = function(filename) {
	if (!Emp.DownLoadManager.isAbsolute(filename)) {
		filename = Emp.getDownLoadDir() + filename;
	}
	s = {};
	s.path = filename;
	// s = Emp.fireBridgeMothed
	// ("donwFileBridge","deleteDownFile",util.jsonToString(s));
	t = BridgeUtil.invokeBridgeResultMethod("donwFileBridge", "deleteDownFile",
			s);
	if ("true" == t) {
		return true;
	} else {
		return false;
	}
}

Emp.Progress = Emp.extend(Emp.View, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeProgress',
	 * barType:'progress' },
	 */
	init : function(params) {
		Emp.Progress.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeProgress',
			barType : 'progress'
		};
	},
	setColor : function(mColor) {
		this.content.color = mColor;
		if (this.isRender) {
			var s = {};
			s.method = "setColor";
			s.value = mColor;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	}

});
Emp.ProgressBar = Emp.extend(Emp.View, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeProgress',
	 * barType:'progressBar' },
	 */
	init : function(params) {
		Emp.ProgressBar.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeProgress',
			barType : 'progressBar'
		};
	},
	setProgress : function(progress) {
		this.content.progress = progress;
		if (this.isRender) {
			var s = {};
			s.method = "setProgress";
			s.value = progress;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getProgress : function() {
		var s = {};
		s.method = "getProgress";
		return empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setTrackTintColor : function(color) {
		this.content.trackTintColor = color;
		if (this.isRender) {
			var s = {};
			s.method = "setTrackTintColor";
			s.value = color;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setProgressTintColor : function(color) {
		this.content.progressTintColor = color;
		if (this.isRender) {
			var s = {};
			s.method = "setProgressTintColor";
			s.value = color;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	start : function() {
		var s = {};
		s.method = "start";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	stop : function() {
		var s = {};
		s.method = "stop";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	pause : function() {
		var s = {};
		s.method = "pause";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	onProgressChange : function(callback) {
		Emp.addEvent(this.modelId + "onChange", callback);
	}
});
Emp.Image = Emp.extend(Emp.View, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeImage' },
	 */
	init : function(params) {
		Emp.Image.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeImage'
		};
	},
	setSrc : function(src,scaleType) {
		this.content.src = src;
		if (this.isRender) {
			var s = {};
			s.method = "setSrc";
			if(scaleType == undefined)
				s.value = {"src":src,"scaleType":"fitXY"};
			else
				s.value = {"src":src,"scaleType":scaleType};
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setBase64Image :function(base64Image){
		this.content.base64Image = base64Image;
		if (this.isRender) {
			var s = {};
			s.method = "setBase64Image";
			s.value = base64Image;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getSrc : function() {
		if (this.isRender) {
			var s = {};
			s.method = "getSrc";
			return empBridge
					.fireModelMethod(this.modelId, util.jsonToString(s));
		} else {
			return this.content.src;
		}
	},
	setScalable : function(isScalable) {
		this.content.scalable = isScalable;
		if (this.isRender) {
			var s = {};
			s.method = "setScalable";
			s.value = isScalable;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getScalable :function(){
		return this.content.scalable == undefined ?false:this.content.scalable;
	},
	setCacheable : function(cacheable) {
		this.content.cacheable = cacheable;
	},
	getCacheable : function() {
		return this.content.cacheable == undefined?false:this.content.cacheable;
	},
	setPreLoadImg : function(url) {
		this.content.preLoadImg = url;
	},
	getPreLoadImg :function(){
		return this.content.preLoadImg==undefined?null:this.content.preLoadImg;
	},
	setLoadErrorImg : function(url) {
		this.content.loadErrorImg = url;
	},
	getLoadErrorImg :function(){
		return this.content.loadErrorImg ==undefined?null:this.content.loadErrorImg;
	},
	setCircleClip:function(circleClip)
	{
		this.content.circleClip = circleClip;	
		var s = {};
		s.method = "setCircleClip";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		
	},
	getCircleClip :function(){
		return this.content.circleClip == undefined?false:this.content.circleClip;
	}
	

});

Emp.Text = Emp.extend(Emp.Label, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeInputText',
	 * widgetType : "text" },
	 */
	init : function(params) {
		Emp.Text.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeInputText',
			widgetType : "text"
		};
	},
	selectAll:function(){
		this.content.selectAll = "true";
		var _temp = this;
		Emp.addEvent(this.modelId + "onClick", function(){
			setTimeout(5,function(){
				var s = {};
				s.method = "selectAll";
				s.value = "true";
				empBridge.fireModelMethod(_temp.modelId, util.jsonToString(s));
			});
		}, this);
	},
	setLength:function(length){
		this.content.length=length;
		if (this.isRender) {
			var s = {};
			s.method = "setLength";
			s.value = length;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getLength:function(){
		return this.content.length==undefined?0:this.content.length;
	},
	setEmptyText : function(text) {
		this.content.emptyText = text;
		if (this.isRender) {
			var s = {};
			s.method = "setEmptyText";
			s.value = text;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}

	},
	getEmptyText  : function(){
		return this.content.emptyText==undefined?null:this.content.emptyText;
	},
	setInputType : function(type) {
		this.content.inputType = type;
		if (this.isRender) {
			var s = {};
			s.method = "setInputType";
			s.value = type;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getInputType :function(){
		return this.content.inputType ==undefined?"all":this.content.inputType;
	},
	setReadonly : function(readonly) {
		this.content.readonly = readonly;
		if (this.isRender) {
			var s = {};
			s.method = "setReadonly";
			s.value = this.content.readonly;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getReadonly : function() {
		return this.content.readonly;
	}

});
Emp.EncryptText = Emp.extend(Emp.Label, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeInputText',
	 * widgetType : "text" },
	 */
	init : function(params) {
		Emp.EncryptText.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeEncryptInputText'
		};
	},
	getEncryptValue : function(timeStamp)
	{
		if (this.isRender) {
			var s = {};
			s.method = "getEncryptValue";
			s.value = timeStamp;
			var result = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
			return result;
		}
	},
	setMaxLength : function(maxLength)
	{
		this.content.maxLength = maxLength;
		if (this.isRender) {
			var s = {};
			s.method = "setMaxLength";
			s.value = maxLength;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setMinLength : function(minLength)
	{
		this.content.minLength = minLength;
		if (this.isRender) {
			var s = {};
			s.method = "setMinLength";
			s.value = minLength;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setKbdRandom : function(kbdRandom)
	{
		this.content.kbdRandom = kbdRandom;
		if (this.isRender) {
			var s = {};
			s.method = "setKbdRandom";
			s.value = kbdRandom;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setKbdType : function(kbdType)
	{
		this.content.kbdType = kbdType;
		if (this.isRender) {
			var s = {};
			s.method = "setKbdType";
			s.value = kbdType;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	}

});
Emp.TextArea = Emp.extend(Emp.Text, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeInputText',
	 * widgetType : 'textarea' },
	 */
	init : function(params) {
		Emp.TextArea.superclass.init.call(this, params);
		this.content.vAlign="top";
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeInputText',
			widgetType : 'textarea'
		};
	},
	setIcon : function(icon) {
		this.content.icon = icon;
		if (this.isRender) {
			var s = {};
			s.method = "setIcon";
			s.value = icon;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setEmptyText : function(text) {
		this.content.emptyText = text;
		if (this.isRender) {
			var s = {};
			s.method = "setEmptyText";
			s.value = text;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setReadonly : function(readonly) {
		this.content.readonly = readonly;
		if (this.isRender) {
			var s = {};
			s.method = "setReadonly";
			s.value = this.content.readonly;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getReadonly : function() {
		return this.content.readonly;
	}
});
Emp.Select = Emp.extend(Emp.Label, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeSpinner' },
	 */
	init : function(params) {
		Emp.Select.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeSpinner'
		};
	},
	setReadonly : function(readonly) {
		this.content.readonly = readonly;
		if (this.isRender) {
			var s = {};
			s.method = "setReadonly";
			s.value = readonly;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	addItem : function(item) {
		this.content.item = item;
		if (this.isRender) {
			var s = {};
			s.method = "addItem";
			s.value = item;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setItems : function(items) {
		this.content.items = items;
		if (this.isRender) {
			var s = {};
			s.method = "setItems";
			s.value = items;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	removeItem : function(item) {
		this.content.delItem = item;
		if (this.isRender) {
			var s = {};
			s.method = "removeItem";
			s.value = item;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	}
});

/**
* radio对象
*/
Emp.RadioItem = Emp.extend(Emp.Panel, {
	init : function(params) {
		var labelParams = {};
		for(var a in params){
			labelParams[a] = params[a];
		}
		labelParams.value = labelParams.text;
		labelParams['class']="emp-radio-label";
		
		Emp.RadioItem.superclass.init.call(this, params);
		this.value=params.value;
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel',
			htmlType : 'radio'
		};
		this.content['class'] = "emp-radio";
		this.__selectImg = new Emp.Panel({
			'class' : "emp-radio-select",
			position:"relative",
			top:0,
			left:0
		});
		this.__unSelectImg = new Emp.Panel({
			'class' : "emp-radio-unSelect",
			position:"relative",
			top:0,
			left:0
		});
		
		this.__label = new Emp.Label(labelParams);
		this.__button=new Emp.Panel({
			'class' : "emp-radio-button"
		});
		this.children.push(this.__button);
		this.__button.add(this.__unSelectImg);
		this.__button.add(this.__selectImg);
		this.children.push(this.__label);
		this.addEvent("onClick", function() {
			if(this.getReadonly()=="true") return ;
		    if(this.status==false) return ;
			this.select(this.status);
			this.setRadioValue(this.value);
		})
		this.setChecked(params.checked)
	},
	select : function(status) {
	    this.__selectImg.setVisibility(true);
		this.__selectImg.clearAnimation();
		if (status == true) {
			//选中状态
			this.status = false
			var aa = new Emp.AlphaAnimation({
				fromAlpha : 0,
				toAlpha : 1,
				duration : 300
			});
			this.__selectImg.addAnimation(aa);
		} else {
			this.status = true
			var aa = new Emp.AlphaAnimation({
				fromAlpha : 1,
				toAlpha : 0,
				duration : 250
			});
			this.__selectImg.setVisibility(false);
			this.__selectImg.addAnimation(aa);
		}
		//this.__selectImg.startAnimation();
	},
	setChecked:function(checked)
	{	
		if(checked==true)
		{
		 this.__selectImg.setVisibility(true);
		 this.status=false
		 }
		 	else
		 {
		 this.__selectImg.setVisibility(false);
		 this.status=true;
		 }
	}

});
/**
 * radio控件
 */
Emp.Radio = Emp.extend(Emp.Panel, {
	
	readonly:false,
	init : function(params) {
		Emp.Radio.superclass.init.call(this, params);
		this.value=params.value;
		
		this.color=params.color;
		this.fontSize=params.fontSize;
		
		this.setAttrAdapter=undefined;
		this.readonly=params.readonly||params.disabled;
        //2016年5月5日--罗登林修改（bugID为46395）--把原来的params.items的东西复制一份
        var tempItems = params.items.concat();
        //清空params.items
        this.content.items = new Array();
        this.setItems(tempItems);
	},
	addItem : function(item) {
		if(this.value)
		{
			if(item.value==this.value) item.checked=true; 
		}
	   var it=	new Emp.RadioItem(item);
	   if(this.color) it.__label.setColor(this.color);
	   if(this.fontSize) it.__label.setFontSize(this.fontSize);
	   if(this.fontBold) it.__label.setFontBold(this.fontBold);
	   var _radio=this
		it.setRadioValue=function(v)
		{
			_radio.unSelect(_radio.value);
			var o=_radio.value
			_radio.value=v;
			if(_radio["onChange"])_radio["onChange"](o,v)
			_radio.resetStatus();//2014-10-13 更改 radio 在dialog中 图标状态不准确，每次在选中时，重置其他item的状态
		};
		   it.getReadonly=function(){
			  return _radio.readonly; 
		   }
		this.add(it);
        this.content.items.push(item);
	},
	setItems : function(items) {
		if (items != null) {
			this.removeAll();//modify by sujz fix bug 44805
			var l = items.length;
			for ( var i = 0; i < l; i++) {
				this.addItem(items[i]);
			}
		}
	},
	removeItem : function(item) {
		this.content.delItem = item;

		for ( var i = 0; i < this.content.items.length; i++) {

			if (item.value == this.content.items[i].value) {
				this.remove(i);
                this.content.items.splice(i,1);
				break;
			}
		}
	
	},
	setValue : function(value) {
		this.value=value;
		this.resetStatus();
	},
	getValue : function(value) {
		return this.value;
	},
	resetStatus:function(){
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].setChecked(this.children[i].value==this.value);
		}	
	},
	unSelect:function(v){
		for(var i=0;i<this.children.length;i++)
		{		
		   if( this.children[i].value==v)
		       //alert(this.children[i].value)
				this.children[i].select(false);
		}	
	}
	,
	addEvent:function(eventName,fn)
	{
		this[eventName]=fn;
	},
	
	setReadonly:function(readonly){
		this.readonly=readonly;
	},		
	setDisabled:function(readonly){
		this.readonly=readonly;
	},
	setColor:function(color){
	   this.color=color;
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].__label.setColor(color);
		}	
	},
	getColor:function(){
	return this.color;
	},
	setFontSize:function(size){
	   this.fontSize=size;
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].__label.setFontSize(size);
		}	
	},
	getFontSize:function(){
		return this.fontSize;
	},
	setFontBold:function(bold){
	   this.fontBold=bold;
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].__label.setFontBold(bold);
		}
	},
	getFontBold:function(){
		return this.fontBold;
	}	
	
});


/**
 * checkBox对象
 */
Emp.CheckboxItem = Emp.extend(Emp.Panel, {
	init : function(params) {
		var labelParams = {};
		for(var a in params){
			labelParams[a] = params[a];
		}
		labelParams.value = labelParams.text;
		labelParams.class="emp-checkbox-label";
		Emp.CheckboxItem.superclass.init.call(this, params);
		this.value=params.value;
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel',
			htmlType : 'checkbox'
		};
		this.content.class = "emp-checkbox";
		this.__selectImg = new Emp.Panel({
			class : "emp-checkbox-select",
			position:"relative",
			top:0,
			left:0
		});
		this.__unSelectImg = new Emp.Panel({
			class : "emp-checkbox-unSelect",
			position:"relative",
			top:0,
			left:0
		});
		this.__label = new Emp.Label(labelParams);
		this.__button =  new Emp.Panel({
			class : "emp-checkbox-button"
		});
		this.children.push(this.__button);		
		this.__button.add(this.__unSelectImg);
		this.__button.add(this.__selectImg);
		this.children.push(this.__label);
		this.addEvent("onClick", function() {
			this.select(this.status);
			this.setCheckboxValue(this.value,this.status);
		})
		this.setChecked(params.checked);
	},
	select : function(status) {
        if(this.getReadonly()+""=="true") return;
	    this.__selectImg.setVisibility(true);
		this.__selectImg.clearAnimation();
		if (status == true) {
			this.status = false;
			var aa = new Emp.AlphaAnimation({
				fromAlpha : 0,
				toAlpha : 1,
				duration : 250
			});
			this.__selectImg.addAnimation(aa);
		} else {
			this.status = true;
			this.__selectImg.setVisibility(false);
			var aa = new Emp.AlphaAnimation({
				fromAlpha : 1,
				toAlpha : 0,
				duration : 250
			});
			this.__selectImg.addAnimation(aa);
		}
		//this.__selectImg.startAnimation();
	},
	setChecked:function(checked)
	{	
		if(checked==true)
		{
		 this.__selectImg.setVisibility(true);
		 this.status=false;
		 }
		 	else
		 {
		 this.__selectImg.setVisibility(false);
		 this.status=true;
		 }
	}

});


/**
 * Checkbox group对象
 */
Emp.CheckBox = Emp.extend(Emp.Panel, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeCheckboxGroup',
	 * layout:'HBox' },
	 */
	init : function(params) {
		Emp.CheckBox.superclass.init.call(this, params);
		this.value=params.value||"";
		//this.content.name=params.name;
		this.readonly=params.readonly||params.disabled;
		this.color=params.color;
		this.fontSize=params.fontSize;		
		this.setAttrAdapter=undefined;		
		this.splitChar=params.splitChar||","		
		this.arrayValue=new Array();
		if(this.value.indexOf(",")!=-1){
			var arr=this.value.split(",");
			for(var i=0;i<arr.length;i++){
				this.arrayValue.push(arr[i])//arrayValue表示的是应该选中的值
				}
		}
		else
		if(this.value!=""&&this.value!=null)
		{
			this.arrayValue.push(this.value.split(","));
		} 
		//2016年5月4日--罗登林修改（bugID为46394）--把原来的params.items的东西复制一份
        var tempItems = params.items.concat();
        //清空params.items
        this.content.items = new Array();
        this.setItems(tempItems);
	},
	addItem : function(item) {
		if(item.checked=='true'){
			item.checked=true;
			this.arrayValue.push(item.value);
		}
		if(this.value!="")
		{
		   var v=this.splitChar+this.value+this.splitChar;
			if(v.indexOf(item.value)!=-1) item.checked=true;
		}
	   var it=	new Emp.CheckboxItem(item)
	   if(this.color) it.__label.setColor(this.color);
	   if(this.fontSize) it.__label.setFontSize(this.fontSize);
	   if(this.fontBold) it.__label.setFontBold(this.fontBold);	   
	   var _checkbox=this;
		it.setCheckboxValue=function(v,status)
		{
			if(_checkbox.readonly==true||_checkbox.readonly=='true')
				return;
			var o=_checkbox.arrayValue.toString();
			if(status==true){//从value中删除v
				_checkbox.arrayValue.remove(_checkbox.arrayValue.indexOf(v))
			}else{//添加v
				_checkbox.arrayValue.push(v);
			}
			_checkbox.value=_checkbox.arrayValue.toString();
			//_checkbox.resetStatus();
			if(_checkbox["onChange"])_checkbox["onChange"](o,_checkbox.arrayValue.toString())
			
		}
		 it.getReadonly=function(){
			  return _checkbox.readonly; 
		   };
		   //modified by sujz 当checkboxitem有两个相同的value值时，后面的值会覆盖掉前面的值
		   if(this.children.length==0)this.add(it);
		   else{
		   	var flag=true;
		   for(var i=0;i<this.children.length;i++){
		   	if(item.value==this.children[i].value){
		   		this.remove(i);
		   		//2016年5月4日--罗登林添加，为了解决重复添加item的问题（bugID为46394）
		   		this.content.items.splice(i,1);
		   		this.add(it,i); 
		   		flag=false;
		   		break;
		   		}
		   	}
		   	if(flag)this.add(it);
		}
		//2016年5月4日--罗登林添加--（bugID为46394）--记录所有添加进来的item
		this.content.items.push(item);
	},
	setItems : function(items) {
		if (items != null) {
			var l = items.length;
			for ( var i = 0; i < l; i++) {
				this.addItem(items[i])
			}
		}
	},
	removeItem : function(item) {
		this.content.delItem = item;
		//2016年5月4日--罗登林添加--（bugID为46394）--从数据源里面寻找是否含有传进来的item的value
		for ( var i = 0; i < this.content.items.length; i++) {

			if (item.value == this.content.items[i].value) {
				this.remove(i);
				this.content.items.splice(i,1);
				break;
			}
		}
	
	},
	setValue : function(value) {
		this.value=value+"";
		//需要重新创建一个数组
		this.arrayValue=new Array();
		
		if(this.value.indexOf(",")!=-1){
			var arr=this.value.split(",");
			for(var i=0;i<arr.length;i++){
				this.arrayValue.push(arr[i])
				}
		}
		else
		if(this.value!=""&&this.value!=null)
		{
			this.arrayValue.push(this.value.split(","));
		} 
		//需要清除之前的动画效果
		for(var i=0;i<this.children.length;i++)
		{							
			this.children[i].__selectImg.clearAnimation();			     			
		}	
		this.resetStatus();

	},

	getValue : function(value) {
		var v="";
		var s=true;
		for(var i=0;i<this.children.length;i++)
			{		
			   if( this.children[i].status==false)
			       //alert(this.children[i].value)
			       if(s==true)
			       {
			       v=v+this.children[i].value
			       s=false;
			       }
			       else
			        v=v+this.splitChar+this.children[i].value;
			}	
		return v;
	},
	resetStatus:function(){
		var v=this.splitChar+this.value+this.splitChar;
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].setChecked(v.indexOf(this.children[i].value)!=-1);
		}	
	},
	unSelect:function(v){
		for(var i=0;i<this.children.length;i++)
		{		
		   if( this.children[i].value==v)
		       //alert(this.children[i].value)
				this.children[i].select(false);
		}	
	}
	,
	addEvent:function(eventName,fn)
	{
		this[eventName]=fn;
	}
	,	
	setReadonly:function(readonly){
		this.readonly=readonly;
	},		
	setDisabled:function(readonly){
		this.readonly=readonly;
	},
	setColor:function(color){
	   this.color=color;
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].__label.setColor(color);
		}	
	},
	getColor:function(){
		return this.color;
	},
	setFontSize:function(size){
	   this.fontSize=size;
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].__label.setFontSize(size);
		}	
	},
	getFontSize:function(){
		return this.fontSize;
	},
	setFontBold:function(bold){
	   this.fontBold=bold;	   
		for(var i=0;i<this.children.length;i++)
		{
			this.children[i].__label.setFontBold(bold);
		}	
	},
	getFontBold:function(){
		return this.fontBold;
	}	
	
});

/*
 *  方法:Array.indexOf(dx)
 *  功能:根据元素值删除数组元素.
 *  参数:元素值
 *  返回:在原数组上修改数组
 *	作者：pxp
 */
Array.prototype.indexOf = function (val) {
	for (var i = 0; i < this.length; i++) {
		if (this[i] == val) {
			return i;
		}
	}
	return -1;
};


/*
 *  方法:Array.remove(dx)
 *  功能:根据元素位置值删除数组元素.
 *  参数:元素值
 *  返回:在原数组上修改数组
 *	作者：pxp
 */
Array.prototype.remove = function (dx) {
	if (isNaN(dx) || dx > this.length) {
		return false;
	}
	for (var i = 0, n = 0; i < this.length; i++) {
		if (this[i] != this[dx]) {
			this[n++] = this[i];
		}
	}
	this.length -= 1;
};

Emp.Date_Bt = Emp.extend(Emp.Panel, {
	
	init : function(params) {
		Emp.Date_Bt.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel'
		};
		this.content.class = "emp-date-bt";
		this.__selectImg = new Emp.Panel({
			class : "emp-date-bt-press",
			position:"relative",
			top:7,
			left:0
		});
		this.__unSelectImg = new Emp.Panel({
			class : "emp-date-bt-unpress",
			position:"relative",
			top:7,
			left:0
		});
		this.children.push(this.__unSelectImg);
		this.children.push(this.__selectImg);

	},
	select:function(checked)
	{	
		if(checked==true)
		{
		 this.__unSelectImg.setVisibility(false);
		 this.__selectImg.setVisibility(true);
		 }
		 	else
		 {
		  this.__unSelectImg.setVisibility(true);
		  this.__selectImg.setVisibility(false);
		 }
	}

});


Emp.Date = Emp.extend(Emp.Panel, {
	init : function(params) {
        params.width=params.width||-2;
        Emp.Date.superclass.init.call(this,params);
        this.content.name=params.name;
        var date=this;
        date.setAttrAdapter=undefined;
        this.readonly=params.readonly||params.disabled;
        var p={};
        for(var a in params){
            p[a]= params[a];
        }
        p.value=params.value;
        p.disabled=params.disabled;
        p.readonly=params.readonly;
        if(params.displayFormat)
        	p.displayFormat = params.displayFormat;
        p.dateMode = params.dateMode==undefined?"date":params.dateMode;
        p.width=params.width==undefined||'100%'?-1:params.width-40;//modify by liulei  如果date控件设置了宽度，右侧图标不靠右对齐
		this.__input=new Emp.DateInput(p);
		this.__bt=new Emp.Date_Bt();
		var bt=this.__bt;
		var input=this.__input;
		
		this.children.push(this.__input);
		this.children.push(this.__bt);
	    eval('this.content.class = "emp-date-ct";');
		this.__input.addEvent("onPressDown",function(){
			if(date.readonly+""=="true") return;
			bt.select(true);
		});
		
		this.__input.addEvent("onPressUp",function(){
	    	if(date.readonly+""=="true") return;
			bt.select(false);	
			this.showDialog();
		});	
	
		this.__bt.addEvent("onPressDown",function(){
			if(date.readonly+""=="true") return;
			bt.select(true);
		});
		
		this.__bt.addEvent("onPressUp",function(){
	    	if(date.readonly+""=="true") return;
			bt.select(false);	
			input.showDialog();
		});	
		this.__bt.addEvent("onClick",function(){
	    	if(date.readonly+""=="true") return;
			bt.select(false);	
			input.showDialog();
		});
		this.addEvent("onPressDown",function(){
			if(date.readonly+""=="true") return;
			bt.select(true);
		});
		this.addEvent("onPressUp",function(){
			//if(this.readonly+""=="true") return;
			bt.select(false);
			date.__input.showDialog();
		});
		
	},	
	setDisplayFormat : function(displayFormat) {
		this.__input.setDisplayFormat(displayFormat);	
	},
	setDateMode :function(dateMode){
		this.__input.setDateMode(dateMode);
	},
	addEvent:function(n,f)
	{
	   if(n=="onChange")
			this.__input.addEvent(n,f);
	},
	getValue:function(){
	
		return this.__input.getValue();
	}
	,
	setValue:function(value){
		 this.__input.setValue(value);
	}
	,setReadonly:function(readonly){
		this.readonly=readonly;
	},
	getReadonly:function(){
		return this.readonly;
	},
	getDisabled:function(){
		this.getReadonly();
	},
	setDisabled:function(disabled){
		this.setReadonly(disabled);
	},
	getColor:function(){
		this.__inputget.Color();
	},
	setColor:function(color){
		this.__input.setColor(color);
	},
	getFontSize:function(){
		this.__input.getFontSize();
	},
	setFontSize:function(fontsize){
		this.__input.setFontSize(fontsize);
	},
	getFontBold:function(){
		this.__input.getFontBold();
	},
	setFontBold:function(bold){
		this.__input.setFontBold(bold);
	},
	getFontWeight:function(){
		this.__input.getFontWeight();
	},
	setFontWeight:function(bold){
		this.__input.setFontWeight(bold);
	}					
});
Emp.DateView = Emp.extend(Emp.Panel, {
	init : function(params) {
		//this.content.dateMode="date";
		Emp.DateView.superclass.init.call(this, params);
		this.content.constructionInfo = {
				type : 'baseui',
				model : 'NativeDateView'
		};
	},
	setDateMode:function(dateMode){
		if(!dateMode)
			dateMode = "date";
		this.content.dateMode = dateMode;
		this.fireMethod('setDateMode',dateMode);
	}
});
Emp.DateInput = Emp.extend(Emp.Text, {
	init : function(params) {
		Emp.DateInput.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeDate',
			widgetType:"date"
		};
		
		if(!this.content.value){
			var dateMode = this.content.dateMode;
			
			var format = "yyyy-MM-dd";
			if(dateMode=='datetime'){
				format = "yyyy-MM-dd hh:mm";
			}else if (dateMode == "time"){
				format = "hh:mm";
			}
			this.content.realValue = new Date().format(format);
			if(this.content.displayFormat)
				format = this.content.displayFormat;
			this.content.value= new Date().format(format);
		}else{
			this.content.realValue =this.content.value;
			if(this.content.displayFormat){
				format = this.content.displayFormat;
				var date = new Date(this.content.value+"").format(format);
				this.content.value= date;
			}
		}
		this.__dateView = new Emp.DateView({width:'100%',height:'-2',dateMode:params.dateMode,displayFormat:format,value:this.content.realValue});
	
	},
	setValue:function(displayvalue,realvalue){
		Emp.DateInput.superclass.setValue.call(this, displayvalue);
		this.__dateView.setValue(realvalue);
	},
	getValue:function(){
		return this.__dateView.content.value;
	},
	setDateMode:function(dateMode){
		this.content.dateMode = dateMode;
		this.__dateView.setDateMode(dateMode);
		var format = "yyyy-MM-dd";
		if(dateMode=='datetime'){
			format = "yyyy-MM-dd hh:mm";
		}else if (dateMode == "time"){
			format = "hh:mm";
		}
		var date = new Date();
		this.setDisplayFormat(format);
		this.setValue(date.format(format));
	},
	setDisplayFormat : function(displayFormat) {
		this.content.displayFormat = displayFormat;
		if (this.isRender) {
			var s = {};
			s.method = "setDisplayFormat";
			s.value = displayFormat;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	}
	,
	showDialog:function()
	{
		 _date_dialog = new Emp.CustomDialog({"id":"_date_dialog"});

		var _div_279150739 = new Emp.Panel({"id":"_div_279150739","height":"100%","vAlign":"middle","hAlign":"center","width":"100%"});
	    var _div_1582185325 = new Emp.Panel({"id":"_div_1582185325","borderColor":"#eeefef","height":"260","backgroundColor":"#eeefef","borderWidth":"1","layout":"VBox","hAlign":"center","width":"300","cornerRadius":"5"});
	    var _div_1646240121 = new Emp.Panel({"id":"_div_1646240121","height":"50","vAlign":"middle","hAlign":"center","width":"100%"});
	    var _date_titleInfo = new Emp.Label({"id":"titleInfo","value":"请选择日期","fontSize":"18"});
	    if(this.content.dateMode=='time'){
	    	_date_titleInfo.setValue('请选择时间');
	    }else if(this.content.dateMode=='datetime'){
	    	_date_titleInfo.setValue('请选择日期时间');
	    }
	    _div_1646240121.add(_date_titleInfo);
	                _div_1582185325.add(_div_1646240121);
	        var _div_577411881 = new Emp.Panel({"id":"_div_577411881","height":"1","backgroundColor":"#cccccc","width":"100%"});
	            _div_1582185325.add(_div_577411881);
	        var parent = new Emp.Panel({"id":"parent","height":"100%","backgroundColor":"#ffffff","vAlign":"middle","overflow":"y","hAlign":"center","width":"100%","bounces":"false"});//2016年4月19日--罗登林修改（为了解决日期控件，滑动会出现弹跳效果的bug）
	            _div_1582185325.add(parent);
	        var _div_1448102162 = new Emp.Panel({"id":"_div_1448102162","height":"1","backgroundColor":"#cccccc","width":"100%"});
	            _div_1582185325.add(_div_1448102162);
	        var _div_820865283 = new Emp.Panel({"id":"_div_820865283","vAlign":"middle","hAlign":"center","width":"100%","layout":"HBox"});
	    	var _date_cancelConfirm = new Emp.Label({"id":"_date_cancelConfirm","height":"40","width":"100%","hAlign":"center","value":"取 消","fontSize":"16"});
	            _div_820865283.add(_date_cancelConfirm);
	        var _div_1480333926 = new Emp.Panel({"id":"_div_1480333926","height":"50","backgroundColor":"#cccccc","width":"1"});
	            _div_820865283.add(_div_1480333926);
	        var _date_okConfirm = new Emp.Label({"id":"_date_okConfirm","height":"40","width":"100%","hAlign":"center","value":"确 认","fontSize":"16"});
	            _div_820865283.add(_date_okConfirm);
	                _div_1582185325.add(_div_820865283);
	                _div_279150739.add(_div_1582185325);
	                _date_dialog.setView(_div_279150739);
	     __temp = this;
	     this.__dateView.addEvent("onDateChange",function(time,format){
			var date = new Date(time);
			var result = date.format(format);
			_date_titleInfo.setValue(result);
			__temp.__dateView.content.value=result;
			__temp.content.value = result;
			if(__temp.content.displayFormat)
				__temp.content.value = date.format(__temp.content.displayFormat);
				
		});
		parent.add(this.__dateView);
		
		_date_okConfirm.addEvent("onClick",function(){
			__temp.setValue(__temp.content.value,__temp.__dateView.content.value);
			_date_dialog.close();
		});
		_date_cancelConfirm.addEvent("onClick",function(){
			_date_dialog.close();
		}); 
		_date_dialog.show();
	}
});

// lxg
Emp.Init = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Init.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'NativeInit'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	createSecurityChannel : function(onSuccess, onFailure) {
		var s = {};
		s.method = "createSecurityChannel";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		if (onSuccess) {
			Emp.addEvent(this.modelId + "onSuccess", onSuccess);
		}
		if (onFailure) {
			Emp.addEvent(this.modelId + "onFailure", onFailure);
		}
	},
	hasUpdatableClient : function(onSuccess, onFailure) {
		var s = {};
		s.method = "hasUpdatableClient";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		if (onSuccess) {
			Emp.addEvent(this.modelId + "onSuccessHasUpdateClient", onSuccess);
		}
		if (onFailure) {
			Emp.addEvent(this.modelId + "onFailureHasUpdateClient", onFailure);
		}
	},
	hasUpdatableApp : function(onSuccess, onFailure) {
		var s = {};
		s.method = "hasUpdatableApp";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		if (onSuccess) {
			Emp.addEvent(this.modelId + "onSuccessHasUpdate", onSuccess);
		}
		if (onFailure) {
			Emp.addEvent(this.modelId + "onFailureHasUpdate", onFailure);
		}
	},
	appUpdate : function(onSuccess, onFailure) {
		var s = {};
		s.method = "appUpdate";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		if (onSuccess) {
			Emp.addEvent(this.modelId + "onSuccess", onSuccess);
		}
		if (onFailure) {
			Emp.addEvent(this.modelId + "onFailure", onFailure);
		}
	},
	startMsgService : function(onSuccess, onFailure) {
		var s = {};
		s.method = "startMsgService";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		if (onSuccess) {
			Emp.addEvent(this.modelId + "onSuccess", onSuccess);
		}
		if (onFailure) {
			Emp.addEvent(this.modelId + "onFailure", onFailure);
		}
	},
	install : function(srcFile){
		var s = {};
		s.method = "install";
		s.value = srcFile;
		return empBridge.fireModelMethod(this.modelId, util.jsonToString(s))=="true";
	},
	uninstall : function(appId){
		var s = {};
		s.method = "uninstall";
		s.value = appId;
		return empBridge.fireModelMethod(this.modelId, util.jsonToString(s))=="true";
	}
	
});
// lxg end
Emp.Ajax = Emp.extend(Emp.Component, {
	/*
	 * constructionInfo : { type : 'notui', model : 'NativeAjax' },
	 */
	init : function(params) {
		Emp.Ajax.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'NativeAjax'
		};
		this.data={};
		this.isRender = true;
		this.content.files = [];
		var ajax=this;
		Emp.addEvent(this.modelId + "onTimeout", function(){
			var initor = new $M.Init();
			initor.createSecurityChannel(function() {	
				ajax.data=ajax.bakdata;
				ajax.submit();
			});
		});
		Emp.newNativeObject(this);
	},
	
	add: function(key,value) {
		this.data[key]=value;
	},
	addParam : function(param) {
		this.data[param.name]=param.value;
	},
	
	/**
	 * 废弃，不再支持
	 * 
	 */
	addParams : function(params) {
		//modify by liulei 
		//fix bug  44424
		//description form 表单提交时，参数无法传递bug
		if(params){
			var temp = util.stringToJson(params);
			for(var i=0;i<temp.length;i++){
				this.add(temp[i].name,temp[i].value);
			}
		}
//		var s = {};
//		s.method = "addParams";
//		s.value = params;
//		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	addFile : function(param) {
		this.content.files.push(param);
		this.fireMethod("addFile", param);
	},
	addFiles : function(fileUrls) {
		this.content.files = this.content.files.concat(fileUrls);
		this.fireMethod("addFiles", fileUrls);
	},
	setSecured : function(secured) {
		var s = {};
		s.method = "setSecured";
		s.value = secured;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setPostXml : function(postXml) {
		var s = {};
		s.method = "setPostXml";
		s.value = postXml;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	addHeader:function(name,value){
		var s= {};
		s.method = "addHeader";
		var temp ={};
		temp.name=name;
		temp.value=value;
		s.value = temp;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setPostXmlRoot : function(postXmlRoot) {
		var s = {};
		s.method = "setPostXmlRoot";
		s.value = postXmlRoot;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setPostXmlPrefix : function(postXmlPrefix) {
		var s = {};
		s.method = "setPostXmlPrefix";
		s.value = postXmlPrefix;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setAction : function(action) {
		var s = {};
		s.method = "setAction";
		s.value = action;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setTimeout:function(time){
		var s = {};
		s.method = "setTimeout";
		s.value =time;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	submit : function(onSuccess, onFailure) {
		var s = {};
		s.method = "submit";
		s.value=this.data;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		this.bakdata=this.data;
		this.data={};
		
		if (onSuccess) {
			Emp.addEvent(this.modelId + "onSuccess", onSuccess);
		}
		if (onFailure) {
			Emp.addEvent(this.modelId + "onFailure", onFailure);
		}
	},
	onSuccess : function(callback) {
		Emp.addEvent(this.modelId + "onSuccess", callback);
	},
	onFailure : function(callback) {
		Emp.addEvent(this.modelId + "onFailure", callback);
	}
});

Emp.Dialog = new Emp.extend(Emp.Container, {
	/*
	 * constructionInfo : { type : 'notui', model : 'NativeDialog' },
	 */
	init : function(params) {
		Emp.Dialog.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'NativeDialog',
			'dialogType' : 'Dialog'
		};
		this.isRender = true;
		Emp.newRender(this);
	},
	setCanceledOnTouchOutside : function(param) {
		var s = {};
		s.method = "setCanceledOnTouchOutside";
		s.value = param;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setTitle : function(title) {
		var s = {};
		s.method = "setTitle";
		s.value = title;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setText : function(text) {
		var s = {};
		s.method = "setText";
		s.value = text;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setIcon : function(icon) {
		var s = {};
		s.method = "setIcon";
		s.value = icon;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setButtonTitles : function(title1, title2) {
		if (title1 != undefined) {
			var s = {};
			s.method = "setB1_text";
			s.value = title1;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
		if (title2 != undefined) {
			var s = {};
			s.method = "setB2_text";
			s.value = title2;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	show : function() {
		var s = {};
		s.method = "show";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	close : function() {
		var s = {};
		s.method = "close";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}
});
Emp.ModelDialog = new Emp.extend(Emp.Container, {
	/*
	 * constructionInfo : { type : 'notui', model : 'NativeDialog' },
	 */
	init : function(params) {
		Emp.Dialog.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'NativeDialog',
			'dialogType' : 'ModelDialog'
		};
		this.isRender = true;
		Emp.newRender(this);
	},
	setCanceledOnTouchOutside : function(param) {
		var s = {};
		s.method = "setCanceledOnTouchOutside";
		s.value = param;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setTitle : function(title) {
		var s = {};
		s.method = "setTitle";
		s.value = title;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setIcon : function(icon) {
		var s = {};
		s.method = "setIcon";
		s.value = icon;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setView : function(view) {
		
		view.setRender();
		var s = {};
		s.method = "setView";
		s.value = view;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	show : function() {
		var s = {};
		s.method = "show";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	close : function() {
		var s = {};
		s.method = "close";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}
});
Emp.CustomDialog = new Emp.extend(Emp.Container, {
	/*
	 * constructionInfo : { type : 'notui', model : 'NativeDialog' },
	 */
	init : function(params) {
		params.width=params.width||"100%";
		params.height=params.height||"100%";
		Emp.Dialog.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'NativeDialog',
			'dialogType' : 'CustomDialog'
		};
		//this.isRender = true;
		//Emp.newRender(this);
	},
	setCanceledOnTouchOutside : function(param) {
		this.content.canceledOnTouchOutside = param;
		if(this.isRender){
			var s = {};
			s.method = "setCanceledOnTouchOutside";
			s.value = param;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	getCanceledOnTouchOutside : function(){
		return this.content.canceledOnTouchOutside ==undefined?false:this.content.canceledOnTouchOutside;
	},
	setView : function(view) {
		this.content.view = view;
		//view.setRender();		//modify by:loucj bugId:44600
		if(this.isRender==true){
			var s = {};
			s.method = "setView";
			s.value = view;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	show : function() {
		//modify by liulei fix bug 44780 44782
		this.content.view.setRender();
	    Emp.newRender(this);
		var s = {};
		s.method = "show";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	close : function() {
		var s = {};
		s.method = "close";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}
});

Emp.WebView = Emp.extend(Emp.View, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeWebView' },
	 */
	init : function(params) {
		Emp.WebView.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeWebView'
		};
	},
	setUrl : function(url) {
		var tmp = url.trim();
			this.content.url = url;
			if (this.isRender) {
				var s = {};
				s.method = "setUrl";
				s.value = url;
				empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
			}
	},
	execute : function(url) {
		var tmp = url.trim();
			this.content.url = url;
			if (this.isRender) {
				var s = {};
				s.method = "execute";
				s.value = url;
				empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
			}
	},
	setLoadData : function(data) {
		this.content.loadData = data;
		if (this.isRender) {
			var s = {};
			s.method = "setLoadData";
			s.value = data;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	/*
	 * setHttpUrl:function(url){ this.content.httpUrl = url; if (this.isRender) {
	 * var s = {}; s.method ="setHttpUrl"; s.value=url;
	 * empBridge.fireModelMethod(this.modelId,util.jsonToString(s)); } },
	 * setLocalUrl:function(url){
	 * 
	 * if (this.isRender) { var s = {}; s.method ="setlocalUrl"; s.value=url;
	 * empBridge.fireModelMethod(this.modelId,util.jsonToString(s)); } },
	 */
	stop : function() {
		var s = {};
		s.method = "stop";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	refresh : function() {
		var s = {};
		s.method = "refresh";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	goback : function() {
		var s = {};
		s.method = "goBack";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	goForward : function() {
		var s = {};
		s.method = "goForward";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	onFinished : function(callback) {
		Emp.addEvent(this.modelId, "onfinish", callback);
	},
	onFailure : function(callback) {
		Emp.addEvent(this.modelId, "onfailure", callback);
	}

});

/**
 * 视频播放控件
 */
Emp.Video = Emp.extend(Emp.Panel, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeWebView' },
	 */
	init : function(params) {
		Emp.WebView.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeVideo'
		};
	},
	setUrl : function(url) {
		    var tmp = url.trim();
			this.content.url = url;
			if (this.isRender) {
				var s = {};
				s.method = "setUrl";
				s.value = url;
				empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
			}
	},
	start:function(){
		
		if (this.isRender) {
			var s = {};
			s.method = "start";
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	stop:function(){
		if (this.isRender) {
			var s = {};
			s.method = "stop";
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	pause:function(){
		if (this.isRender) {
			var s = {};
			s.method = "pause";
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	}
	});
Emp.Form = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Form.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeForm'
		};
		this.ajax = null;
		this.action = null;
	},
	setAction : function(action) {
		this.action = action;
	},
	submit : function(success, failure) {
		Emp.formKeyValue.length=0;
		Emp.page.getKeyValueByName();
		this.ajax = new Emp.Ajax();
		this.ajax.addParams(util.jsonToString(Emp.formKeyValue));
		this.ajax.setAction(this.action);
		// 更改ajax
		this.ajax.submit(success, failure);
	}
});

Emp.Page = Emp.extend(Emp.Panel, {
	// constructionInfo:{type:'baseui',model:'NativePanel'},
	init : function(params) {
		Emp.Page.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel'
		};
		this.nav = {};
	},
	goTo : function(url, params, isInTab, isDestroySelf) {
		if(util.isJson(url)){
			if(url.params){
				if(typeof(url.params)=='object'){
					url.paramIsObject=true;
				}else{
					url.paramIsObject=false;
				}
			}
			empBridge.goTo(util.jsonToString(url));
			return;
		}
		var s = {};
		if (!url) {
			return;
		}
		s.url = url;
		if (params) {
			s.params = params;
		}
		
		if (isInTab) {
			s.isInTab = isInTab;
		} else {
			s.isInTab = false;
		}
		
		if (isDestroySelf) {
			s.isDestroySelf = isDestroySelf||isInTab;
		} else {
			s.isDestroySelf = s.isDestroySelf = isDestroySelf||isInTab||false;
		}
		if(typeof(params)=='object'){
			s.paramIsObject= true;
		}else{
			s.paramIsObject=false;
		}
		
		// log(util.jsonToString(s));
		// empBridge.goTo(url,util.jsonToString(params),isInTab);
		empBridge.goTo(util.jsonToString(s));
	},
	slideGoTo : function(modelId,url) {
		Emp.SlidePageId.push(modelId);
		this.goTo(url);
	},
	goBack : function(params, url) {
		params = params || {};
		if(typeof(params.params)=="undefined"&&typeof(params.url)=="undefined"){
			var s = {};
			s.params = params;
			if(typeof(params)=='object'){
				s.paramIsObject= true;
			}else{
				s.paramIsObject=false;
			}
			s.url = url;
			empBridge.goBack(util.jsonToString(s));
			return ;
		}else if(params.params){
			if(typeof(params.params)=='object'){
				params.paramIsObject=true;
			}else{
				params.paramIsObject=false;
			}
			empBridge.goBack(util.jsonToString(params));
			return;
		}else{
			var s = {};
			s.params = params;
			if(typeof(params)=='object'){
				s.paramIsObject= true;
			}else{
				s.paramIsObject=false;
			}
			empBridge.goBack(util.jsonToString(s));
		}
	},
	render : function() {
		Emp.render();
	},
	setNav : function(nav) {
		if (!nav) {
			return;
		}
		this.nav = nav;
		Emp.page.add(nav);
	},
	hideNav : function() {
		this.nav.setDisplay("none");
	}

});

Emp.Nav = Emp.extend(Emp.Panel, {
	init : function(params) {
		Emp.Nav.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel',
			htmlType : 'Nav'			
		};
		this.content.class="emp-nav";
		this.content.layout="HBox";
		this.__left = new Emp.Button({class:params.leftClass||"emp-nav-left"
			,visibility:params.enableLeft||true});

		this.__center = new Emp.Panel({class:"emp-nav-center",overflow:"x"
		});
		this.__title=new Emp.Label({class:params.titleClass||"emp-nav-title",singleLine:"true"
		})
		this.__title.setValue(params.title||"title");
		this.__center.add(this.__title);	
		this.__right = new Emp.Button({class:params.rightClass||"emp-nav-right"
		,visibility:params.enableRight||false});	
		this.children.push(this.__left);
		this.children.push(this.__center);
		this.children.push(this.__right);
		
		this.onLeftClick=function(){Emp.page.goBack();};
		this.onRightClick=function(){};

		var navbar=this;
		this.__left.addEvent("onClick",function(){navbar.onLeftClick()})		
		this.__right.addEvent("onClick",function(){navbar.onRightClick()})
	},
	setLeft:function(className,onClick)
	{
		if(onClick!=null)this.onLeftClick=onClick;
		if(className!=""&&className!=null) this.__left.setClass(className);
	},
	setRight:function(className,onClick)
	{
	   if(onClick!=null) this.onRightClick=onClick;
	   if(className!=""&&className!=null) this.__right.setClass(className);
	},
	setCenter:function(className,obj)
	{
	if(obj!=null)
	{

		this.__center.removeAll();
		this.__center.add(obj);
		}
		if(className!=""&&className!=null) this.__center.setClass(className);
	}
	,
	setEnableRight:function(v){
		this.__right.setVisibility(v);
	},
	setEnableLeft:function(v){
		 this.__left.setVisibility(v);
	}
	,
	setTitle:function(v){
		 this.__title.setValue(v);
	},
	addEvent:function(eventName,fn)
	{this[eventName]=fn;
		}
	}
);


Emp.page = new Emp.Page({
	layout : 'VBox',
	width : Emp.ViewSize.FillParent,
	height : Emp.ViewSize.FillParent,
	hasNav : true,
	tag : 'page'
});
Emp.page.addEvent("onPressBackKeySystem", function() {
	if (Emp.events["1onPressBackKey"]) {
		// log("调用onPressBackKey");
		var s = Emp.events["1onPressBackKey"].Function();
		if (s == true) {// 如果返回true，表示不回退

		}
		if (s == false) {
			Emp.page.goBack("{}");
		}
	} else {
		Emp.page.goBack("{}");
	}
});
Emp.contextData = {
		getValue : function(key) {
			if (!key) {
				return;
			}
			var s = util.stringToJson(empBridge.getContextValue(key));
			var result;
			if(s.paramIsObject==true){
				result = util.stringToJson(s.value);
			}else{
				result = s.value;
			}
			return result;
		},
		setValue : function(key, value) {
			if (!key || !value) {
				log("数据格式不正确");
				return;
			}
			var s = {};
			if(typeof(value)=='object'){
				s.paramIsObject =true;
				s.value = util.jsonToString(value);
			}else{
				s.paramIsObject =false;
				s.value = value;
			}
			empBridge.setContextValue(key, Utils.jsonToString(s));
		},
		remove : function() {

		}
};

Emp.Base64Encrypt = Emp.extend(Emp.Component,{
	init : function(params) {
		Emp.Base64Encrypt.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.Base64Encrypt'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	codeToBase64 : function(params){
		var s = {};
		s.method = "codeToBase64";
		s.value = {
				"data" : params
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return r;
	},
	codeStringToBase64 : function(params){
		var s = {};
		s.method = "codeStringToBase64";
		s.value = {
				"data" : params
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return r;

	},
	decodeBase64String : function(params){
		var s = {};
		s.method = "decodeBase64String";
		s.value = {
				"data" : params
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return r;
	}

});

Emp.MD5Encrypt = Emp.extend(Emp.Component,{
	
	init : function(params) {
		Emp.MD5Encrypt.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.MD5Encrypt'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	MD : function(params){
		var s = {};
		s.method = "MD5";
		s.value = {
			"data" : params
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return r;
	}
	
	
});

Emp.UMSAgent = Emp.extend(Emp.Component,{
	
	init : function(params) {
		Emp.UMSAgent.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.UMSAgent'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	postEvent : function(eventID){
		var s = {};
		s.method = "postEvent";
		s.value = {
			"eventID" : eventID
		};
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	bindUser : function(userID){
		var s = {};
		s.method = "bindUser";
		s.value = {
			"userID" : userID
		};
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}
	
	
});

Emp.SHA1Encrypt = Emp.extend(Emp.Component,{
	
	init : function(params) {
		Emp.SHA1Encrypt.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.SHA1Encrypt'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	SHA1 : function(params){
		var s = {};
		s.method = "SHA1";
		s.value = {
			"data" : params
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return r;
	}
	
});

// **************************************蓝牙操作类***********************************************
Emp.Bluetooth = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Bluetooth.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.Bluetooth'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	openBluetooth : function() {
		var r = empBridge.fireModelMethod("openBluetooth");
		return ResultUtil.processBoolean(r);
	},
	
	connect : function(device) {
		
		var s = {};
		s.method = "connect";
		s.value = device;
		var r=empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	searchDevices : function() {
		var s = {};
		s.method = "searchDevices";
		s.value = "";
		var r=empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		
		return ResultUtil.processBoolean(r);
	},
	close : function() {
		var s = {};
		s.method = "close";
		s.value = "";
		var r=empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		
		return ResultUtil.processBoolean(r);
	},
	initIntentFilter : function() {
		empBridge.fireModelMethod("initIntentFilter");
	},
	sendSelectIndex : function(index) {
		var s = {};
		s.method = "sendSelectIndex";
		s.value = {
			"index" : index
		};
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},

	print : function(params){
		var s = {};
		s.method = "printData";
		s.value = {
			"data":params	
		};
		var r=empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	}
});
Emp.Bluetooth.open = function() {
	var Bluetooth = new Emp.Bluetooth();
	Bluetooth.openBluetooth();
	// Bluetooth.searchDevices();
	// Bluetooth.initIntentFilter();
	return Bluetooth;
}


// **************************************storage************************************************
/**
 * 数据库操作类
 */
Emp.Database = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Database.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.Storage'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},

	/**
	 * public 打开数据库，如果数据库不存在，则创建. 输入参数： sql:sql语句 返回值： true/false
	 */
	open : function(param) {
		var s = {};
		s.method = "openDatabase";
		s.value = {
			"dbName" : param
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);

	},

	/**
	 * public 关闭数据库 输入参数： 无 返回值： true/false
	 */
	close : function() {
		var s = {};
		s.method = "closeDatabase";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},

	/**
	 * public 打开数据库，如果数据库不存在，则创建. 输入参数： sql:sql语句 params,参数数组 返回值： result[]
	 */
	query : function(sql, params) {
		var s = {};
		s.method = "executeSql";
		params = params || [];					//modify by:loucj bugId:44677 database.query("",array)方法调用时，param传入的数据为数字时报错
		for(var i=0;i<params.length;i++){		//将params的类型转成字符串
			params[i] = params[i]+"";
		}
		s.value = {
			"sql" : sql,
			"params" : params
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	/**
	 * 异步查询
	 */
	queryAsyn:function(sql,params,successFn,failureFn){
		this.asynExecQuery(sql,params,successFn,failureFn);
	},
	/**
	 * 异步查询
	 * 兼容老接口
	 */
	asynExecQuery: function(sql,params,successFn,failureFn){
		if(successFn){
			this.addEvent("onSuccessAsynExecute",successFn)
		}
		if(failureFn){
			this.addEvent("onFailureAsynExecute",failureFn)
		}
		
		var s = {};
		s.method = "asynExecQuery";
		params = params || [];					
		for(var i=0;i<params.length;i++){		
			params[i] = params[i]+"";
		}
		s.value = {
			"sql" : sql,
			"params" : params
		};
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	/**
     * @Deprecated 使用execute
     */
	excute : function (sql,params){
		return this.execute(sql, params);
	},
	/**
	 * public 打开数据库，如果数据库不存在，则创建. 输入参数： sql:sql语句 返回值： true/false
	 */
	execute : function(sql, params) {
		var s = {};
		s.method = "executeSql";
		s.value = {
			"sql" : sql,
			"params" : params || []
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	/**
	 * 批量执行sql
	 */
	executeBatch : function(sql) {
		var s = {};
		s.method = "executeBatchSql";
		s.value = {
				"sql" : sql,
				"params" :  []
		};
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	/**
	 * 异步批量执行sql语句
	 */
	executeBatchAsyn:function(sql,successFn,failureFn){
		this.asynExecUpdateBatch(sql,successFn,failureFn);
	},
	/*兼容老接口
	 * 异步执行sql*/
	asynExecUpdateBatch : function(sql,successFn,failureFn){
		if(successFn){
			this.addEvent("onSuccessAsynExecuteBatch",successFn)
		}
		if(failureFn){
			this.addEvent("onFailureAsynExecuteBatch",failureFn)
		}
		var s = {};
		s.method = "asynExecUpdateBatch";
		s.value = {
				"sql" : sql,
				"params" :  []
		};
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}

});

/**
 * public 打开数据库，如果数据库不存在，则创建. 输入参数： dbname:数据库名称 返回值： Emp.Database
 */
Emp.Database.openDatabase = function(dbname) {
	var db = new Emp.Database();
	if (!db.open(dbname))
		return null;
	else
		return db;
}

Emp.BroadCast = Emp.extend(Emp.Component, {

	/**
	 * public 发送广播 输入参数：广播的自定义类型，广播参数
	 */
	send : function(type,arg) {
		var s = {};
		var paramIsObject = false;
		if(typeof(arg)=='object'){
			paramIsObject = true;
		}
		s = {
			"type" : type,
			"param": arg,
			"paramIsObject":paramIsObject
		};
		BridgeUtil.invokeBridgeMethod("broadcastBridge","sendBroadCast", s);

	},
	
	receive : function(type,func){
		var backId = "registReceiveBroadCastOK"+util.uuid();
		log(Emp.addEvent( backId, func));
		var s ={};
		s.backId = backId;
		s.type = type;
		BridgeUtil.invokeBridgeMethod("broadcastBridge","registReceiveBroadCast", s);
	},
	
	notification:function(title,content){
		var s = {};
		s.title = title;
		s.content = content;
		BridgeUtil.invokeBridgeMethod("broadcastBridge","notification", s);
	}


});

var Broadcast = {};
Broadcast.send = function(type,arg){
	var _broad = new Emp.BroadCast();
	_broad.send(type,arg);
}

Broadcast.receive = function(type,func){
	var _broad = new Emp.BroadCast();
	_broad.receive(type,func);
}
function notify(title,content){
	var _broad = new Emp.BroadCast();
	_broad.notification(title,content);
}

/**
 * 本地通讯录操作
 */
Emp.Contacts = Emp.extend(Emp.Component, {
	findAll : function(func) {
		var backId = "findContactsSuccess"+util.uuid();
		log(Emp.addEvent( backId, func));
		var s = {};
		s.funcId = backId;
		BridgeUtil.invokeBridgeMethod("contactsBridge","findAll", s);
	},
	asyncFindAll : function(func) {
		var backId = "findContactsSuccess"+util.uuid();
		log(Emp.addEvent( backId, func));
		var s = {};
		s.funcId = backId;
		BridgeUtil.invokeBridgeMethod("contactsBridge","asyncFindAll", s);
	},
	
	findByName:function(params,func){
		var backId = "findByNameSuccess"+util.uuid();
		log(Emp.addEvent( backId, func));
		BridgeUtil.invokeBridgeMethod("contactsBridge","findByName",{"name":params,"funcId":backId});
	},
	
	asyncFindByName:function(params,func){
		var backId = "findByNameSuccess"+util.uuid();
		log(Emp.addEvent( backId, func));
		BridgeUtil.invokeBridgeMethod("contactsBridge","asyncFindByName",{"name":params,"funcId":backId});
	},
	
	saveContact : function(params,func,func1){
		var backId = "saveContact"+util.uuid();
		log(Emp.addEvent( backId+"Success", func));
		log(Emp.addEvent( backId+"Fail", func1));
		BridgeUtil.invokeBridgeMethod("contactsBridge","saveContact", {"contact":params,"funcId":backId}); //modify by:loucj fix:回调函数不成功
	}


});

var Contacts = {};			// modify by:loucj bugId:44656 Contacts not defined
var _contacts = null;

Contacts.findAll = function(func){
	if(_contacts == null)
		_contacts = new Emp.Contacts();
	_contacts.findAll(func);
}

Contacts.asyncFindAll = function(func){
	if(_contacts == null)
		_contacts = new Emp.Contacts();
	_contacts.asyncFindAll(func);
}

Contacts.findByName = function(params,func){
	if(_contacts == null)
		_contacts = new Emp.Contacts();
	_contacts.findByName(params,func);
}

Contacts.asyncFindByName = function(params,func){
	if(_contacts == null)
		_contacts = new Emp.Contacts();
	_contacts.asyncFindByName(params,func);
}

Contacts.saveContact = function(params,func,func1){
	if(_contacts == null)
		_contacts = new Emp.Contacts();
	_contacts.saveContact(params,func,func1);
}

/**
 * 消息处理
 */
Emp.MessageService = Emp.extend(Emp.Component, {
	registerToken : function(success, failure) {
		var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		json.method = "register";
		json.value = value;
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
	},
	startPushMsg : function() {
		empBridge.startPushMsg();
	},
	stopPushMsg : function() {
		empBridge.stopPushMsg();
	},

	getMessageList : function(success, failure) {
		var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		json.value = value;
		json.method = "getNewMessageList";
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
	},
	subscribe : function(topic, success, failure) {
		var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		value.topic = topic
		json.value = value;
		json.method = "subscribe";
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
	},

	unSubscribe : function(topic, success, failure) {
		var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		value.topic = topic
		json.value = value;
		json.method = "unSubscribe";
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
	},
	unSubscribeAll : function(success, failure) {
		var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		json.value = value;
		json.method = "unSubscribeAll";
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
	},
	joinGroup: function(topic, success, failure){
		var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		value.topic = topic
		json.value = value;
		json.method = "subscribe";
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
    },
    removeFromGroup: function(topic, success, failure){
    	var id = Emp.getObjectUUId();
		if (success) {
			Emp.addEvent(String(id + "onSuccess"), success);
		}
		if (failure) {
			Emp.addEvent(String(id + "onFailure"), failure);
		}
		var json = {}
		var value = {};
		value.id = id;
		value.topic = topic
		json.value = value;
		json.method = "unSubscribe";
		empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
    },
	findMessageByType : function(type) {
		var json = {}
		var value = {};
		value.type = type;
		json.value = value;
		json.method = "queryByType";
		return util.stringToJson(empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json)));
	},
	findMessageById : function(seqId) {
		var json = {}
		var value = {};
		value.seqId = seqId;
		json.value = value;
		json.method = "queryBySeqId";
		return util.stringToJson(empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json)));
	},
	findMessage : function(type, seqId, operate) {
		var json = {}
		var value = {};
		value.type = type;
		value.seqId = seqId;
		json.value = value;
		if (operator == ">") {
			json.method = "queryByTypeUpSeqId";
		} else {
			json.method = "queryByTypeLowerSeqId";
		}
		return util.stringToJson(empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json)));
	},
	findAllMessage : function() {
		var json = {}
		json.method = "queryAllMsg";
		var result = empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json))
		if(result.length<3){
			return result;
		}else{
			return util.stringToJson(result);
		}
	},
	deleteMessage : function(seqId) {
		var json = {}
		var value = {};
		value.seqId = seqId;
		json.method = "deleteMsg";
		json.value = value;
		return util.stringToJson(empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json)));
	},
	insertMsgConfig : function(appId, msgType, url,notifyType, audio ) {
		if(!audio){
			audio="/a.wav";
		}
		var json = {};
		value = {}
		value.appId = appId;
		value.msgType = msgType;
		value.url = url;
		value.audio = audio;
		value.notifyType = notifyType;
		json.method = "insertMsgConfg"
		json.value = value;
		var temp = empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
				.jsonToString(json));
		if(temp>0){
			return true;
		}else{
			return false;
		}
	},
	deleteOneMsgConfig : function(appId, msgType) {
		var json = {};
		var value = {};
		value.appId = appId;
		value.msgType = msgType;
		json.value = value;
		json.method = "deleteOneMsgConfig"
		var temp =empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json));
		if(temp>0){
			return true;
		}else{
			return false;
		}
	},
	findAllMsgConfig : function(appId) {
		var json = {};
		var value = {};
		value.appId = appId;
		json.method = "findAllMsgConfig";
		json.value = value;
		return util.stringToJson(empBridge.fireMsgMethod(
				"com.primeton.emp.client.core.component.msg.MsgModel", util
						.jsonToString(json)));
	}

});
// **************************************SharedPreferences************************************************
/**
 * 偏好设置操作类
 */
Emp.Preferences = Emp
		.extend(
				Emp.Component,
				{
					init : function(params) {
						Emp.Database.superclass.init.call(this, params);
						this.content.constructionInfo = {
							type : 'notui',
							model : 'com.primeton.emp.client.core.nativeAbility.SharedPreferences'
						};
						this.isRender = true;
						Emp.newNativeObject(this);
					},

					/**
					 * public 打开偏好设置文件，如果偏好设置文件，则创建. 输入参数： name:偏好设置文件名称
					 * mode:打开模式 返回值： true/false
					 */
					open : function(name, mode) {
						var s = {};
						s.method = "open";
						s.value = {
							"name" : name,
							"mode" : mode || "1"
						};
						var r = empBridge.fireModelMethod(this.modelId, util
								.jsonToString(s));
						return ResultUtil.processBoolean(r);
					},

					/**
					 * public 设置偏内容 输入参数： key value 返回值： true/false
					 */
					put : function(key, value) {
						if(!value){
				            log('preference 存入失败！key为：'+key);
				            return false;
				        }
						var s = {};
						s.method = "put";
						var temp ={};
						if(typeof(value)=='object'){
							temp.paramIsObject=true;
							temp.value=util.jsonToString(value);
						}else{
							temp.paramIsObject=false;
							temp.value=value;
						}
						s.value = {
							"key" : key,
							"value" : temp
						};
						var r = empBridge.fireModelMethod(this.modelId, util
								.jsonToString(s));
						return ResultUtil.processBoolean(r);
					},
					/**
					 * public 获取偏号内容 输入参数： key value 返回值： string
					 */
					get : function(key) {
						var s = {};
						s.method = "get";
						s.value = {
							"key" : key
						};
						var r = empBridge.fireModelMethod(this.modelId, util
								.jsonToString(s));
						var temp = util.stringToJson(ResultUtil.processResult(r));
						var result =temp.value;
						if(temp.paramIsObject==true){
							result = util.stringToJson(temp.value);
						}
						return result;
					}

				});
//2016年5月3日--罗登林修改（bug号为46392）
Emp.Keychain = Emp.extend(Emp.Component,
{
	 init : function(params) {
	 Emp.Database.superclass.init.call(this, params);
	 this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.SharedPreferences'
	 };
	   this.isRender = true;
	   //Emp.newNativeObject(this);
	},

	/**
	* 
	* 安卓端没有keychain的功能，所以只实现方法名，不做具体实现
	*/
	open : function(name, mode) {
				
	},

	/**
	* 安卓端没有keychain的功能，所以只实现方法名，不做具体实现
	*/
	put : function(key, value) {
				
	},
	/**
	* 安卓端没有keychain的功能，所以只实现方法名，不做具体实现 返回值： 统一提示
	*/
	get : function(key) {	
			return "安卓端不提供此功能";
		 }

});


/**
 * public 打开偏好设置文件，如果偏好设置文件，则创建. 输入参数： name:偏好设置文件名称 mode:打开模式 返回值：
 * Emp.preferences
 */
Emp.Preferences.open = function(name, mode) {
	var preferences = new Emp.Preferences();
	if (!preferences.open(name, mode))
		return null;
	else
		return preferences;
}

// **************************************file************************************************
/**
 * 文件操作类
 * 
 */
Emp.File = Emp.extend(Emp.Object, {
	init : function(params) {
		this.filename = params.applyTo
		this.content = {};
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.core.nativeAbility.File'
		};
	},
	/**
	 * 取得文件根目录的绝对路径。
	 * 
	 * 
	 */
	getParent : function() {
		/*var pname = BridgeUtil.invokeStaticBooleanMethod(
				this.content.constructionInfo.model, "getParent", {
					"filename" : this.filename
				});*/
		var panme  = this.filename;
		var index = panme.lastIndexOf('/');
		if(index==panme.length-1){//如果文件以'/' 结尾
			var temp = panme.substring(0,index);
			pname = temp.substring(0,temp.lastIndexOf('/')+1);
		}else{
			pname = panme.substring(0,index+1);
		}
		if (pname != null)
			return new Emp.File(pname);
		else
			return null;
	},
	/**
	 * 是否是目录
	 * 
	 */
	isFolder : function() {
		return BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "isFolder", {
					"filename" : this.filename
				}) == "true";
	},
	/**
	 * 文件是否存在 判断文件或文件夹是否存在。返回true，存在；false，不存在。
	 */
	exists : function() {
		return BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "exists", {
					"filename" : this.filename
				}) == "true";
	},
	/**
	 * 返回文件大小，若为文件夹则返回0
	 * 
	 */
	length : function() {
		if(this.isFolder()==true||this.exists()==false){// modify by liulei fixed bug 44450
			return 0;
		}
		return parseInt(BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "length", {
					"filename" : this.filename
				}));
	},
	/**
	 * 删除文件/文件夹。返回true，删除文件成功；false，删除文件失败或文件不存在。
	 * 
	 */
	deleteFile : function() {
		if(this.exists()==false)
			return false;
		return BridgeUtil.invokeStaticBooleanMethod(
				this.content.constructionInfo.model, "deleteFile", {
					"filename" : this.filename
				});
	},
	/**
	 * 创建此抽象路径名指定的目录。返回true，创建文件成功；false，创建文件失败。
	 * 
	 */
	mkdir : function() {
		if(this.exists()==true)
			return false;
		return BridgeUtil.invokeStaticBooleanMethod(
				this.content.constructionInfo.model, "mkdir", {
					"filename" : this.filename
				});
	},
	/**
	 * 创建此抽象路径名指定的目录，包括所有必需但不存在的父目录。返回true（1），创建文件成功；false（0），创建文件失败。
	 * 
	 */
	mkdirs : function() {
		if(this.exists()==true)
			return false;
		return BridgeUtil.invokeStaticBooleanMethod(
				this.content.constructionInfo.model, "mkdirs", {
					"filename" : this.filename+"/"
				});
	},
	/**
	 * 当且仅当不存在具有此抽象路径名指定名称的文件时，创建一个新的空文件。返回true(1)：创建文件成功；false(0)：创建文件失败。
	 * 
	 */
	createFile : function() {
		if(this.exists()==true)
			return false;
		return BridgeUtil.invokeStaticBooleanMethod(
				this.content.constructionInfo.model, "createFile", {
					"filename" : this.filename
				});
	},
	/**
	 * 获取文件路径，绝对路径。
	 * 
	 */
	getFilePath : function() {
		return this.filename;
		/*return BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "getFilePath", {
					"filename" : this.filename
				});*/
	},
	/**
	 * 获取文件名称，绝对路径。
	 * 
	 */
	getFileName : function() {
		return BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "getFileName", {
					"filename" : this.filename
				});
	},
	/**
	 * 获取文件最近修改时间。返回值：文件最近修改时间（Date对象），若获取失败则返回null值。
	 * 
	 */
	getModifiedDate : function() {
		return BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "getModifiedDate", {
					"filename" : this.filename
				});
	},
	/**
	 * 获取文件列表
	 * 
	 */
	list : function() {
		var list = BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "list", {
					"filename" : this.filename
				});
		if (list == null)
			return null;
		for ( var i = 0; i < list.length; i++) {
			list[i] = new Emp.File(list[i]);
		}
		return list;
	},
	/**
	 * 获取文件列表
	 * 
	 */
	listFiles : function() {
		var list = BridgeUtil.invokeStaticResultMethod(
				this.content.constructionInfo.model, "listFiles", {
					"filename" : this.filename
				});
		if (list == null)
			return null;
		for ( var i = 0; i < list.length; i++) {
			list[i] = new Emp.File(list[i]);
		}
		return list;
	}
})
/**
 * 获取sd卡路径
 */
Emp.File.getSDRoot = function() {
	return BridgeUtil.invokeStaticResultMethod(
			'com.primeton.emp.client.core.nativeAbility.File', "getSDRoot", {});

}

Emp.Record = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Record.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.baseauth.Record'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
		if(params.path!=null) this.setPath(params.path);
	},

	setPath : function(path) {
		var s = {};
		s.method = "setPath";
		s.value = path;
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		// return ResultUtil.processBoolean(r);
	},
	getPath : function(){ //modify by:loucj bugId:44685
		var s = {};
		s.method = "getPath";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	setMaxTime : function(time) {
		var s = {};
		s.method = "setMaxTime";
		s.value = time;
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	getMaxTime : function() {//modify by:loucj bugId:44685
		var s = {};
		s.method = "getMaxTime";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	getRecordTime : function() {
		var s = {};
		s.method = "getRecordTime";
		//s.value = time; 			//modify by:loucj bugId:44348 getRecordTime获取不到值
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	startRecord : function() {
		var s = {};
		s.method = "startRecord";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		// return ResultUtil.processBoolean(r);
	},
	isRecord : function() {
		var s = {};
		s.method = "isRecord";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	stopRecord : function(callback) {
		Emp.addEvent(this.modelId + "onSuccess", callback);
		var s = {};
		s.method = "stopRecord";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		// return ResultUtil.processBoolean(r);
	}

});
Emp.AudioPlay = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Record.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'com.primeton.emp.client.baseauth.AudioPlay'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	start : function(url, isLooping,callback) {
		this.content.url = url;
		this.content.isLooping=isLooping;
		var s = {};
		s.method = "start";
		s.value = {
			"url" : url,
			"isLooping" : isLooping
		};
		if(callback){
			this.addEvent("onStop",callback);
		}
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	seekTo : function(seconds) {
		var s = {};
		s.method = "seekTo";
		s.value = seconds;
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	pause : function() {
		var s = {};
		s.method = "pause";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	resume : function() {
		if(this.content.url){
			return this.start(this.content.url, this.content.isLooping);
		}else{
			return false;
		}
	},
	stop : function() {
		var s = {};
		s.method = "stop";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	getDuration : function() {
		var s = {};
		s.method = "getDuration";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	getStatus : function() {
		var s = {};
		s.method = "getState";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	getCurrentPosition : function() {
		var s = {};
		s.method = "getCurrentPosition";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	isLooping : function() {
		var s = {};
		s.method = "isLooping";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processBoolean(r);
	},
	setVolume : function(volume) {
		var s = {};
		s.method = "setVolume";
		s.value = volume;
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	getVolume : function() {
		var s = {};
		s.method = "getVolume";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	volumeUp : function() {
		var s = {};
		s.method = "volumeUp";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	},
	volumeDown : function() {
		var s = {};
		s.method = "volumeDown";
		var r = empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		return ResultUtil.processResult(r);
	}

});
Emp.Email = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Email.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui',
			model : 'NativeEmail'
		};
		this.isRender = true;
		Emp.newNativeObject(this);
	},
	setTo : function(to) {
		var s = {};
		s.method = "setTo";
		s.value = to;
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	setCc : function(cc) {
		if (cc) {
			var s = {};
			s.method = "setCc";
			s.value = cc;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setBcc : function(bcc) {
		if (bcc) {
			var s = {};
			s.method = "setBcc";
			s.value = bcc;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setSubject : function(subject) {
		if (subject) {
			var s = {};
			s.method = "setSubject";
			s.value = subject;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setBody : function(body) {
		if (body) {
			var s = {};
			s.method = "setBody";
			s.value = body;
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	show : function() {
		var s = {};
		s.method = "show";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}

});
// **************************************FileUtil************************************************
/**
 * 文件工具类
 */
Emp.FileUtil = {
	// 输入路径，选择指定文件打开
	openFile : function(filePath) {
		BridgeUtil.invokeBridgeMethod("empFileBridge", "openFile", {
			"filePath" : filePath
		});
	},
	// 删除指定路径文件夹。返回值：删除文件夹成功返回true，失败返回false。参数：dir，需要删除文件夹路径。
	deleteFile : function(filePath) {
		return BridgeUtil.invokeBridgeBooleanMethod("empFileBridge",
				"deleteFile", {
					"filePath" : filePath
				});
	},
	// 读取指定路径文件。只能读取字符串类型，不支持对二进制文件读取
	readFile : function(filePath) {
		return BridgeUtil.invokeBridgeResultMethod("empFileBridge", "readFile",
				{
					"filePath" : filePath
				});
	},
	// 保存内容至指定路径文件。只能写入字符串类型，不支持对二进制文件写入
	writeFile : function(filePath, content, mode) {
		return BridgeUtil.invokeBridgeBooleanMethod("empFileBridge",
				"writeFile", {
					"filePath" : filePath,
					"content" : content,
					"mode" : mode
				});
	},
	// 文件拷贝，srcFile：源文件，destFile:目标文件
	copyFile : function(srcFile, destFile) {
		return BridgeUtil.invokeBridgeBooleanMethod("empFileBridge",
				"copyFile", {
					"srcFile" : srcFile,
					"destFile" : destFile
				});
	},
	copyFileFromAssets : function(srcFile, destFile){
		
		return BridgeUtil.invokeBridgeBooleanMethod("empFileBridge","copyFileFromAssets",{
			"srcFile" : srcFile,
			"destFile" : destFile
		});
	}
}
// **************************************Animal************************************************
/*
 * Emp.Animation .RESTART = 1; Emp.Animation.REVERSE = 2;
 */
Emp.Animation = Emp.extend(Emp.Component, {
	init : function(params) {
		Emp.Animation.superclass.init.call(this, params);
	},
	setDuration : function(duration) {
		this.content.duration = duration;
	},
	setRepeatCount : function(mvalue) {
		this.content.repeatCount = mvalue;
	},
	setRepeatMode : function(mvalue) {
		// Emp.Animation.RESTART = 1;
		// Emp.Animation.REVERSE = 2;
		this.content.repeatMode = mvalue;
	},
	setInterpolater : function(type) {
		this.content.interpolator = type;
	}

});
Emp.Animation.RESTART = 1;
Emp.Animation.REVERSE = 2;
Emp.Animation.EaseInOut = 0;
Emp.Animation.EaseIn = 1;
Emp.Animation.EaseOut = 2;
Emp.Animation.Linear = 3;
Emp.TranslateAnimation = Emp.extend(Emp.Animation, {
	init : function(params) {
		Emp.TranslateAnimation.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui'
		};
		this.content.animalType = "translate";
	},
	setFromX : function(mvalue) {
		this.content.fromX = mvalue;
	},
	setFromY : function(mvalue) {
		this.content.fromY = mvalue;
	},
	setToX : function(mvalue) {
		this.content.toX = mvalue;
	},
	setToY : function(mvalue) {
		this.content.toY = mvalue;
	}
});
Emp.AlphaAnimation = Emp.extend(Emp.Animation, {
	init : function(params) {
		Emp.AlphaAnimation.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui'
		};
		this.content.animalType = "alpha";
	},
	setFromAlpha : function(mvalue) {
		this.content.fromAlpha = mvalue;
	},
	setToAlpha : function(mvalue) {
		this.content.toAlpha = mvalue;
	}
});
Emp.ScaleAnimation = Emp.extend(Emp.TranslateAnimation, {
	// (fromX, toX, fromY, toY, pivotX, pivotY
	init : function(params) {
		Emp.ScaleAnimation.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui'
		};
		this.content.animalType = "scale";
	},
	setPivotX : function(mvalue) {
		this.content.pivotX = mvalue;
	},
	getPivotX: function(){
		return this.content.pivotX;
	},
	setPivotY : function(mvalue) {
		this.content.pivotY = mvalue;
	},
	getPivotY: function(){
		return this.content.pivotY;
	},
});
Emp.RotateAnimation = Emp.extend(Emp.Animation, {
	// animal = new RotateAnimation(fromDegrees, toDegrees, pivotX, pivotY);
	init : function(params) {
		Emp.RotateAnimation.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'notui'
		};
		this.content.animalType = "rotate";
	},
	setFromDegrees : function(mvalue) {
		this.content.fromDegrees = mvalue;
	},
	setToDegrees : function(mvalue) {
		this.content.toDegrees = mvalue;
	},
	setPivotX : function(mvalue) {
		this.content.pivotX = mvalue;
	},
	setToPivotY : function(mvalue) {
		this.content.pivotY = mvalue;
	}
});

Emp.Portal = {};
Emp.Portal.getClientConfig = function() {
	try {
		return empBridge.getClientConfig().evalJSON();
	} catch (e) {
		log("javascript error, getClientConfig:" + e.message);
	}
}

Emp.Portal.saveClientConfig = function(json) {
	try {
		empBridge.saveClientConfig(util.jsonToString(json));
	} catch (e) {
		log("javascript error, saveClientConfig:" + e.message);
	}
}
Emp.Portal.setCurrentSkinId = function(skinId){
	try {
		empBridge.setCurrentSkinId(skinId);
	} catch (e) {
		log("javascript error, setCurrentSkinId:" + e.message);
	}
}
Emp.Portal.getCurrentSkinId = function(){
	return Emp.Portal.getClientConfig().theme;
}
Emp.Portal.getClientVersion = function(){
	var json;
	try {
		json = empBridge.getClientConfig().evalJSON();
		return json.clientversion;
	} catch (e) {
		log("javascript error, getClientConfig:" + e.message);
	}
}
Emp.Portal.getAllApps=Emp.getAllApps;
Emp.Portal.setCurrentAppId=Emp.setCurrentAppId;
Emp.Portal.getCurrentAppId=Emp.getCurrentAppId;

/**
 * 是否安装了应用
 */

Emp.Portal.isInstalledApp=function(packageName){
	
	var b=empBridge.isInstalledApp(packageName)
	if(b=="true") return true;
	else
		return false;
	
}

Emp.Portal.getCurrentAppConfig = function(){
	var json;
	try {
		json = empBridge.getCurrentAppConfig().evalJSON();
		return json;
	} catch (e) {
		log("javascript error, getCurrentAppConfig:" + e.message);
	}
}
/**
 * 应用安装
 * @param srcFile 安装原文件
 */
Emp.Portal.install = function(srcFile){
    return new Emp.Init().install(srcFile);
}
/**
 * 应用卸载
 * @param appId 应用Id
 */
Emp.Portal.uninstall = function(appId){
    return new Emp.Init().uninstall(appId);
}
/**
 * 检查是否有应用更新
 * successFn 
 * 			参数 state true 有更新  false无更新
 *          参数 result Array 更新列表 
 *
 */
Emp.Portal.hasUpdatableApp = function(successFn,failureFn){
    return new Emp.Init().hasUpdatableApp(successFn,failureFn);
}
/**
 * 应用更新
 */
Emp.Portal.appUpdate = function(successFn,failureFn){
    return new Emp.Init().appUpdate(successFn,failureFn);
}
/**
 * 检查是否有客户端更新
 * successFn 
 * 			参数 state true 有更新  false无更新
 *          参数 result Array 更新列表 
 *
 */
Emp.Portal.hasUpdatableClient = function(successFn,failureFn){
    return new Emp.Init().hasUpdatableClient(successFn,failureFn);
}

/**
 * 滑动控件
 */

Emp.SlidePage = Emp.extend(Emp.Container, {
	init : function(params) {
		Emp.SlidePage.superclass.init.call(this, params);
		if(this.content.width==undefined)
			this.content.width="-1";
		if(this.content.height==undefined)
			this.content.height="-1"
		log('slide'+this.content.height);
		this.content.pages = [];
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeViewPager'
		};
		if (this.content.urls != null && this.content.urls != "") {
			for ( var i = 0; i < this.content.urls.length; i++) {
				this.addUrl(this.content.urls[i].url);
			}
		};
		this.addEvent("onLoadPage",function(index,url){
			this.loadPage(index,url)
			}
		)
	},
	add : function(arg0) {
		if (!arg0) {
			log("slidepage", "addPage 未传参数!");
		}
		arg0.setRender();
		this.content.pages[this.content.pages.length] = arg0;
		this.fireMethod("add", arg0);
	},
	addUrl : function(url,index) {
		if (!url) {
			log("slidepage", "addPageUrl 未传url!");
		}
		if(index){
			this.content.pages.splice(index-1,0, {"slidePageUrl":url});
		}else{
			this.content.pages[this.content.pages.length] = {"slidePageUrl":url};
		}
		this.fireMethod("add", {"slidePageUrl":url});
		/*var temp = Emp.page;
		Emp.loadFile(url);
		var page = Emp.page;
		Emp.page = temp;
		this.content.pages[this.content.pages.length] = page;
		this.fireMethod("add", page);*/
	},		
	loadPage:function(index,url)
	{
		 if (!url) {
			log("slidepage", "addPageUrl 未传url!");
		} 
		 log('loadPage')
		var temp = Emp.page;
		this.loadFile(url);
		var page = Emp.page;
		Emp.page = temp;
		this.fireMethod("addPage", {"index":index,"page":page});
		Emp.SlidePageIdOnMsgReceive.push(page.content.modelId+","+index);//存储在slidepage中 msg回调
		Emp.callback(page.modelId+"onLoad");
	},
	loadFile:function(url){
		this.isRender=true;
		this.fireMethod("loadFile", {"url":url});
	},	 
	remove : function(child) {
		if (!child) {
			log("slidePage", "删除child,未传参数!")
			return;
		}
		if(child>this.content.pages.length-1){
			log("slidePage", "传入下标不正确！")
			return;
		}
		/**var index;
		if (typeof (child) === 'number') { // 参数为数组下标
			index = child;
			child = this.content.pages[index];
		} else if (typeof (child) === 'object') { // 参数为UI对象
			index = this.content.pages.indexOf(child);
		}*/
		//modify by liulei  更改仅支持下标删除子
		this.content.pages.splice(child, 0);
		this.fireMethod("remove", child);
	},
	removeAll : function() {
		this.content.pages = [];
		if (this.isRender) {
			var s = {};
			s.method = "removeAll";
			empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
		}
	},
	setPages : function(arg0) {
		if (!arg0) {
			log("slidepage", "setpages 出错!");
			return;
		}
		this.content.pages = arg0;
		this.fireMethod("setPages", arg0);
	},
	setEnableLoop : function(enableLoop) {
		this.content['enableLoop'] = enableLoop;
		this.fireMethod("setEnableLoop", this.content['enableLoop']);
	},
	getEnableLoop : function() {
		return this.content['enableLoop'] = enableLoop;
	},
	setEnableScroll : function(enableScroll) {
		this.content['enableScroll'] = enableScroll;
		this.fireMethod("setEnableScroll", this.content['enableScroll']);
	},
	getEnableScroll : function() {
		return this.content['enableScroll']; 
	},
	setTipVisible : function(visible) {
		this.content['tipVisible'] = visible;
		this.fireMethod("setTipVisible", this.content['tipVisible']);
	},
	getTipVisible : function() {
		return this.content['tipVisible'];
	},
	setSelectedIndex : function(index) {
		this.content['index'] = index;
		this.fireMethod("setSelectedIndex", this.content['index']);
	},
	getSelectedIndex : function() {
		if(this.isRender==false)
			return this.content['index'];
		else
			return this.fireMethod("getSelectedIndex");
	},
	setTipImage : function(img) {
		this.content['tipImage'] = img;
		this.fireMethod("setTipImage", this.content['tipImage']);
	},
	setTipSelectedImage : function(img) {
		this.content['tipSelectedImage'] = img;
		this.fireMethod("setTipSelectedImage",
						this.content['tipSelectedImage']);
	},	 
	//新增设置tipImgeWidth   linyan 联通 2016-06-23
    setTipImageWidth:function(tipWidth){
        this.content['tipWidth'] = tipWidth;
        this.fireMethod( 'setTipImageWidth', this.content['tipWidth']);
       },
        //新增设置tipImgeWidth   linyan 联通 2016-06-23
       setTipImageHeight:function(tipHeight){
        this.content['tipHeight'] = tipHeight;
        this.fireMethod( 'setTipImageHeight', this.content['tipHeight']);
        }

});

Emp.SideMenu = Emp.extend(Emp.Container, {
	init : function(params) {
		Emp.SideMenu.superclass.init.call(this, params);
		this.content.pages = [];
		this.content.leftArr = [];
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeSideMenu'
		};
		
	},
    addMainDiv: function(arg0) {
    	if (!arg0) {
			log("slidepage", "addPage 未传参数!");
		}
		 arg0.setRender();
		this.content.pages[this.content.pages.length] = arg0;
		this.fireMethod("addMainDiv", arg0);
		},
	addLeftDiv: function(arg0) {
    	if (!arg0) {
			log("slidepage", "addPage 未传参数!");
		}
		 arg0.setRender();
		this.content.leftArr[this.content.leftArr.length] = arg0;
		this.fireMethod("addLeftDiv", arg0);
		},
    showLeftDiv: function(){
		this.fireMethod("showLeftDiv");
		},
    hideLeftDiv: function(){
		this.fireMethod("hideLeftDiv");
		},
	setScale:function(json){
		this.content.isScale = json;
		this.fireMethod("setScale",json);
	}

});

Emp.Map = Emp.extend(Emp.View, {
	
	init : function(params) {
	Emp.Map.superclass.init.call(this, params);
	this.content.constructionInfo = {
		type : 'baseui',
		model : 'NativeMap'
	};
},
	/**
	 * 设置地图中心点
	 */
	setCenter:function(center)
	{
		this.content.center = center;
		this.fireMethod("setCenter", center);	
	},
	
	/**
	 * 设置地图比率
	 */
	setZoom:function(zoom)
	{
		this.content.zoom = zoom;
		this.fireMethod("setZoom", zoom);	
	},
	/**
	 * 设置地图交通状态图
	 */
	setTraffic:function(traffic)
	{
		this.content.traffic = traffic;
		this.fireMethod("setTraffic", traffic);	
	},
	//2016年5月9日--林艳修改（为了map需要放出statellite、traffic属性的get方法，bugId 46428 ）
	getTraffic:function(){
		return this.content.traffic;
	},
	/**
	 * 设置地图交通状态图
	 */
	setSatellite:function(satellite)		//modify by:loucj bugId:44410 map控件没有setStatellite方法（此处方法名拼写错误导致）
	{
		this.content.satellite = satellite;
		this.fireMethod("setSatellite", satellite);	
	},
	//2016年5月9日--林艳修改（为了map需要放出statellite、traffic属性的get方法,bugId 46428）
	getSatellite:function(){
		return 	this.content.satellite;	
	},
	setMarker:function(pos,icon)
	{
		//this.content.pos = pos;		
		this.fireMethod("setMarker", {"pos":pos,"icon":icon||""});	
	},
	/**
     * 设置地图标记（传进来的为中文地址）（bugId为46365--罗登林2016年4月27日添加）
     */
	setMarkWithAddress:function(pos,icon)
	{
		this.fireMethod("setMarkWithAddress", {"pos":pos,"icon":icon||""});
	},
	setPolylineArray:function(json)
	{
		this.content.polylineArray = json;
		this.fireMethod("setPolylineArray", json);	
	},
	setShowsUserLocation:function(showsUserLocation)
	{
		this.content.showsUserLocation = showsUserLocation;
		this.fireMethod("setShowsUserLocation", showsUserLocation);
	},
	setOriginPointAndDestination:function(json,successCallBack)
	{
		this.content.pointArray = json;
		this.addEvent("onSearchSuccess",successCallBack);
		this.fireMethod("setOriginPointAndDestination", json);
	}
});

var DEFAULT_ITEM_HEIGHT = 50;
var DEFAULT_ITEM_TEXT_HEIGHT = 20;

Emp.Tab = Emp.extend(Emp.Panel, {
	init: function(params) {
		if(!params.width) params.width = Emp.ViewSize.FillParent;
		if(!params.height) params.height = Emp.ViewSize.FillParent;
		if(!params.position) params.position = 'bottom';
		Emp.Tab.superclass.init.call(this, params);
		//this.wrapContainer = this; // 最外层容器，包含两个元素：SlidePage和TabBar
		this.setLayout('VBox');
		this.setPosition(params.position);
		//util.bindDelegateFunctions(this, this.wrapContainer); // 把所有对Tab的UI操作（如设置高、宽）的方法绑定到最外层容器
	    if(params.selectedIndex==undefined) this.selectedIndex = 0; 
	  		  else
	    this.selectedIndex=params.selectedIndex;
		if(params.background==null) this.background = "#FFFFFF";
		if(params.selectedBackground==null) this.selectedBackground = "#EFEFEF";
		
		this.slidePage = this.createSlidePage(); // Tab视图，采用SlidePage控件实现，以支持滑动
		this.tabBar = this.createTabBar();
		if(params.position=='bottom'){
			this.add(this.slidePage);
			this.add(this.tabBar);
		}else{
			this.add(this.tabBar);
		    this.add(this.slidePage);
		}
	    
		this.tabItems = []; // Tab项，元素为TabItem对象
		this.onAddEvent=this.addEvent;
		this.addEvent=function(n,f){
		if(n=="onChange"){
			this.slidePage.addEvent(n,f);
		}
		else
		if(n=="onItemCreate"){
		   this.onItemCreate=f;
		   	}
		else
		   this.onAddEvent(n, f);
		}
        //2016年4月19日--罗登林修改（为了解决在标签属性中设置enableScroll属性不生效的问题）
        if(params.enableScroll == "false")
        {
            this.slidePage.setEnableScroll(false);
        }
        else if(params.enableScroll == "true")
        {
            this.slidePage.setEnableScroll(true);
        }

 	},
 	getItemHeight:function(){
 	 	return this.tabBar.getHeight();
 	 	},
    //fix bug 44365 by ton
   /* getWidth:function()
    {
    	return this.wrapContainer.getWidth();
    } ,
    getHeight:function()
    {
    	return this.wrapContainer.getHeight();
    } ,    */

	setItemHeight: function(itemHeight) {
		this.itemHeight.setHeight(itemHeight) ;
//		this.tabBar.height = itemHeight;    //modify by:loucj   bugId:44368
	},
	setItemSpacing: function(itemSpacing) {
		this.itemSpacing = itemSpacing;
		
	},
	setPosition: function(position) {
		this.position = position;
	},
	setBackground: function(background) {
		this.background = background;
		util.setPanelBackground(this.tabBar, background);
	},
	setSelectedBackground: function(selectedBackground) {
		this.selectedBackground = selectedBackground;
	},
	setSelectedBackgroundImage: function(selectedBackgroundImage) {
		this.selectedBackgroundImage = selectedBackgroundImage;
	},
	setSelectedIndex: function(selectedIndex) {
		this.slidePage.setSelectedIndex(selectedIndex);
        this.selectedIndex = selectedIndex;
		this.refreshItems();
	},
	getSelectedIndex: function() {
		return this.slidePage.getSelectedIndex();
	},
	setItems: function(tabItems) {
		this.tabItems = tabItems;
	},
	addItem: function(tabItem) {
        this.tabItems.push(tabItem); 
       // if(this.isRender){                                  //modify by:loucj bugId:44370 tab页render前后增加item不生效的问题
          //  tabItem.parentTab = this;
            tabItem.build(this.tabItems.length-1,this);          //构造item项
            this.tabItemsHBox.add(tabItem.getItemView());   //把item放入tabitem的div中
            if (tabItem.getView()) {
                this.slidePage.add(tabItem.getView());      //设置slidepage
            } else if(tabItem.getUrl()) {
                this.slidePage.addUrl(tabItem.getUrl());
            }
            //alert(this.selectedIndex)
            if(this.tabItems.length-1+""!=this.selectedIndex+""){
              util.setPanelBackground(tabItem.getItemView(), this.background);
              //util.setPanelBackground(tabItem.getItemView(), tabItem.getIcon());
            }else{
               util.setPanelBackground(tabItem.getItemView(), this.selectedBackground);
               //util.setPanelBackground(tabItem.getItemView(), this.selectedBackgroundImage);
               tabItem.setTabItemIcon(tabItem.getSelectedIcon()==null?tabItem.getIcon():tabItem.getSelectedIcon());
               tabItem.setTabItemTextColor(tabItem.getTextSelectedColor()==null?tabItem.getTextColor():tabItem.getTextSelectedColor());
            }
	},
	getItem: function(itemIndex) {
		return this.tabItems[itemIndex];
	},
	getItems: function() {
		return this.tabItems;
	},
	getScrollToolColor: function(scrollToolColor) {
		this.scrollToolColor = scrollToolColor;
	},
	setScrollToolHeight: function(scrollToolHeight) {
		this.scrollToolHeight = scrollToolHeight;
	},
	setEnableScroll: function(enableScroll) {
		this.slidePage.setEnableScroll(enableScroll);
	},
	getEnableScroll: function() {
		return this.slidePage.getEnableScroll();
	},
	createSlidePage: function() {
		  //fix bug 44365 by ton
		var slidePage = new Emp.SlidePage({tipVisible:false,height:'100%',width:'100%',selectedIndex:this.selectedIndex});
		var parentTab = this;
		slidePage.addEvent('onChange', function(oldIndex, newIndex) {
	        parentTab.selectedIndex = newIndex;
			parentTab.refreshItems();
		});
		return slidePage;
	},
	// 构造Tab栏
	createTabBar: function() {
		// Tab栏：包含TabItems和滑动小工具
		var tabBar = new Emp.Panel({layout:'VBox',height:this.itemHeight||DEFAULT_ITEM_HEIGHT,width:'100%'});		
		// 构造tab项的视图
        this.tabItemsHBox = new Emp.Panel({layout:'HBox',height:'100%',width:'100%'});
		tabBar.add(this.tabItemsHBox);
		return tabBar;
	},
	refreshItems: function() {
		var tabItems = this.getItems();
		// 恢复其他Tab的Background
		for(var i = 0; i < tabItems.length; i++) {
                     if(this.selectedIndex !== i) {
				tabItems[i].setBackground(this.background);
				tabItems[i].setTabItemIcon(tabItems[i].getIcon());// 恢复其他Tab的Icon
				tabItems[i].setTabItemTextColor(tabItems[i].getTextColor());// 恢复其他Tab的TextColor
				//恢复其他tab的TipBackgroundImage
                tabItems[i].setTabItemTipBackgroundImage(tabItems[i].getTipBackgroundImage());
                //恢复其他tab的TipTextColor
                tabItems[i].setTabItemTipTextColor(tabItems[i].getTipTextColor());
			}
		}
		// 设置当前Tab的Background
		tabItems[this.selectedIndex].setBackground(this.selectedBackground);
		//tabItems[this.selectedIndex].setBackground(this.selectedBackgroundImage);
		// 设置当前Tab的icon
		if(tabItems[this.selectedIndex].getSelectedIcon()!=null) 
			tabItems[this.selectedIndex].setTabItemIcon(tabItems[this.selectedIndex].getSelectedIcon());
		else 
			tabItems[this.selectedIndex].setTabItemIcon(tabItems[this.selectedIndex].getIcon());
		// 设置当前Tab的TextColor
		if(tabItems[this.selectedIndex].getTextSelectedColor()!=null) 
			tabItems[this.selectedIndex].setTabItemTextColor(tabItems[this.selectedIndex].getTextSelectedColor());
		else 
			tabItems[this.selectedIndex].setTabItemTextColor(tabItems[this.selectedIndex].getTextColor());
        if(tabItems[this.selectedIndex].getTipSelectedBackgroundImage()!=null)
            tabItems[this.selectedIndex].setTabItemTipBackgroundImage(tabItems[this.selectedIndex].getTipSelectedBackgroundImage());
        else
            tabItems[this.selectedIndex].setTabItemTipBackgroundImage(tabItems[this.selectedIndex].getTipBackgroundImage());
                    
       if(tabItems[this.selectedIndex].getTipTextSelectedColor()!=null)
           tabItems[this.selectedIndex].setTabItemTipTextColor(tabItems[this.selectedIndex].getTipTextSelectedColor());
       else
           tabItems[this.selectedIndex].setTabItemTipTextColor(tabItems[this.selectedIndex].getTipTextColor());

	}
});

Emp.TabItem = Emp.extend(Emp.Object, {
	init: function(params) {

	},
	
	setIcon: function(icon) {
		this.icon = icon;
	},
	getIcon: function() {
		return this.icon;
	},
	setText: function(text) {
		this.text = text;
	},
	getText: function() {
		return this.text;
	},
	setTipText: function(tipText) {
		this.tipText = tipText;
		if(this.tipTextLabel != null)
            this.tipTextLabel.setValue(tipText);
	},
	getTipText: function() {
		return this.tipText;
	},
    setTipBackgroundImage:function(backgroundImage){
        this.tipBackgroundImage = backgroundImage;
    },
    getTipBackgroundImage:function(){
        return this.tipBackgroundImage;
    },
    setTipSelectedBackgroundImage:function(tipSelectedBackgroundImage)
    {
        this.tipSelectedBackgroundImage = tipBackgroundImage;
    },
    getTipSelectedBackgroundImage:function(){
        return this.tipSelectedBackgroundImage;
    },
	setTextColor: function(textColor) {
		this.textColor = textColor;
	},
    setTextSize:function(textSize){
        this.textSize = textSize;
    },
	getTextColor: function() {
		return this.textColor;
	},
	setTextSelectedColor: function(textSelectedColor) {
		this.textSelectedColor = textSelectedColor;
	},
	getTextSelectedColor: function() {
		return this.textSelectedColor;
	},
	setSelectedIcon: function(selectedIcon) {
		this.selectedIcon = selectedIcon;
	},
	getSelectedIcon: function() {
		return this.selectedIcon;
	},
    setTipTextColor:function(tipTextColor){
        this.tipTextColor = tipTextColor;
    },
    setTipTextSize: function(tipTextSize){
        this.tipTextSize = tipTextSize;
    },
    getTipTextColor:function(){
        return this.tipTextColor;
    },
    setTipTextSelectedColor:function(tipTextSelectedColor){
        this.tipTextSelectedColor = tipTextSelectedColor;
    },
    getTipTextSelectedColor:function(){
        return this.tipTextSelectedColor;
    },
    setTipWidth:function(tipWidth){
        this.tipWidth = tipWidth;
    },
    setTipHeight:function(tipHeight){
        this.tipHeight = tipHeight;
    },
    setTipLeft:function(tipLeft){
    	this.tipLeft = tipLeft;
    },
    setTipTop:function(tipTop){
    	this.tipTop = tipTop;
    },
    getTipTextColor:function(){
        return this.tipTextColor;
    },
	setView: function(view) {
		this.view = view;
	},
	getView: function() {
		return this.view;
	},
	setItemView: function(itemView) {
		this.itemView = itemView;
	},
	getItemView: function() {
		return this.itemView;
	},
	setUrl: function(url) {
		this.url = url;
	},
	getUrl: function() {
		return this.url;
	},
//私有方法//
	setBackground: function(background) {
		util.setPanelBackground(this.itemView, background);
	},
	setIconView: function(iconView) {
		this.iconView = iconView;
	},
	getIconView: function() {
		return this.iconView;
	},
	setLabelView: function(labelView) {
		this.labelView = labelView;
	},
	getLabelView: function() {
		return this.labelView;
	},
	setTabItemIcon: function(icon){
		if(this.iconView!=null) this.iconView.setSrc(icon);
	},
	setTabItemTextColor: function(color){
		if(this.labelView!=null) this.labelView.setColor(color);
	},
    setTabItemTipBackgroundImage : function(Image){
        if(this.tabItemTipDiv != null)
           this.tabItemTipDiv.setBackgroundImage(Image);
    },
    setTabItemTipTextColor :function(color){
        if(this.tipTextLabel != null)
           this.tipTextLabel.setColor(color);
    },
    hideTip:function(){
        if(this.tabItemTipDiv != null)
            this.tabItemTipDiv.setDisplay(false);
    },
    showTip:function(){
        if(this.tabItemTipDiv != null)
            this.tabItemTipDiv.setDisplay(true);
    },
    build: function(tabIndex,p) {

		if(p.onItemCreate==null) { // 为空说明没有使用自定义TabItem视图，则按照缺省方式构造
			this.itemView=this.buildDefaultTabItemView(p,tabIndex,this.icon,this.text);
		}
		else
		{
		 	this.itemView=p.onItemCreate(p,tabIndex,this.icon,this.text)
		 	if(this.itemView==null)
		 	{
		 		this.itemView=this.buildDefaultTabItemView(p,tabIndex,this.icon,this.text);
		 	}
		}		
		// 点击TabItem时，切换到对应的视图
		var parentTab = p; 
	
		this.itemView.addEvent('onClick', function() {
			parentTab.setSelectedIndex(tabIndex);
		}); 
	}, 
	// 构造缺省的TabItem视图。上面为“图标”、下面为“文字”
	buildDefaultTabItemView: function(tab,tabIndex,icon,text) {
		var tabItemView = new Emp.Panel({layout:'VBox',height:'100%',width:'100%',hAlign:'center',vAlign:'middle'});
        var tabItemTipView = new Emp.Panel({layout:'HBox',height:'100%',width:'100%',hAlign:'center',vAlign:'middle'});
		var tabItemImage = new Emp.Image({src:icon, width:30, height:30});
        var tabItemTipDiv = new Emp.Panel({layout:'HBox',hAlign:'center',vAlign:'middle',position:"relative",left:this.tipLeft,top:this.tipTop,height:this.tipHeight||"15",width:this.tipWidth||"15",backgroundImage:this.tipBackgroundImage});
        var tabItemTipLabel = new Emp.Label({value:this.tipText,fontSize:this.tipTextSize||9,color:this.tipTextColor||"#000000"});
		var tabItemLabel = new Emp.Label({value:text,height:DEFAULT_ITEM_TEXT_HEIGHT,color:this.textColor||"#000000",fontSize:this.textSize});
		if(icon) {
			tabItemView.add(tabItemImage);
			this.iconView = tabItemImage;
		}
		if(text) {
            tabItemView.add(tabItemLabel);
            this.labelView = tabItemLabel;
		}
        if(this.tipText)
        {
        	tabItemView.add(tabItemTipDiv);
            tabItemTipDiv.add(tabItemTipLabel);
            this.tabItemTipDiv = tabItemTipDiv;
            this.tipTextLabel = tabItemTipLabel;
        }
		return tabItemView;
	}
});

Emp.ExtDialog = new Emp.extend(Emp.CustomDialog, {
	/*
	 * constructionInfo : { type : 'notui', model : 'NativeDialog' },
	 */
	init : function(params) {
		Emp.ExtDialog.superclass.init.call(this, {});
		var dialog = this;
		var p = {

			"layout" : "VBox",
			"class" : "emp-confirm-container"
		};


		this.onOk=params.onOk||function(){};
		this.onCancel=params.onCancel||function(){};
		
		if (params.height)
			p.height = params.height;
		var confirm_container = new Emp.Panel(p);

		var confirm_head = new Emp.Panel({

			"class" : "emp-confirm-header"
		});

		var _input_27547059 = new Emp.Label({

			"value" : params.title || "提示框"
		});
		confirm_head.add(_input_27547059);
		confirm_container.add(confirm_head);
		var confirm_content_ctn = new Emp.Panel({

			"class" : "emp-confirm-content-ctn",
			"overflow":"y"
		});
		var content = new Emp.Label({

			"vAlign" : "center",
			"width" : "280",
			"value" : params.text || "",
			"singleLine" : "false"
		});
		confirm_content_ctn.add(content);
		confirm_container.add(confirm_content_ctn);
		var confirm_button = new Emp.Panel({
			"class" : "emp-confirm-bottom"
		});
		var confirm_ok = new Emp.Button({
			"width" : "100",
			"value" : params.okText||"确定"
		});
		confirm_button.add(confirm_ok);
		if(params.isShowCancel){
		var confirm_cancel = new Emp.Button({
			"width" : "100",
			"value" : params.cancelText||"取消"
		});
		confirm_cancel.addEvent("onClick", function() {
			dialog.close();

			dialog.onCancel();
		})	
				
		confirm_button.add(confirm_cancel);
		}		
		confirm_ok.addEvent('onClick', function() {
			dialog.close();
			dialog.onOk();
		});				
		confirm_container.add(confirm_button);
		this.setView(confirm_container);
	}
});

/**
 * alert
 * @param msg
 */
function alert(msg)
{
	var d = new Emp.ExtDialog({"text":msg+""});
	d.show();
}
/**
 * confirm
 * @param msg
 * @param onOk
 * @param onCancel
 */
function confirm(msg,onOk,onCancel)
{
	var d = new Emp.ExtDialog({"text":msg,"onOk":onOk,"onCancel":onCancel,"isShowCancel":true});
	d.show();
}

Emp.Search_Bt = Emp.extend(Emp.Panel, {
	init : function(params) {
		Emp.Search_Bt.superclass.init.call(this, params);
		this.value=params.value;
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativePanel'
		};
		this.content.class = "emp-search-bt";
		this.__selectImg = new Emp.Panel({
			class : "emp-search-bt-press",
			position:"relative",
			top:7,
			left:0
		});
		this.__unSelectImg = new Emp.Panel({
			class : "emp-search-bt-unpress", 
			position:"relative",
			top:7,
			left:0
		});
		this.children.push(this.__unSelectImg);
		this.children.push(this.__selectImg);

	},
	select:function(checked)
	{	
		if(checked==true)
		{
		 this.__unSelectImg.setVisibility(false);
		 this.__selectImg.setVisibility(true);
		 }
		 	else
		 {
		  this.__unSelectImg.setVisibility(true);
		  this.__selectImg.setVisibility(false);
		 }
	}

});
/**
 * 搜索控件
 */
Emp.Search = Emp.extend(Emp.Panel, {
	init : function(params) {
        params.width=params.width||'160';
        Emp.Search.superclass.init.call(this, {'width':params.width});
        //params.width=params.width-40;
        params.width="100%";
		this.__input=new Emp.Text(params);
		this.__input.content.backgroundImage='/images/widgets/empty.png';
		this.__input.content.singleLine="true";
		this.__bt=new Emp.Search_Bt();
		var bt=this.__bt;
		var input=this.__input;
		var date=this;
		this.children.push(this.__input);
		this.children.push(this.__bt);
	    this.content.class = "emp-search-ct";		

		
		this.__bt.addEvent("onPressDown",function(){
			if(this.readonly+""=="true") return;
			bt.select(true);
		});
		
		this.__bt.addEvent("onPressUp",function(){
	    	if(this.readonly+""=="true") return;
			bt.select(false);
			Emp.callback(input.modelId+"searchClick",[input.getValue()]);	
		});	
		
	}, 
	addEvent:function(n,f) 
	{
	   if(n=="onChange")
			this.__input.addEvent(n,f);
	   if(n=="onClick"){
	   	   Emp.addEvent(this.__input.modelId+"searchClick", f);
		}
	}, 
	getValue:function(){
	
		return this.__input.getValue();
	},
	setValue:function(value){
	
		 this.__input.setValue(value);
	}	
	
});


Emp.Camera = Emp.extend(Emp.Label, {
	/*
	 * constructionInfo : { type : 'baseui', model : 'NativeInputText',
	 * widgetType : "text" },
	 */
	init : function(params) {
		Emp.Label.superclass.init.call(this, params);
		this.content.constructionInfo = {
			type : 'baseui',
			model : 'NativeCamera',
			widgetType : "Camera"
		};
	},
	takePicture:function(path,callback){
		var s = {};
		if(callback!=null)
			this.addEvent("takePicture",callback)
		path=path||"";
		s.method = "takePicture";
		s.value = path;	
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	zoomIn:function(addProcess){
		var s = {};
		addProcess = addProcess || 1;
		s.value = addProcess;
		s.method = "zoomIn";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	zoomOut:function(minProcess){
		var s = {};
		minProcess = minProcess || 1;
		s.value = minProcess;
		s.method = "zoomOut";
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	},
	close:function(){
		var s = {};
		s.method = "close";
		s.value = "";	
		empBridge.fireModelMethod(this.modelId, util.jsonToString(s));
	}

})
	
