var window = this;

var Emp = {
	apply : function(o, c, defaults) {
		if (defaults) {
			// no "this" reference for friendly out of scope calls
			Ext.apply(o, defaults);
		}
		if (o && c && typeof c == 'object') {
			for ( var p in c) {
				o[p] = c[p];
			}
		}
		return o;
	},
	applyIf : function(o, c) {
		if (o && c) {
			for ( var p in c) {
				if (typeof o[p] == "undefined") {
					o[p] = c[p];
				}
			}
		}
		return o;
	},
	extend : function() {
		// inline overrides
		var io = function(o) {
			for ( var m in o) {
				this[m] = o[m];
			}
		};
		var oc = Object.prototype.constructor;

		return function(sb, sp, overrides) {
			if (typeof sp == 'object') {
				overrides = sp;
				sp = sb;
				sb = overrides.constructor != oc ? overrides.constructor
						: function() {
							sp.apply(this, arguments);
						};
			}

			var F = function() {
			}, sbp, spp = sp.prototype;
			F.prototype = spp;
			sbp = sb.prototype = new F();
			sbp.constructor = sb;
			sb.superclass = spp;
			if (spp.constructor == oc) {
				spp.constructor = sp;
			}
			sb.override = function(o) {
				Ext.override(sb, o);
			};
			sbp.override = io;
			Emp.override(sb, overrides);
			sb.extend = function(o) {
				Ext.extend(sb, o);
			};
			return sb;
		};
	}(),
	override : function(origclass, overrides) {
		if (overrides) {
			var p = origclass.prototype;
			for ( var method in overrides) {
				p[method] = overrides[method];
			}
			// if(Ext.isIE && overrides.toString != origclass.toString){
			// p.toString = overrides.toString;
			// }
		}
	}
}
Emp.isAndroid = true;
Emp.isIOS = false;
Emp.objectIndex = 0;
Emp.getObjectUUId = function() {
	Emp.objectIndex++;
	return Emp.objectIndex;
}
Emp.events = {};
Emp.objects = {};
Emp.components = {};
Emp.get = function(arg1) {
	return Emp.components[arg1];
}
Emp.callback = function(functionId, args) {
	var j = Emp.events[functionId];
	if (functionId == '1onBack') {
		var backId = Emp.SlidePageId.pop();
		if (backId) {
			var f = Emp.events[backId+"onBack"];
			if (f && f.Function) {
                f.Function.apply(f.thisObject, args);
             }
		}
	}
	if(functionId=='1onMsgReceive'){//如果事件为接收消息通知事件，执行slide页中的onMsgReceive方法
		var temp =Emp.SlidePageIdOnMsgReceive;
		for(var i=0;i<temp.length;i++){
			var arr = temp[i].split(",");
			if(arr[1]!=Emp.SlidePageSelectedIndex)//如果没有在slide中当前选中页面，不触发
				continue ;
			var f = Emp.events[arr[0]+"onMsgReceive"];
			if (f && f.Function) {
                f.Function.apply(f.thisObject, args);
             }
		}
	}
	if (j) {
		
			if (j.Function) {
				if (!args || args == null) {
					j.Function();
					return;
				}
				// log("zxf",util.jsonToString(args));
				j.Function.apply(j.object, args);
				// Emp.events[functionId].Function(args.arg0,args.arg1,args.arg2,args.arg3,args.arg4,args.arg5,args.arg6,args.arg7);
			}
	}
};
Emp.addEvent = function(fuctionId, callback, obj) {
	Emp.events[fuctionId] = {
		Function : callback,
		object : obj
	};
	return fuctionId;
};

/*
 * Emp.setOnJsLoad = function(callBack){ Emp.addEvent("onJsLoad",callBack); };
 * Emp.setOnPageBack = function(callBack){ Emp.addEvent("onPageBack",callBack); };
 */
/*
 * Emp.gotoPage = function(url,jsondata,isIntab){
 * empBridge.gotoPage(url,jsondata,isIntab); }; Emp.goBack = function(json){
 * empBridge.goBack(json); };
 */
/*
 * Emp.getParams = function(){
 * //log("str转json："+empBridge.getParams().evalJSON()); return
 * eval('('+empBridge.getParams()+')'); };
 */

/*
 * Emp.goTo = function(url,jsondata,isIntab){
 * empBridge.goTo(url,jsondata,isIntab); };
 */

Emp.render = function() {
	if (Emp.page.isInclude == true)
		return;
	if (Emp.page.isRender == true)
		return;
	Emp.page.setRender();
	/*
	 * s ={}; s.method = "createPage"; s.value = util.jsonToString(Emp.page);
	 * empBridge.fireMethod("pageBridge",util.jsonToString(s));
	 */
	empBridge.createPage(util.jsonToString(Emp.page));
};

Emp.newRender = function(root) {
	empBridge.createUIModel(util.jsonToString(root));
};

Emp.newNativeObject = function(root) {
	empBridge.createNativeObject(util.jsonToString(root));
};

// move to Emp.Portal.getAllApps();
Emp.getAllApps = function() {
	try {
		var r = empBridge.getAllApps();
		// log(r);
		// r=r.substr(0,r.length-1);
		// log("apps:"+r)
		return r.evalJSON();
	} catch (e) {
		log("javascript error, getAllApps:" + e.message);
	}
};

Emp.getContextValue = function(key) {
	if (!key) {
		return;
	}
	return empBridge.getContextValue(key);
};

Emp.setContextValue = function(key, value) {
	if (!key || !value) {
		log("数据格式不正确");
		return;
	}
	return empBridge.setContextValue(key, value);
};

Emp.getAppPackageName = function() {
	return empBridge.getAppPackageName();
};

// move to Emp.Portal.setCurrentAppId
Emp.setCurrentAppId = function(id) {
	empBridge.setCurrentAppId(id);
};

Emp.getCurrentAppId = function() {
	return empBridge.getCurrentAppId();
};

Emp.getScreenSize = function() {
	return BridgeUtil.invokeBridgeResultMethod("baseCapacityBridge",
			"getScreenSize", {}).evalJSON();
}

/**
 * 存储Form表单数据值，用于Ajax提交
 */
Emp.formKeyValue = [];
/**
 * 设置定时器
 * 
 * @param callBack
 *            调用的函数
 * @param duraction
 *            每隔多久调用一次
 * @returns 返回定时器id
 */
function setInterval(callBack, duraction) {
	var id = Emp.getObjectUUId();
	Emp.addEvent(id + "interval", callBack)
	empBridge.setInterval(id, duraction);
	return id;
};
/**
 * 根据定时器id，取消调用
 * 
 * @param id
 */
function clearInterval(id) {
	empBridge.clearInterval(id);
};
/**
 * 取消所有定时器
 */
function clearAllIntervals(){
	empBridge.clearAllInterval();
}

/*
 * 已废弃，API不再提供
 */
Emp.sleep = function(time, callback) {
	if(Emp.page.timeoutid==undefined){
		Emp.page.timeoutid=0;
	}else{
		var id = Emp.page.timeoutid;
		id=++id;
		Emp.page.timeoutid=id;;
	}
	Emp.addEvent("setTimeout"+Emp.page.timeoutid, callback);
	var json = {};
	json.time=time;
	json.id=Emp.page.timeoutid;
	empBridge.pause(util.jsonToString(json));
};
/*
 * 设置一段时间后执行某一个方法
 * @param time 时长
 * @param callback 执行方法
 */
function setTimeout(callback,time){
	if(typeof(callback)=='function'){
		Emp.sleep(time,callback)
	}else{
		Emp.sleep(callback,time);
	}
	
}

/**
 * 设置clientConfig
 */
// move to portal
Emp.saveClientConfig = function(json) {
	empBridge.saveClientConfig(util.jsonToString(json));
}
/**
 * 设置获取clientConfig
 */
// move to portal
Emp.getClientConfig = function() {
	return empBridge.getClientConfig().evalJSON();
}
Emp.Object = function(config) {
	config = config || {};
	if (config.initialConfig) {
		if (config.isAction) { // actions
			this.baseAction = config;
		}
		config = config.initialConfig; // component cloning / action set up
	} else if (config.tagName || config.dom || typeof config == "string") { // element
		// object
		config = {
			applyTo : config,
			id : config.id || config
		};
	}

	/**
	 * This Component's initial configuration specification. Read-only.
	 * 
	 * @type Object
	 * @property initialConfig
	 */
	Emp.apply(this, config);//modify by ton,恢复属性配置
	if (this.init !== null)
		try{
			this.init(config);
		}catch(e){
			
		}
};

/*
 * html加载另一个页面
 * @param filePath  页面路径
 */
Emp.includeFile = function(filePath) {
	empBridge.includeFile(filePath);
};
var system={}

var System=system;
/**
 * 清除缓存（图片文件）
 * @param src 图片文件路径
 */
system.clearCache= function(src,callback){
	if(!src){
		src={};
	}
	if(callback){
		Emp.addEvent( "clearCache", callback);
	}
	return BridgeUtil.invokeBridgeResultMethod("baseCapacityBridge", "clearCache", {"src":src});
}
/**
 * 清除所有图片缓存
 */
system.clearAllCache= function(callback){
	src={};
	Emp.addEvent( "clearCache", callback);
	return BridgeUtil.invokeBridgeResultMethod("baseCapacityBridge", "clearCache", {"src":src});
}
/**
*隐藏键盘
*/
system.hideKeyboard =function(){
	BridgeUtil.invokeBridgeResultMethod("baseCapacityBridge", "hideKeyboard", {});
}

/**
*清空所有cookie
*/
system.clearAllCookie =function(){
	BridgeUtil.invokeBridgeResultMethod("baseCapacityBridge", "clearAllCookie", {});
}

/**
 * 退出应用程序
 */
system.exit= function(){
	return BridgeUtil.invokeBridgeResultMethod("baseCapacityBridge", "exit", {});
}
Emp.ViewSize = {};
Emp.SlidePageId = [];
Emp.SlidePageIdOnMsgReceive =[];
Emp.SlidePageSelectedIndex=0;
Emp.ViewSize.FillParent = "-1";
Emp.ViewSize.WrapContent = "-2";
Emp.clone = function(obj) {
	var clone, property, value;
	if (!obj || typeof obj !== 'object') {
		return obj;
	}
	clone = typeof obj.pop === 'function' ? [] : {};
	clone.__proto__ = obj.__proto__;
	for (property in obj) {
		if (obj.hasOwnProperty(property)) {
			value = obj.property;
			if (value && typeof value === 'object') {
				clone[property] = Emp.clone(value);
			} else {
				clone[property] = obj[property];
			}
		}
	}
	return clone;
};
Emp.getDownLoadDir = function() {
	s = BridgeUtil.invokeBridgeResultMethod("globalDataBridge",
			"getDownLoadDir");
	return s;
};
Emp.getUserDownFilePath = function(path) {
	s = BridgeUtil.invokeBridgeResultMethod("globalDataBridge",
			"getUserDownFilePath", {
				'path' : path
			});
	return s;
};
Emp.getResourcePathFormRes = function(url) {
	return BridgeUtil.invokeBridgeResultMethod("globalDataBridge",
			"getResourcePathFormRes", {
				path : url
			});
};
