/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.util.Size;
import android.util.SizeF;
import android.view.Surface;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mediapipe.components.CameraHelper;
import com.google.mediapipe.glutil.EglManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.microedition.khronos.egl.EGLSurface;

public class CameraXPreviewHelper
extends CameraHelper {
    private static final String TAG = "CameraXPreviewHelper";
    private static final Size TARGET_SIZE = new Size(1280, 720);
    private static final double ASPECT_TOLERANCE = 0.25;
    private static final double ASPECT_PENALTY = 10000.0;
    private static final int CLOCK_OFFSET_CALIBRATION_ATTEMPTS = 3;
    private final SingleThreadHandlerExecutor renderExecutor = new SingleThreadHandlerExecutor("CamXRenderThread", 0);
    private ProcessCameraProvider cameraProvider;
    private Preview preview;
    private ImageCapture imageCapture;
    private ImageCapture.Builder imageCaptureBuilder;
    private ExecutorService imageCaptureExecutorService;
    private Camera camera;
    private int[] textures = null;
    private Size frameSize;
    private int frameRotation;
    private boolean isImageCaptureEnabled = false;
    @Nullable
    private CameraCharacteristics cameraCharacteristics = null;
    private float focalLengthPixels = Float.MIN_VALUE;
    private int cameraTimestampSource = 0;

    private static long getOffsetFromUnknownTimestampSource() {
        return 0L;
    }

    private static long getOffsetFromRealTimeTimestampSource() {
        long offset = Long.MAX_VALUE;
        long lowestGap = Long.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            long startMonoTs = System.nanoTime();
            long realTs = SystemClock.elapsedRealtimeNanos();
            long endMonoTs = System.nanoTime();
            long gapMonoTs = endMonoTs - startMonoTs;
            if (gapMonoTs >= lowestGap) continue;
            lowestGap = gapMonoTs;
            offset = (startMonoTs + endMonoTs) / 2L - realTs;
        }
        return offset;
    }

    @Nullable
    private static CameraCharacteristics getCameraCharacteristics(Context context, Integer lensFacing) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            List<String> cameraList = Arrays.asList(cameraManager.getCameraIdList());
            for (String availableCameraId : cameraList) {
                CameraCharacteristics availableCameraCharacteristics = cameraManager.getCameraCharacteristics(availableCameraId);
                Integer availableLensFacing = (Integer)availableCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (availableLensFacing == null || !availableLensFacing.equals(lensFacing)) continue;
                return availableCameraCharacteristics;
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Accessing camera ID info got error: " + (Object)((Object)e)));
        }
        return null;
    }

    @Override
    public void startCamera(Activity activity, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture) {
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, surfaceTexture, TARGET_SIZE);
    }

    @Override
    public Size computeDisplaySizeFromViewSize(Size viewSize) {
        return this.frameSize;
    }

    @Override
    public boolean isCameraRotated() {
        return this.frameRotation % 180 == 90;
    }

    public void startCamera(Activity activity, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture, @Nullable Size targetSize) {
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, surfaceTexture, targetSize);
    }

    public void startCamera(Activity activity, @Nonnull ImageCapture.Builder imageCaptureBuilder, CameraHelper.CameraFacing cameraFacing, @Nullable Size targetSize) {
        this.imageCaptureBuilder = imageCaptureBuilder;
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, targetSize);
    }

    public void startCamera(Activity activity, @Nonnull ImageCapture.Builder imageCaptureBuilder, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture, @Nullable Size targetSize) {
        this.imageCaptureBuilder = imageCaptureBuilder;
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, surfaceTexture, targetSize);
    }

    public void startCamera(Context context, LifecycleOwner lifecycleOwner, CameraHelper.CameraFacing cameraFacing, @Nullable Size targetSize) {
        this.startCamera(context, lifecycleOwner, cameraFacing, null, targetSize);
    }

    private void startCamera(Context context, LifecycleOwner lifecycleOwner, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture, @Nullable Size targetSize) {
        Executor mainThreadExecutor = ContextCompat.getMainExecutor((Context)context);
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)context);
        boolean isSurfaceTextureProvided = surfaceTexture != null;
        Integer selectedLensFacing = cameraFacing == CameraHelper.CameraFacing.FRONT ? 0 : 1;
        this.cameraCharacteristics = CameraXPreviewHelper.getCameraCharacteristics(context, selectedLensFacing);
        if ((targetSize = this.getOptimalViewSize(targetSize)) == null) {
            targetSize = TARGET_SIZE;
        }
        Size rotatedSize = new Size(targetSize.getHeight(), targetSize.getWidth());
        cameraProviderFuture.addListener(() -> {
            try {
                this.cameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                Log.e((String)TAG, (String)"Unable to get ProcessCameraProvider: ", (Throwable)e);
                return;
            }
            this.preview = new Preview.Builder().setTargetAspectRatio(1).build();
            CameraSelector cameraSelector = cameraFacing == CameraHelper.CameraFacing.FRONT ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA;
            this.preview.setSurfaceProvider((Executor)this.renderExecutor, request -> {
                this.frameSize = request.getResolution();
                Log.d((String)TAG, (String)String.format("Received surface request for resolution %dx%d", this.frameSize.getWidth(), this.frameSize.getHeight()));
                SurfaceTexture previewFrameTexture = isSurfaceTextureProvided ? surfaceTexture : this.createSurfaceTexture();
                previewFrameTexture.setDefaultBufferSize(this.frameSize.getWidth(), this.frameSize.getHeight());
                request.setTransformationInfoListener((Executor)this.renderExecutor, transformationInfo -> {
                    CameraHelper.OnCameraStartedListener listener;
                    this.frameRotation = transformationInfo.getRotationDegrees();
                    this.updateCameraCharacteristics();
                    if (!isSurfaceTextureProvided) {
                        previewFrameTexture.detachFromGLContext();
                    }
                    if ((listener = this.onCameraStartedListener) != null) {
                        ContextCompat.getMainExecutor((Context)context).execute(() -> listener.onCameraStarted(previewFrameTexture));
                    }
                });
                Surface surface = new Surface(previewFrameTexture);
                Log.d((String)TAG, (String)"Providing surface");
                request.provideSurface(surface, (Executor)this.renderExecutor, result -> {
                    Log.d((String)TAG, (String)("Surface request result: " + result));
                    if (this.textures != null) {
                        GLES20.glDeleteTextures((int)1, (int[])this.textures, (int)0);
                    }
                    if (!isSurfaceTextureProvided) {
                        previewFrameTexture.release();
                    }
                    surface.release();
                });
            });
            this.cameraProvider.unbindAll();
            if (this.imageCaptureBuilder != null) {
                this.imageCapture = this.imageCaptureBuilder.build();
                this.camera = this.cameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, new UseCase[]{this.preview, this.imageCapture});
                this.imageCaptureExecutorService = Executors.newSingleThreadExecutor();
                this.isImageCaptureEnabled = true;
            } else {
                this.camera = this.cameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, new UseCase[]{this.preview});
            }
        }, mainThreadExecutor);
    }

    public void takePicture(File outputFile, ImageCapture.OnImageSavedCallback onImageSavedCallback) {
        if (this.isImageCaptureEnabled) {
            ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(outputFile).build();
            this.imageCapture.takePicture(outputFileOptions, (Executor)this.imageCaptureExecutorService, onImageSavedCallback);
        }
    }

    @Nullable
    private Size getOptimalViewSize(@Nullable Size targetSize) {
        if (targetSize == null || this.cameraCharacteristics == null) {
            return null;
        }
        StreamConfigurationMap map = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] outputSizes = map.getOutputSizes(SurfaceTexture.class);
        Size optimalSize = null;
        double targetRatio = (double)targetSize.getWidth() / (double)targetSize.getHeight();
        Log.d((String)TAG, (String)String.format("Camera target size ratio: %f width: %d", targetRatio, targetSize.getWidth()));
        double minCost = Double.MAX_VALUE;
        for (Size size : outputSizes) {
            double aspectRatio = (double)size.getWidth() / (double)size.getHeight();
            double ratioDiff = Math.abs(aspectRatio - targetRatio);
            double cost = (ratioDiff > 0.25 ? 10000.0 + ratioDiff * (double)targetSize.getHeight() : 0.0) + (double)Math.abs(size.getWidth() - targetSize.getWidth());
            Log.d((String)TAG, (String)String.format("Camera size candidate width: %d height: %d ratio: %f cost: %f", size.getWidth(), size.getHeight(), aspectRatio, cost));
            if (!(cost < minCost)) continue;
            optimalSize = size;
            minCost = cost;
        }
        if (optimalSize != null) {
            Log.d((String)TAG, (String)String.format("Optimal camera size width: %d height: %d", optimalSize.getWidth(), optimalSize.getHeight()));
        }
        return optimalSize;
    }

    public long getTimeOffsetToMonoClockNanos() {
        if (this.cameraTimestampSource == 1) {
            return CameraXPreviewHelper.getOffsetFromRealTimeTimestampSource();
        }
        return CameraXPreviewHelper.getOffsetFromUnknownTimestampSource();
    }

    public float getFocalLengthPixels() {
        return this.focalLengthPixels;
    }

    public Size getFrameSize() {
        return this.frameSize;
    }

    public void close() {
        if (this.cameraProvider != null) {
            this.cameraProvider.unbindAll();
        }
        if (this.renderExecutor != null) {
            this.renderExecutor.shutdown();
        }
        if (this.imageCaptureExecutorService != null) {
            this.imageCaptureExecutorService.shutdown();
        }
    }

    private void updateCameraCharacteristics() {
        if (this.cameraCharacteristics != null) {
            this.cameraTimestampSource = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE);
            this.focalLengthPixels = this.calculateFocalLengthInPixels();
        }
    }

    private float calculateFocalLengthInPixels() {
        float focalLengthMm = ((float[])this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS))[0];
        float sensorWidthMm = ((SizeF)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE)).getWidth();
        return (float)this.frameSize.getWidth() * focalLengthMm / sensorWidthMm;
    }

    private SurfaceTexture createSurfaceTexture() {
        EglManager eglManager = new EglManager(null);
        EGLSurface tempEglSurface = eglManager.createOffscreenSurface(1, 1);
        eglManager.makeCurrent(tempEglSurface, tempEglSurface);
        this.textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])this.textures, (int)0);
        SurfaceTexture previewFrameTexture = new SurfaceTexture(this.textures[0]);
        return previewFrameTexture;
    }

    private static final class SingleThreadHandlerExecutor
    implements Executor {
        private final HandlerThread handlerThread;
        private final Handler handler;

        SingleThreadHandlerExecutor(String threadName, int priority) {
            this.handlerThread = new HandlerThread(threadName, priority);
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
        }

        @Override
        public void execute(Runnable command) {
            if (this.handlerThread.isAlive() && !this.handler.post(command)) {
                throw new RejectedExecutionException(this.handlerThread.getName() + " is shutting down.");
            }
        }

        boolean shutdown() {
            return this.handlerThread.quitSafely();
        }
    }
}

