/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.Matrix;
import android.util.Log;
import com.google.mediapipe.framework.TextureFrame;
import com.google.mediapipe.glutil.CommonShaders;
import com.google.mediapipe.glutil.ShaderUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GlSurfaceViewRenderer
implements GLSurfaceView.Renderer {
    private static final String TAG = "DemoRenderer";
    private static final int ATTRIB_POSITION = 1;
    private static final int ATTRIB_TEXTURE_COORDINATE = 2;
    private final int textureIndex;
    private final AtomicReference<TextureFrame> nextFrame = new AtomicReference();
    private int surfaceWidth;
    private int surfaceHeight;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private int program = 0;
    private int frameUniform;
    private int textureTarget = 36197;
    private int textureTransformUniform;
    private float alignmentHorizontal = 0.5f;
    private float alignmentVertical = 0.5f;
    private float[] textureTransformMatrix = new float[16];
    private SurfaceTexture surfaceTexture = null;

    public GlSurfaceViewRenderer() {
        this.textureIndex = 0;
    }

    public GlSurfaceViewRenderer(int targetTextureIndex) {
        this.textureIndex = targetTextureIndex;
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        if (this.surfaceTexture == null) {
            Matrix.setIdentityM((float[])this.textureTransformMatrix, (int)0);
        }
        HashMap<String, Integer> attributeLocations = new HashMap<String, Integer>();
        attributeLocations.put("position", 1);
        attributeLocations.put("texture_coordinate", 2);
        Log.d((String)TAG, (String)("external texture: " + this.isExternalTexture()));
        this.program = ShaderUtil.createProgram("uniform mat4 texture_transform;\nattribute vec4 position;\nattribute mediump vec4 texture_coordinate;\nvarying mediump vec2 sample_coordinate;\n\nvoid main() {\n  gl_Position = position;\n  sample_coordinate = (texture_transform * texture_coordinate).xy;\n}", this.isExternalTexture() ? "#extension GL_OES_EGL_image_external : require\nvarying mediump vec2 sample_coordinate;\nuniform samplerExternalOES video_frame;\n\nvoid main() {\n  gl_FragColor = texture2D(video_frame, sample_coordinate);\n}" : "varying mediump vec2 sample_coordinate;\nuniform sampler2D video_frame;\n\nvoid main() {\n  gl_FragColor = texture2D(video_frame, sample_coordinate);\n}", attributeLocations);
        this.frameUniform = GLES20.glGetUniformLocation((int)this.program, (String)"video_frame");
        this.textureTransformUniform = GLES20.glGetUniformLocation((int)this.program, (String)"texture_transform");
        ShaderUtil.checkGlError("glGetUniformLocation");
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.surfaceWidth = width;
        this.surfaceHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    public void onDrawFrame(GL10 gl) {
        TextureFrame frame = this.renderFrame();
        this.flush(frame);
    }

    protected TextureFrame renderFrame() {
        TextureFrame frame = this.nextFrame.getAndSet(null);
        GLES20.glClear((int)16384);
        ShaderUtil.checkGlError("glClear");
        if (this.surfaceTexture == null && frame == null) {
            return null;
        }
        GLES20.glActiveTexture((int)(33984 + this.textureIndex));
        ShaderUtil.checkGlError("glActiveTexture");
        if (this.surfaceTexture != null) {
            this.surfaceTexture.updateTexImage();
            this.surfaceTexture.getTransformMatrix(this.textureTransformMatrix);
        } else {
            GLES20.glBindTexture((int)this.textureTarget, (int)frame.getTextureName());
            ShaderUtil.checkGlError("glBindTexture");
        }
        GLES20.glTexParameteri((int)this.textureTarget, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)this.textureTarget, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)this.textureTarget, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)this.textureTarget, (int)10243, (int)33071);
        ShaderUtil.checkGlError("texture setup");
        GLES20.glUseProgram((int)this.program);
        GLES20.glUniform1i((int)this.frameUniform, (int)0);
        GLES20.glUniformMatrix4fv((int)this.textureTransformUniform, (int)1, (boolean)false, (float[])this.textureTransformMatrix, (int)0);
        ShaderUtil.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)1);
        GLES20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)CommonShaders.SQUARE_VERTICES);
        float[] boundary = this.calculateTextureBoundary();
        float textureLeft = boundary[0];
        float textureRight = boundary[1];
        float textureBottom = boundary[2];
        float textureTop = boundary[3];
        FloatBuffer passThroughTextureVertices = ShaderUtil.floatBuffer(textureLeft, textureBottom, textureRight, textureBottom, textureLeft, textureTop, textureRight, textureTop);
        GLES20.glEnableVertexAttribArray((int)2);
        GLES20.glVertexAttribPointer((int)2, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)passThroughTextureVertices);
        ShaderUtil.checkGlError("program setup");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        ShaderUtil.checkGlError("glDrawArrays");
        GLES20.glBindTexture((int)this.textureTarget, (int)0);
        ShaderUtil.checkGlError("unbind surfaceTexture");
        return frame;
    }

    protected float[] calculateTextureBoundary() {
        float scaleWidth = this.frameWidth > 0 ? (float)this.surfaceWidth / (float)this.frameWidth : 1.0f;
        float scaleHeight = this.frameHeight > 0 ? (float)this.surfaceHeight / (float)this.frameHeight : 1.0f;
        float maxScale = Math.max(scaleWidth, scaleHeight);
        float textureLeft = (1.0f - (scaleWidth /= maxScale)) * this.alignmentHorizontal;
        float textureRight = textureLeft + scaleWidth;
        float textureBottom = (1.0f - (scaleHeight /= maxScale)) * this.alignmentVertical;
        float textureTop = textureBottom + scaleHeight;
        return new float[]{textureLeft, textureRight, textureBottom, textureTop};
    }

    protected void flush(TextureFrame frame) {
        GLES20.glFlush();
        if (frame != null) {
            frame.release();
        }
    }

    public void setTextureTarget(int target) {
        if (this.program != 0) {
            throw new IllegalStateException("setTextureTarget must be called before the surface is created");
        }
        this.textureTarget = target;
    }

    public void setSurfaceTexture(SurfaceTexture texture) {
        if (!this.isExternalTexture()) {
            throw new IllegalStateException("to use a SurfaceTexture, the texture target must be GL_TEXTURE_EXTERNAL_OES");
        }
        TextureFrame oldFrame = this.nextFrame.getAndSet(null);
        if (oldFrame != null) {
            oldFrame.release();
        }
        this.surfaceTexture = texture;
    }

    public void setNextFrame(TextureFrame frame) {
        TextureFrame oldFrame;
        if (this.surfaceTexture != null) {
            Matrix.setIdentityM((float[])this.textureTransformMatrix, (int)0);
        }
        if ((oldFrame = this.nextFrame.getAndSet(frame)) != null && (frame == null || oldFrame.getTextureName() != frame.getTextureName())) {
            oldFrame.release();
        }
        this.surfaceTexture = null;
    }

    public void setFrameSize(int width, int height) {
        this.frameWidth = width;
        this.frameHeight = height;
    }

    public void setAlignment(float horizontal, float vertical) {
        this.alignmentHorizontal = horizontal;
        this.alignmentVertical = vertical;
    }

    private boolean isExternalTexture() {
        return this.textureTarget == 36197;
    }
}

