/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import android.graphics.Bitmap;
import com.google.common.base.Preconditions;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketGetter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class AndroidPacketGetter {
    public static Bitmap getBitmapFromRgb(Packet packet) {
        int width = PacketGetter.getImageWidth(packet);
        int height = PacketGetter.getImageHeight(packet);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        AndroidPacketGetter.copyRgbToBitmap(packet, bitmap, width, height);
        return bitmap;
    }

    public static void copyRgbToBitmap(Packet packet, Bitmap inBitmap) {
        Preconditions.checkArgument((boolean)inBitmap.isMutable(), (Object)"Input bitmap should be mutable.");
        Preconditions.checkArgument((inBitmap.getConfig() == Bitmap.Config.ARGB_8888 ? 1 : 0) != 0, (Object)"Input bitmap should be of type ARGB_8888.");
        int width = PacketGetter.getImageWidth(packet);
        int height = PacketGetter.getImageHeight(packet);
        Preconditions.checkArgument((inBitmap.getByteCount() == width * height * 4 ? 1 : 0) != 0, (Object)"Input bitmap size mismatch.");
        AndroidPacketGetter.copyRgbToBitmap(packet, inBitmap, width, height);
    }

    private static void copyRgbToBitmap(Packet packet, Bitmap mutableBitmap, int width, int height) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        PacketGetter.getRgbaFromRgb(packet, buffer);
        mutableBitmap.copyPixelsFromBuffer((Buffer)buffer);
    }

    public static Bitmap getBitmapFromRgba(Packet packet) {
        int width = PacketGetter.getImageWidth(packet);
        int height = PacketGetter.getImageHeight(packet);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        AndroidPacketGetter.copyRgbaToBitmap(packet, bitmap, width, height);
        return bitmap;
    }

    public static void copyRgbaToBitmap(Packet packet, Bitmap inBitmap) {
        Preconditions.checkArgument((boolean)inBitmap.isMutable(), (Object)"Input bitmap should be mutable.");
        Preconditions.checkArgument((inBitmap.getConfig() == Bitmap.Config.ARGB_8888 ? 1 : 0) != 0, (Object)"Input bitmap should be of type ARGB_8888.");
        int width = PacketGetter.getImageWidth(packet);
        int height = PacketGetter.getImageHeight(packet);
        Preconditions.checkArgument((inBitmap.getByteCount() == width * height * 4 ? 1 : 0) != 0, (Object)"Input bitmap size mismatch.");
        AndroidPacketGetter.copyRgbaToBitmap(packet, inBitmap, width, height);
    }

    private static void copyRgbaToBitmap(Packet packet, Bitmap mutableBitmap, int width, int height) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(width * height * 4);
        buffer.order(ByteOrder.nativeOrder());
        boolean status = PacketGetter.getImageData(packet, buffer);
        Preconditions.checkState((boolean)status, (Object)String.format("Got error from getImageData, returning null Bitmap. Image width %d, height %d", width, height));
        mutableBitmap.copyPixelsFromBuffer((Buffer)buffer);
    }

    private AndroidPacketGetter() {
    }
}

