/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.mediapipe.framework.GlSyncToken;
import com.google.mediapipe.framework.TextureFrame;

public class AppTextureFrame
implements TextureFrame {
    private int textureName;
    private int width;
    private int height;
    private long timestamp = Long.MIN_VALUE;
    private boolean inUse = false;
    private boolean legacyInUse = false;
    private GlSyncToken releaseSyncToken = null;

    public AppTextureFrame(int textureName, int width, int height) {
        this.textureName = textureName;
        this.width = width;
        this.height = height;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public int getTextureName() {
        return this.textureName;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotYetReleased() {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            return this.inUse && this.releaseSyncToken == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReleased() throws InterruptedException {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            while (this.inUse && this.releaseSyncToken == null) {
                this.wait();
            }
            if (this.releaseSyncToken != null) {
                this.releaseSyncToken.waitOnCpu();
                this.releaseSyncToken.release();
                this.inUse = false;
                this.releaseSyncToken = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReleasedWithGpuSync() throws InterruptedException {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            while (this.inUse && this.releaseSyncToken == null) {
                this.wait();
            }
            if (this.releaseSyncToken != null) {
                this.releaseSyncToken.waitOnGpu();
                this.releaseSyncToken.release();
                this.inUse = false;
                this.releaseSyncToken = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean getInUse() {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            return this.legacyInUse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInUse() {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            if (this.releaseSyncToken != null) {
                this.releaseSyncToken.release();
                this.releaseSyncToken = null;
            }
            this.inUse = true;
            this.legacyInUse = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            this.inUse = false;
            this.legacyInUse = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(GlSyncToken syncToken) {
        AppTextureFrame appTextureFrame = this;
        synchronized (appTextureFrame) {
            if (this.releaseSyncToken != null) {
                this.releaseSyncToken.release();
                this.releaseSyncToken = null;
            }
            this.releaseSyncToken = syncToken;
            this.legacyInUse = false;
            this.notifyAll();
        }
    }

    public void finalize() {
        if (this.releaseSyncToken != null) {
            this.releaseSyncToken.release();
            this.releaseSyncToken = null;
        }
    }
}

