/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.mediapipe.framework.AssetCacheDbHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public class AssetCache {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    @VisibleForTesting
    static final String MEDIAPIPE_ASSET_CACHE_DIR = "asset_cache";
    private static AssetCache assetCache;
    private int appVersionCode;
    private AssetCacheDbHelper versionDatabase;
    private Context context;

    public static synchronized AssetCache create(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (assetCache == null) {
            assetCache = new AssetCache(context);
        }
        return assetCache;
    }

    public static synchronized void purgeCache(Context context) {
        AssetCacheDbHelper dbHelper = new AssetCacheDbHelper(context);
        dbHelper.invalidateCache(-1);
        dbHelper.close();
    }

    @Nullable
    public static synchronized AssetCache getAssetCache() {
        return assetCache;
    }

    public synchronized void loadAllAssets(String assetsPath) {
        Preconditions.checkNotNull((Object)assetsPath);
        AssetManager assetManager = this.context.getAssets();
        String[] assetFiles = null;
        try {
            assetFiles = assetManager.list(assetsPath);
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Unable to get files in assets path: %s", (Object)assetsPath);
        }
        if (assetFiles == null || assetFiles.length == 0) {
            ((FluentLogger.Api)logger.atWarning()).log("No files to load");
            return;
        }
        for (String file : assetFiles) {
            String path = TextUtils.isEmpty((CharSequence)assetsPath) ? file : assetsPath + "/" + file;
            this.getAbsolutePathFromAsset(path);
        }
    }

    public synchronized String getAbsolutePathFromAsset(String assetPath) {
        AssetManager assetManager = this.context.getAssets();
        File destinationDir = this.getDefaultMediaPipeCacheDir();
        destinationDir.mkdir();
        File assetFile = new File(assetPath);
        String assetName = assetFile.getName();
        File destinationFile = new File(destinationDir.getPath(), assetName);
        if (destinationFile.exists() && this.appVersionCode != 0 && this.versionDatabase.checkVersion(assetPath, this.appVersionCode)) {
            return destinationFile.getAbsolutePath();
        }
        InputStream inStream = null;
        try {
            inStream = assetManager.open(assetPath);
            AssetCache.writeStreamToFile(inStream, destinationFile);
        }
        catch (IOException ioe) {
            ((FluentLogger.Api)logger.atSevere()).log("Unable to unpack: %s", (Object)assetPath);
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ioe2) {
                return null;
            }
            return null;
        }
        if (this.appVersionCode != 0) {
            this.versionDatabase.insertAsset(assetPath, destinationFile.getAbsolutePath(), this.appVersionCode);
        }
        return destinationFile.getAbsolutePath();
    }

    public synchronized String[] getAvailableAssets() {
        File assetsDir = this.getDefaultMediaPipeCacheDir();
        if (assetsDir.exists()) {
            return assetsDir.list();
        }
        return new String[0];
    }

    public File getDefaultMediaPipeCacheDir() {
        return new File(this.context.getCacheDir(), MEDIAPIPE_ASSET_CACHE_DIR);
    }

    private AssetCache(Context context) {
        this.context = context;
        this.versionDatabase = new AssetCacheDbHelper(context);
        try {
            this.appVersionCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            ((FluentLogger.Api)logger.atInfo()).log("Current app version code: %d", this.appVersionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Can't get app version code.", e);
        }
        this.versionDatabase.invalidateCache(this.appVersionCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStreamToFile(InputStream inStream, File destinationFile) throws IOException {
        int bufferSize = 1000;
        try (FileOutputStream outStream = null;){
            int n;
            outStream = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[1000];
            while ((n = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, n);
            }
        }
    }
}

