/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.common.base.Preconditions;
import com.google.mediapipe.framework.Graph;
import com.google.mediapipe.proto.CalculatorProfileProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;

public class GraphProfiler {
    private final long nativeProfilerHandle;
    private final Graph mediapipeGraph;

    GraphProfiler(long nativeProfilerHandle, Graph mediapipeGraph) {
        Preconditions.checkState((nativeProfilerHandle != 0L ? 1 : 0) != 0, (Object)"Invalid profiler, tearDown() might have been called already.");
        this.nativeProfilerHandle = nativeProfilerHandle;
        this.mediapipeGraph = mediapipeGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Graph graph = this.mediapipeGraph;
        synchronized (graph) {
            this.checkContext();
            this.nativeReset(this.nativeProfilerHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Graph graph = this.mediapipeGraph;
        synchronized (graph) {
            this.checkContext();
            this.nativeResume(this.nativeProfilerHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Graph graph = this.mediapipeGraph;
        synchronized (graph) {
            this.checkContext();
            this.nativePause(this.nativeProfilerHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalculatorProfileProto.CalculatorProfile> getCalculatorProfiles() {
        Graph graph = this.mediapipeGraph;
        synchronized (graph) {
            this.checkContext();
            byte[][] profileBytes = this.nativeGetCalculatorProfiles(this.nativeProfilerHandle);
            ArrayList<CalculatorProfileProto.CalculatorProfile> profileList = new ArrayList<CalculatorProfileProto.CalculatorProfile>();
            if (profileBytes == null) {
                return profileList;
            }
            for (byte[] element : profileBytes) {
                try {
                    CalculatorProfileProto.CalculatorProfile profile = CalculatorProfileProto.CalculatorProfile.parseFrom((byte[])element);
                    profileList.add(profile);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
            return profileList;
        }
    }

    private void checkContext() {
        Preconditions.checkState((this.mediapipeGraph.getNativeHandle() != 0L ? 1 : 0) != 0, (Object)"Invalid context, tearDown() might have been called already.");
    }

    private native void nativeReset(long var1);

    private native void nativeResume(long var1);

    private native void nativePause(long var1);

    private native byte[][] nativeGetCalculatorProfiles(long var1);
}

