/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import android.content.Context;
import com.google.mediapipe.framework.AssetCache;
import com.google.mediapipe.framework.Graph;
import com.google.mediapipe.framework.MediaPipeException;

public abstract class MediaPipeRunner
extends Graph {
    protected Context context;

    public MediaPipeRunner(Context context) {
        AssetCache.create(context);
        this.context = context;
    }

    public void loadBinaryGraphFromAsset(String assetPath) {
        try {
            this.loadBinaryGraph(AssetCache.getAssetCache().getAbsolutePathFromAsset(assetPath));
        }
        catch (MediaPipeException mediaPipeException) {
            // empty catch block
        }
    }

    public abstract void start();

    public abstract void pause();

    public abstract void resume();

    public abstract void release();

    public void release(long timeoutMillis) {
        this.release();
    }
}

