/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.mediapipe.framework.TypeNameRegistry;
import com.google.mediapipe.framework.TypeNameRegistryConcrete;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.util.NoSuchElementException;

public final class ProtoUtil {
    static TypeNameRegistry typeNameRegistry = new TypeNameRegistryConcrete();

    public static <T extends MessageLite> void registerTypeName(Class<T> clazz, String typeName) {
        typeNameRegistry.registerTypeName(clazz, typeName);
    }

    public static <T extends MessageLite> String getTypeName(Class<T> clazz) {
        return typeNameRegistry.getTypeName(clazz);
    }

    public static ExtensionRegistryLite getExtensionRegistry() {
        return ExtensionRegistryLite.getEmptyRegistry();
    }

    public static <T extends MessageLite> SerializedMessage pack(T message) {
        SerializedMessage result = new SerializedMessage();
        result.typeName = ProtoUtil.getTypeName(message.getClass());
        if (result.typeName == null) {
            throw new NoSuchElementException("Cannot determine the protobuf type name for class: " + message.getClass() + ". Have you called ProtoUtil.registerTypeName?");
        }
        result.value = message.toByteArray();
        return result;
    }

    public static <T extends MessageLite> T unpack(SerializedMessage serialized, T defaultInstance) throws InvalidProtocolBufferException {
        String expectedType = ProtoUtil.getTypeName(defaultInstance.getClass());
        if (!serialized.typeName.equals(expectedType)) {
            throw new InvalidProtocolBufferException("Message type does not match the expected type. Expected: " + expectedType + " Got: " + serialized.typeName);
        }
        MessageLite result = (MessageLite)defaultInstance.getParserForType().parseFrom(serialized.value, ProtoUtil.getExtensionRegistry());
        return (T)result;
    }

    private ProtoUtil() {
    }

    static class SerializedMessage {
        public String typeName;
        public byte[] value;

        SerializedMessage() {
        }
    }
}

