var _host = ''+window.location.host,
	_href = function(href, path){ return /[\u4E00-\u9FA5]/g.test(path) ? 'http://' + _host + '/' + encodeURIComponent(path) : href; }(window.location.href, window.location.pathname);
	
window.send = function(url) {
	window.location.href = url; 
}

window.call_scb    = function(status) {
	if( status ) {
		$('.scb').css('background-position','0 -44px');
	}
}

window.uwids = [];

window.call_phrase = function(uwid, html, status) {
	var pdom = $('.section [uwid=' + uwid + ']');
	    html = html ? decodeURIComponent(html.replace(/\+/g, " ")) : '很抱歉，词条加载失败!';
	
	if( !status ) {
		window.uwids.push(uwid); 
	} else {
		$.each(window.uwids, function(k, v){
			if(uwid == v) {
				delete window.uwids[k];
			}
		});
	} 
	pdom.siblings('.loading').html('');   
	pdom.siblings('.detail').html(html);
	
	parse_bindclick(pdom);
	$(pdom).find('i').removeClass('off').addClass('on');
} 


function hideScbBtn(){
	$(".scb").hide();
}

function parse_bindclick(dom){
	$(dom).click(function() {
		var html  = $(this).siblings('.detail').html(),
			uwid  = $(this).attr('uwid'),
			status= false;
			
		if( html ) {
			$.each(window.uwids,function(k, v){
				if(uwid == v) {
					status = true;
				}
			});
		}	
		
		if( !status ) {
			if($(dom).find('i').hasClass('on')) {
				$(dom).find('i').removeClass().toggleClass('off');
			} else {
				$(dom).find('i').removeClass().toggleClass('on');
			}
		}

		if( !html || status) {
			$(dom).siblings('.detail').html('').hide();
			$(dom).siblings('.loading').css('margin-left','45%').html('<img src="loading.gif" />');
			$(this).unbind('click');
			window.send('loadpharse:' + uwid);
		} else {
			$(dom).siblings('.loading').html('');
		}
		
		$(dom).siblings('.detail').slideToggle();
		
		/*if($(this).siblings('.loading').html()) {
			window.setTimeout(function(){
				$(dom).siblings('.detail').slideToggle();
				$(dom).siblings('.loading').html('');
				
			}, 1000);
		} else {
			$(dom).siblings('.detail').slideToggle();
		}*/
			
	}).find('i').addClass('off');
}


jQuery(function($){
	/* 生词本 */
	!function( scb ) {
		scb.click(function(){
			window.send('addscb:' + scb.attr('uwid'));
		});
		if(typeof(window.DICT)!="undefined"){
			window.DICT.ToDo(scb.attr('uwid'));	
		}
	
	}( $('.scb') );
	
	/* 封装滚动锚点 */
	$.extend({
		intval: function(v) {
			v = parseInt(v);
	    	return isNaN(v) ? 0 : v;
		},
		getPos: function(e) {
			var l  = 0,
			    t  = 0,
	            w  = $.intval($.css(e,'width')),
	            h  = $.intval($.css(e,'height')),
	            wb = e.offsetWidth,
		        hb = e.offsetHeight;
		        
		    while (e.offsetParent){
		        l += e.offsetLeft + (e.currentStyle?$.intval(e.currentStyle.borderLeftWidth):0);
		        t += e.offsetTop  + (e.currentStyle?$.intval(e.currentStyle.borderTopWidth):0);
		        e = e.offsetParent;
		    }
		    l  += e.offsetLeft + (e.currentStyle?$.intval(e.currentStyle.borderLeftWidth):0);
		    t  += e.offsetTop  + (e.currentStyle?$.intval(e.currentStyle.borderTopWidth):0);
		    return {x:l, y:t, w:w, h:h, wb:wb, hb:hb};
		},
		getClient: function(e) {
			if (e) {
		        w = e.clientWidth;
		        h = e.clientHeight;
		    } else {
		        w = (window.innerWidth) ? window.innerWidth : (document.documentElement && document.documentElement.clientWidth) ? document.documentElement.clientWidth : document.body.offsetWidth;
		        h = (window.innerHeight) ? window.innerHeight : (document.documentElement && document.documentElement.clientHeight) ? document.documentElement.clientHeight : document.body.offsetHeight;
		    }
		    return {w:w,h:h};
		},
		getScroll: function(e) {
			if (e) {
		        t = e.scrollTop;
		        l = e.scrollLeft;
		        w = e.scrollWidth;
		        h = e.scrollHeight;
		    } else  {
		        if (document.documentElement && document.documentElement.scrollTop) {
		            t = document.documentElement.scrollTop;
		            l = document.documentElement.scrollLeft;
		            w = document.documentElement.scrollWidth;
		            h = document.documentElement.scrollHeight;
		        } else if (document.body) {
		            t = document.body.scrollTop;
		            l = document.body.scrollLeft;
		            w = document.body.scrollWidth;
		            h = document.body.scrollHeight;
		        }
		    }
		    return { t: t, l: l, w: w, h: h };
		}
	});

	$.fn.scrollTo = function(s) {
	    o = $.speed(s);
	    return this.each(function(){
	        new $.fx.scrollTo(this, o);
	    });
	};
	
	$.fx.scrollTo = function (e, o) {
	    var z   = this;
	        z.o = o;
	        z.e = e;
	        z.p = $.getPos(e);
	        z.s = $.getScroll();
	        z.clear = function() {
	        	clearInterval(z.timer);
	        	z.timer = null
	        };
	        z.t    = (new Date).getTime();
	        z.step = function() {
		        var t = (new Date).getTime();
		        var p = (t - z.t) / z.o.duration;
		        if (t >= z.o.duration + z.t) {
		            z.clear();
		            setTimeout(function(){z.scroll(z.p.y, z.p.x)},13);
		        } else {
		            st = ((-Math.cos(p*Math.PI)/2) + 0.5) * (z.p.y-z.s.t) + z.s.t;
		            sl = ((-Math.cos(p*Math.PI)/2) + 0.5) * (z.p.x-z.s.l) + z.s.l;
		            z.scroll(st, sl);
		        }
		    };
	    z.scroll = function (t, l){window.scrollTo(l, t)};
	    z.timer  = setInterval(function(){z.step();},13);
	};
	
	// 是否移动设备判断
	$.isMobile = new RegExp('Mobile').test(window.navigator.userAgent);
	
	$(document.body).delegate('[audio]', (jQuery.isMobile ? 'touchstart' : 'click'), function(){
		var audio = $(this).attr('audio');
		var lang = $(this).attr('lang');
		if( audio ) {
			window.send('playsound:' + audio + '=' + window.key +'=' +lang);
		}
		
		return false;
	});

	/* 模块标签收起与展开 */
	!function( section, button ){
		section.each(function(idx, dom){
			dom = $(dom);
			
			dom.click(function(){
				$(this).find('i').toggleClass('off');
				$(this).siblings().slideToggle();
			}).find('i').addClass('on');
			
			button.children().click(function(){
				if($(this).hasClass('open')) {
					dom.find('i').removeClass().toggleClass('on');
					dom.siblings().slideDown();
				} else {
					dom.find('i').removeClass().toggleClass('off');
					dom.siblings().slideUp();
				}
			});
		});
		
	}( $('.section dt'), $('.button'));
	
	!function( content ) {
		content.each(function(key, cont) {
			/* 多页选项卡切换 */
			$(cont).find('.tabs span').each(function(idx, dom) {
				$(this).hammer().on("touch",function(event) {
					$(".main").eq(idx).find('.tabs span').eq(idx).addClass('selected').siblings().removeClass('selected');
					content.eq(idx).show().siblings().hide();
				});
			});
			
			/* 异步请求数据  */
			$(cont).find('.section .ajax').each(function(idx, dom) {
				
				parse_bindclick(dom);
			});
			
			// 定位展开目标数据
			if( window.position ) {
				var pdom = $(cont).find('.section [uwid=' + window.position + ']');
				
				if( pdom.text() ) {
					
					content.eq(key).show().siblings().hide();
					content.eq(key).find('.tabs span').eq(key).addClass('selected').siblings().removeClass('selected');
					
					if(pdom.find('i').hasClass('on')) {
						pdom.find('i').removeClass().toggleClass('off');
					} else {
						pdom.find('i').removeClass().toggleClass('on');
					}

					pdom.siblings('.detail').slideToggle();
					
					pdom.scrollTo(1200);
					
					window.setTimeout(
						function(){
							var pdom = $('.section [uwid=' + window.position + ']');
							$(pdom).trigger('click');
						}
						,1200
					);
				}
			} 
		});

	}( $('.main') );
});