/**
 * 跳转链接
 * @param {Object} url 跳转的链接
 * @param {Object} data 对象
 */
const navToUrl = function(url, data) {
  if (data) {
    url += (url.indexOf('?') < 0 ? '?' : '&') + param(data)
  }
  uni.navigateTo({
    url: url,
  })
}

/**
 * 跳转到webview链接
 * @param {Object} url 跳转的链接
 * @param {Object} data 对象
 */
const navToWebView = function(url, data) {
  // console.log(param(data))
  if (data) {
    url = url + '&' + param(data)
  }
  uni.navigateTo({
    url: '/pages/page/webview/webview?url=' + url
  })
}

/**
 * 跳转链接,关闭当前链接
 * @param {Object} url 跳转的链接
 * @param {Object} data 对象
 */
const redToUrl = function(url, data) {
  if (data) {
    url += (url.indexOf('?') < 0 ? '?' : '&') + param(data)
  }
  uni.redirectTo({
    url: url,
  })
}

const reLunch = function(url, data) {
  if (data) {
    url += (url.indexOf('?') < 0 ? '?' : '&') + param(data)
  }
  uni.reLaunch({
    url: url,
  })
}
/**
 * 跳转到 tabBar 页面
 * @param {Object} url 跳转的链接
 * @param {Object} data 对象
 */
const switchToUrl = function(url, data) {
  if (data) {
    url += (url.indexOf('?') < 0 ? '?' : '&') + param(data)
  }
  uni.switchTab({
    url: url,
  })
}

/**
 * 对象转字符串
 * @param {Object} data 对象
 */
const param = function(data) {
  let url = ''
  for (var k in data) {
    let value = data[k] !== undefined ? data[k] : ''
    url += '&' + k + '=' + encodeURIComponent(value)
  }
  return url ? url.substring(1) : ''
}

//格式化html格式代码
function formatRichText(html) {
  let newContent = html.replace(/<img[^>]*>/gi, function(match, capture) {
    match = match.replace(/style="[^"]+"/gi, '').replace(/style='[^']+'/gi, '');
    match = match.replace(/width="[^"]+"/gi, '').replace(/width='[^']+'/gi, '');
    match = match.replace(/height="[^"]+"/gi, '').replace(/height='[^']+'/gi, '');
    return match;
  });
  newContent = newContent.replace(/&quot;/gi, '')
  newContent = newContent.replace(/style="[^"]+"/gi, function(match, capture) {
    match = match.replace(/width:[^;]+;/gi, 'max-width:100%;').replace(/width:[^;]+;/gi, 'max-width:100%;');
    return newContent;
  });
  newContent = newContent.replace(/<br[^>]*\/>/gi, '');
  newContent = newContent.replace(/\<img/gi,
    '<img style="max-width:100%;height:auto;display:block;margin-top:0;margin-bottom:0;"');
  newContent = newContent.replace(/src="\/dev-api\//g,
    'src="https://inspirational-learning.lixue100.com/prod-api/');
  newContent = newContent.replace(/src="\/prod-api\//g, 'src="https://inspirational-learning.lixue100.com/prod-api/');
  console.log(newContent)

  return newContent;
}

// 解析url
const analysisUrlParam = function(url) {
  var queryParts = url.slice(url.indexOf("?") + 1).split('&');
  var params = queryParts.length > 0 ? {} : null;
  queryParts.map(function(item) {
    var a = item.split('=')
    params[a[0]] = a[1]
  })
  return params
}

// 传入时间与当前时间对比返回 xxx天xxx小时xxx分钟
const timeDifference = function(dateEnd) {
  var dateBegin = new Date(); //获取当前时间
  var dateDiff = new Date(dateEnd).getTime() - dateBegin.getTime(); //时间差的毫秒数
  if (dateDiff < 0) {
    return '该航班已起飞,请选择其它航班！'
  }
  var dayDiff = Math.floor(dateDiff / (24 * 3600 * 1000)); //计算出相差天数
  var leave1 = dateDiff % (24 * 3600 * 1000) //计算天数后剩余的毫秒数
  var hours = Math.floor(leave1 / (3600 * 1000)) //计算出小时数
  //计算相差分钟数
  var leave2 = leave1 % (3600 * 1000) //计算小时数后剩余的毫秒数
  var minutes = Math.floor(leave2 / (60 * 1000)) //计算相差分钟数
  //计算相差秒数
  var leave3 = leave2 % (60 * 1000) //计算分钟数后剩余的毫秒数
  var seconds = Math.round(leave3 / 1000)
  var leave4 = leave3 % (60 * 1000) //计算分钟数后剩余的毫秒数
  var minseconds = Math.round(leave4 / 1000)
  hours = String(hours).length == 1 ? '0' + hours : String(hours)
  minutes = String(minutes).length == 1 ? '0' + minutes : String(minutes)
  seconds = String(seconds).length == 1 ? '0' + seconds : String(seconds)
  // var timeFn = dayDiff + "天 " + hours + "小时 " + minutes + " 分钟" + seconds + " 秒" + minseconds + "毫秒";
  var timeFn = dayDiff + "天 " + hours + "小时 " + minutes + " 分钟";
  return timeFn;
}

// 传入两个时间计算时长
const dateDifference = function(faultDate, completeTime) {
  // let d1 = new Date(faultDate);
  // let d2 = new Date(completeTime);
  var stime = new Date(faultDate).getTime();
  var etime = new Date(completeTime).getTime();
  var usedTime = etime - stime; //两个时间戳相差的毫秒数
  var days = Math.floor(usedTime / (24 * 3600 * 1000));
  //计算出小时数
  var leave1 = usedTime % (24 * 3600 * 1000); //计算天数后剩余的毫秒数
  var hours = Math.floor(leave1 / (3600 * 1000));
  //计算相差分钟数
  var leave2 = leave1 % (3600 * 1000); //计算小时数后剩余的毫秒数
  var minutes = Math.floor(leave2 / (60 * 1000));
  var time = days + "天" + hours + "时" + minutes + "分";
  // var time = days;
  return time;
}

// 时间格式化
const formatDate = function(cellValue) {
  if (cellValue == null || cellValue == "") return "";
  var date = new Date(cellValue)
  var year = date.getFullYear()
  var month = date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1
  var day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate()
  var hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours()
  var minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()
  var seconds = date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds()
  return year + '-' + month + '-' + day + ' ' + hours + ':' + minutes + ':' + seconds
}
/**
 * 格式化秒
 * int  value 总秒数
 * string result 格式化后的字符串
 */
const formatSeconds = function(value) {
  var theTime = parseInt(value); // 需要转换的时间秒 
  var theTime1 = 0; // 分 
  var theTime2 = 0; // 小时 
  var theTime3 = 0; // 天
  if (theTime > 60) {
    theTime1 = parseInt(theTime / 60);
    theTime = parseInt(theTime % 60);
    if (theTime1 > 60) {
      theTime2 = parseInt(theTime1 / 60);
      theTime1 = parseInt(theTime1 % 60);
      if (theTime2 > 24) {
        //大于24小时
        theTime3 = parseInt(theTime2 / 24);
        theTime2 = parseInt(theTime2 % 24);
      }
    }
  }
  var result = '';
  if (theTime > 0) {
    result = "" + parseInt(theTime) + "秒";
  }
  if (theTime1 > 0) {
    result = "" + parseInt(theTime1) + "分" + result;
  }
  if (theTime2 > 0) {
    result = "" + parseInt(theTime2) + "小时" + result;
  }
  if (theTime3 > 0) {
    result = "" + parseInt(theTime3) + "天" + result;
  }
  return result;
}
/* 距离转换 */
const kmUnit = function(m){
    var v;
	if(typeof m === 'number' && !isNaN(m)){
		if (m >= 1000) {
            v = (m / 1000).toFixed(2) + 'km'
        } else {
           	v = m + 'm'
        }
	}else{
		v = '0m'
	}
    return v;
}
export default {
  // 通用函数
  navToUrl,
  navToWebView,
  reLunch,
  redToUrl,
  switchToUrl,
  formatRichText,
  analysisUrlParam,
  timeDifference,
  formatDate,
  dateDifference,
  formatSeconds,
  kmUnit
}
