#include <Shaders/VisionCommon.inc>

#ifdef _VISION_DX11
  Texture2D <float4> BaseTexture              : register(t0);
  sampler            BaseTextureSampler       : register(s0);
  Texture2D <float4> PointLightTexture        : register(t1);
  sampler            PointLightTextureSampler : register(s1);
  Texture2D <float4> SpotLightTexture         : register(t2);
  sampler            SpotLightTextureSampler  : register(s2);
#else
  sampler2D          BaseTexture        : register(s0);
  sampler2D          PointLightTexture  : register(s1);
  sampler2D          SpotLightTexture   : register(s2);
#endif


struct PS_IN
{
  float4   ProjPos : SV_Position;
  float2   UV0     : TEXCOORD0;
  float3   WSPos     : TEXCOORD1;
  float3   WSNormal  : TEXCOORD2;
};

// must match the texture size in the app (MAX_COLLAPSED_LIGHTS)
#define LIGHT_TEXTURE_WIDTH  128.0f

float4 ps_main( PS_IN In ) : SV_Target
{
  float4 diffuse = vTex2D(BaseTexture, BaseTextureSampler, In.UV0);
  
  float3 lightAccum = float3(0.1,0.1,0.1); // start with ambient color
  float3 vWSNormal = In.WSNormal;
 
 // accumulate all point lights
$if NUM_POINTLIGHTS > 0
  for (int i=0;i<$NUM_POINTLIGHTS;i++)
  {
    float u = (i+0.5)/LIGHT_TEXTURE_WIDTH;
    float4 lightpos = vTex2D(PointLightTexture, PointLightTextureSampler, float2(u, 0.5/4.0) ); // first row of texture
  #ifdef DYNAMIC_BRANCH
    // we can stop the loop here as only valid lights are in the list. However, it costs more performance than it helps
    if (lightpos.w==0.0f)
      break;
  #endif
    float4 lightcol = vTex2D(PointLightTexture, PointLightTextureSampler, float2(u, 1.5/4.0) ); // second row of texture
    float3 vLightDiff = lightpos.xyz - In.WSPos;
    float3 vLightDir = normalize(vLightDiff);
    float fLightAtten = saturate((lightpos.w - length(vLightDiff)) / lightpos.w);
    float fFalloff = saturate(dot(vLightDir,vWSNormal));
    lightAccum += lightcol.xyz*fLightAtten*fFalloff;
  }
$endif
 
 // accumulate all spot lights
$if NUM_SPOTLIGHTS > 0
  for (int i=0;i<$NUM_SPOTLIGHTS;i++)
  {
    float u = (i+0.5)/LIGHT_TEXTURE_WIDTH;
    float4 lightpos = vTex2D(SpotLightTexture, SpotLightTextureSampler, float2(u, 0.5/4.0) ); // first row of texture
  #ifdef DYNAMIC_BRANCH
    // we can stop the loop here as only valid lights are in the list. However, it costs more performance than it helps
    if (lightpos.w==0.0f)
      break;
  #endif
    float4 lightcol = vTex2D(SpotLightTexture, SpotLightTextureSampler, float2(u, 1.5/4.0) ); // second row of texture
    float4 spotdir = vTex2D(SpotLightTexture, SpotLightTextureSampler, float2(u, 2.5/4.0) ); // third row of textue
    float3 vLightDiff = lightpos.xyz - In.WSPos;
    float3 vLightDir = normalize(vLightDiff);
    float fLightAtten = saturate((lightpos.w - length(vLightDiff)) / lightpos.w);
    float fFalloff = saturate(dot(vLightDir,vWSNormal));
    float fSpotDot = dot(-vLightDir,spotdir.xyz);
    if (fSpotDot >= spotdir.w)
    {
      float fConeAtten = (fSpotDot-spotdir.w)/(1.f-spotdir.w);
      lightAccum += lightcol.xyz*fLightAtten*fFalloff*fConeAtten;
    }
  }
$endif
    
  diffuse.xyz *= lightAccum;
  return diffuse;
}
