//=============================================================================
// RPG Maker MZ - LH_AndroidAD
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 调用安卓广告
 * @author 零或
 *
 * @help 
 * 通过插件命令，调用安卓广告
 * 
 * =======================版本记录=======================
 * 2023.01.18，初版搞定
 * 
 * @param note_rewardVideo
 * @text =====激励广告相关=====
 * @type text
 * @desc 备注信息，用于美化界面，无需填写任何内容
 * 
 * @param commonEventID_rewardVideoAdFailed
 * @text 激励广告播放失败
 * @type common_event
 * @default 0
 * @desc 激励广告播放失败后，所执行的共通事件
 * 
* @param commonEventID_rewardVideoAdSuccess
 * @text 激励广告播放成功
 * @type common_event
 * @default 0
 * @desc 激励广告播放成功后，所执行的共通事件
 * 
 * @command 播放激励广告
 * 
 * @command 播放全屏广告
 * 
 * @command 显示插屏广告
 * 
 * 
 */

const params_LH_AndroidAD = PluginManager.parameters("LH_AndroidAD");

PluginManager.registerCommand('LH_AndroidAD', '播放激励广告', args => {
	js_android.callRewardVideo();
});

PluginManager.registerCommand('LH_AndroidAD', '播放全屏广告', args => {
	js_android.callFullscreenVideo();
});

PluginManager.registerCommand('LH_AndroidAD', '显示插屏广告', args => {
	js_android.callInterstitial();
});


js_android.callRewardVideo = function(){
	js_android.showRewardVideoAd();
}

js_android.callFullscreenVideo = function(){
	js_android.showFullscreenVideoAd();
}

js_android.callInterstitial = function(){
	js_android.showInterstitialAd();
}


//#region  激励视频

function rewardVideoAdLoader(){

}

function rewardVideoAdCached(){

}

function rewardVideoAdShow(){

}

function rewardVideoAdExpose(){

}

function rewardVideoAdReward(){
	$gameTemp.reserveCommonEvent(params_LH_AndroidAD.commonEventID_rewardVideoAdSuccess);

}

function rewardVideoAdClicked(){

}

function rewardVideoAdComplete(){

}

//关闭广告（右上角叉号）
function rewardVideoAdClosed(){

}

//广告播放成功
function rewardVideoAdSuccess(){
	//$gameTemp.reserveCommonEvent(params_LH_AndroidAD.commonEventID_rewardVideoAdSuccess);
}

//广告播放失败
function rewardVideoAdFailed(){
	$gameTemp.reserveCommonEvent(params_LH_AndroidAD.commonEventID_rewardVideoAdFailed);
}

function rewardVideoAdSkipped(){

}

function rewardVideoAdPreload(){

}

//#endregion

//#region  全屏视频

function fullscreenVideoAdLoader(){

}

function fullscreenVideoAdCached(){

}

function fullscreenVideoAdShow(){

}

function fullscreenVideoAdExposure(){

}

function fullscreenVideoAdClick(){

}

function fullscreenVideoAdComplete(){

}

function fullscreenVideoAdClosed(){

}

function fullscreenVideoAdSuccess(){

}

function fullscreenVideoAdError(){

}

function fullscreenVideoAdSkipped(){

}

function fullscreenVideoAdPreload(){

}

//#endregion

//#region  插屏广告

function interstitialAdLoader(){

}

function interstitialAdExposure(){

}

function interstitialAdClicked(){

}

function interstitialAdClosed(){

}

function interstitialAdSuccess(){

}

function interstitialAdFailed(){

}

//#endregion
	
