//=============================================================================
// RPG Maker MZ - LH_DropItemCount
//=============================================================================


/*:
 * @target MZ
 * @plugindesc 确定掉落后，该掉落物品可以一次性掉多个
 * @author 零或
 *
 * @help 
 * 使用方法：
 * 在物品备注中写入标签：<dropCount:最少掉落,最多掉落>
 * 
 * 逻辑：
 * 不涉及掉落率判定，在RMZ原逻辑中，已经确定该物体掉落后，随机一个掉落数量
 * 
 * 注意:
 * 该插件与MOG_TrPopUpBattle冲突，仅进行了部分解决：
 * MOG_TrPopUpBattle在地图上显示的物品图标数量，不为实际掉落数量，而是单独随机了一次。
 * 实际掉落数量为战斗胜利后结算时随机的数量。
 * 
 * 使用条款：
 * 免费用于任何商业或非商业目的；允许在保留原作者信息的前提下修改代码；
 * 请在你的项目中致谢“零或”，谢谢！
 * 
 * ==============================================
 * 2022.11.13，搞定，希望没有bug和插件冲突
 * 
 */


(()=>{
    const LH_Game_Enemy_prototype_makeDropItems = Game_Enemy.prototype.makeDropItems;
    /* 制作掉落物品 */
    Game_Enemy.prototype.makeDropItems = function() {
        var tempDorpItem = LH_Game_Enemy_prototype_makeDropItems.apply(this,arguments);

        if(PluginManager._scripts.includes("MOG_TrPopUpBattle")){
            if(this._treasure.checked){
                return this._treasure.item;
            }
        }
        tempDorpItem.forEach(element => {
            var items = [];
            if(element.meta.dropCount!=null){
                var tempStr = element.meta.dropCount.split(',');
                var tempCount = Math.floor(Math.random()*(Number(tempStr[1])-Number(tempStr[0])+1)+Number(tempStr[0]));
                console.log(tempCount);
                for (let index = 0; index < tempCount-1; index++) {
                    items[index] = element;
                }
            }
            tempDorpItem = tempDorpItem.concat(items);
        });
        return tempDorpItem;
    };
})();
