//=============================================================================
// PY_LevelUpCommonEvent.js
//=============================================================================

/*:
 * @plugindesc (v1.0)升级执行公共事件插件
 * @author 破夜沙狼
 * @help
本插件可以在角色升级（含队友）后执行某个公共事件。
可配合某些插件制作多种功能，比如升级回血，升级后提示等，也可以制作肉鸽游戏等。
插件指令：
PY_LevelUpCommonEventSwichOn        //开启执行公共事件开关
PY_LevelUpCommonEventSwichOff       //关闭执行公共事件开关







=============================================================================
使用条款：本插件可免费用于非商业及商业用途。
请在游戏结尾名单中署名：破夜沙狼
=============================================================================
更新日志：
v1.0 完成初始插件
 * 
 * @param 执行的公共事件ID
 * @desc 请输入要执行的公共事件ID，如果不执行公共事件，请填写0
 * @type number
 * @min 0
 * @max 1000
 * @default 0
 * 
 * 
 */


(() => {
    var parameters = PluginManager.parameters('PY_LevelUpCommonEvent');
    var PY_LevelUpCommonEventId = Number(parameters['执行的公共事件ID']);
    var PY_LevelUpCommonEventSwich = false;

    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args) {
        _Game_Interpreter_pluginCommand.call(this, command, args);
        if (command === 'PY_LevelUpCommonEventSwichOn') {
            PY_LevelUpCommonEventSwich = true;
        }
        if (command === 'PY_LevelUpCommonEventSwichOff') {
            PY_LevelUpCommonEventSwich = false;
        }
    };
    //升级判定
    var PY_LevelUpChooseShow = Game_Actor.prototype.levelUp;
    Game_Actor.prototype.levelUp = function() {
        PY_LevelUpChooseShow.call(this);
            if(PY_LevelUpCommonEventSwich){
                $gameTemp.reserveCommonEvent(PY_LevelUpCommonEventId);
            }
    };

})();