//=============================================================================
// EliteEnemyPlugins1.js
//=============================================================================
 
/*:
 * @target MZ
 * @plugindesc Elite Enemy Plugins Color（标准版）
 * @author Morpho(dongdongDJH)
 *
 * @help EliteEnemyPlugins1.js
 * EliteEnemy的扩展插件，需EliteEnemy支持，加载在EliteEnemy插件后。
 * 加载该插件，精英的颜色会与普通怪不同。
 */
(() => {
 	Sprite_Enemy.prototype.updateBitmap = function() {
    	Sprite_Battler.prototype.updateBitmap.call(this);
    	const name = this._enemy.battlerName();
    	const hue = this._enemy.battlerHue();
    	if (this._battlerName !== name || this._battlerHue !== hue) {
        	this._battlerName = name;
        	this._battlerHue = hue;
        	const huePlugins = hue + this._enemy.isElite() ? 100 : 0;
        	this.loadBitmap(name);
            this.setHue(huePlugins);
        	this.initVisibility();
    	}
	};

})();
