//=============================================================================
// RPG Maker MZ - 自动战斗插件
//=============================================================================

/*:
 * @target MZ
 * @plugindesc v1.0.0 飞猫云工作室-<自动战斗插件>
 * @author 飞猫云工作室（Fly_Cat/Fly_Roc）
 * 
 * @param autoBattle
 * @text 初始是否开启自动战斗
 * @type boolean
 * @on 启用
 * @off 关闭
 * @desc true - 启用，false - 关闭
 * @default false
 * 
 * @param autoBattleImg
 * @text 自动战斗图片
 * @type file
 * @dir  img/system/
 * @desc 
 * @default 
 * 
 * @param imgX
 * @text 显示坐标X
 * @type number
 * @desc 显示坐标X
 * @default 50
 *
 * @param imgY
 * @text 显示坐标Y
 * @type number
 * @desc 显示坐标Y
 * @default 600
 * 
 * @help
 * ==============================使用条款==================================
 * 1.本插件免费用于免费游戏和商业游戏
 * 2.游戏中必须致谢Fly_Cat/Fly_Roc
 * ==============================使用说明==================================
 * 将图片放置img/system
 * 即插即用战斗中控制按钮即可
 * 1.承接MV、MZ定制插件  QQ：903516931
 * =======================================================================
 */

'use strict';
var Imported = Imported || {};
Imported.FlyCat_AutoBattle = true;

var FlyCat = FlyCat || {};
FlyCat.AutoBattl = {};
FlyCat.AutoBattl.parameters = PluginManager.parameters('FlyCat_AutoBattle');
FlyCat.AutoBattl.autoBattle = String(FlyCat.AutoBattl.parameters['autoBattle'] || "false");
FlyCat.AutoBattl.autoBattleImg = FlyCat.AutoBattl.parameters['autoBattleImg'];
FlyCat.AutoBattl.imgX = Number(FlyCat.AutoBattl.parameters['imgX'] || 50);
FlyCat.AutoBattl.imgY = Number(FlyCat.AutoBattl.parameters['imgY'] || 600);

FlyCat.AutoBattl.Game_BattlerBase_isAutoBattle = Game_BattlerBase.prototype.isAutoBattle;
Game_BattlerBase.prototype.isAutoBattle = function () {
    return $gameSystem._autoBattle || FlyCat.AutoBattl.Game_BattlerBase_isAutoBattle.call(this);
};

FlyCat.AutoBattl.Scene_Battle_start = Scene_Battle.prototype.start;
Scene_Battle.prototype.start = function () {
    FlyCat.AutoBattl.Scene_Battle_start.call(this);
    this.createAutoBattleSprtie();
};

Scene_Battle.prototype.createAutoBattleSprtie = function () {
    this._autoBattleSprite = new Sprite_autoBattleButton();
    this.addChild(this._autoBattleSprite);
    this._autoBattleSprite.bitmap = ImageManager.loadSystem(FlyCat.AutoBattl.autoBattleImg)
    if (!$gameSystem._autoBattle) {
        $gameSystem._autoBattle = eval(FlyCat.AutoBattl.autoBattle);
    }
    this._autoBattleSprite.setClickHandler(this.startAutoBattle.bind(this));
    this._autoBattleSprite.x = FlyCat.AutoBattl.imgX;
    this._autoBattleSprite.y = FlyCat.AutoBattl.imgY;
    this._autoBattleSprite.visible = true;
};
Scene_Battle.prototype.startAutoBattle = function () {
    $gameSystem._autoBattle = $gameSystem._autoBattle ? false : true;
    $gameTemp.reserveCommonEvent(3);
};
FlyCat.AutoBattl.Scene_Battle_update = Scene_Battle.prototype.update;
Scene_Battle.prototype.update = function () {
    FlyCat.AutoBattl.Scene_Battle_update.call(this);
    if (BattleManager.isBattleEnd()) {
        this._autoBattleSprite.visible = false;
    }
    if ($gameSystem._autoBattle == false && this._autoBattleSprite) {
        this._autoBattleSprite.setFrame(0, 0, this._autoBattleSprite.bitmap.width / 2, this._autoBattleSprite.bitmap.height);
    }
    if ($gameSystem._autoBattle == true && this._autoBattleSprite) {
        this._autoBattleSprite.setFrame(this._autoBattleSprite.bitmap.width / 2, 0, this._autoBattleSprite.bitmap.width / 2, this._autoBattleSprite.bitmap.height);
    }
};

//////////////////////////////Sprite_autoBattleButton/////////////////////////////
function Sprite_autoBattleButton() {
    this.initialize(...arguments);
}
Sprite_autoBattleButton.prototype = Object.create(Sprite_Clickable.prototype);
Sprite_autoBattleButton.prototype.constructor = Sprite_autoBattleButton;

Sprite_autoBattleButton.prototype.initialize = function () {
    Sprite_Clickable.prototype.initialize.call(this);
    this._clickHandler = null;
    this._lastBimap = null;
    this._pressCounts = 0;
};

Sprite_autoBattleButton.prototype.onClick = function () {
    SoundManager.playOk()
    if (this._clickHandler) {
        this._clickHandler();
    }

};
Sprite_autoBattleButton.prototype.setClickHandler = function (method) {
    this._clickHandler = method;
};