#version 300 es

precision mediump float;

in vec2 vTextureCoord;
uniform sampler2D uTexture;
uniform vec2 uTexelSize;
out vec4 fragColor;

void main() {
    const float weights[16] = float[](
    0.049870, 0.049482, 0.048336, 0.046484,
    0.044010, 0.041022, 0.037644, 0.034009,
    0.030248, 0.026486, 0.022832, 0.019377,
    0.016190, 0.013318, 0.010785, 0.008599
    );

    vec2 pixelSize = uTexelSize * 5.0;

    vec3 color = texture(uTexture, vTextureCoord).rgb * weights[0];

    for(int i = 1; i < 16; i++) {
        color += texture(uTexture, vTextureCoord + vec2(0.0, pixelSize.y * float(i))).rgb * weights[i];
        color += texture(uTexture, vTextureCoord - vec2(0.0, pixelSize.y * float(i))).rgb * weights[i];
    }

    fragColor = vec4(color, 1.0);
}
