#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform vec2 uTexelSize;
uniform float uOffset;
uniform float uScaleOffset;

out vec4 uv01;
out vec4 uv23;
out vec2 vUV;

#define sampleScale (1. + 0.1)

void main() {
    vec2 _texelSize = uTexelSize * 0.5;
    vec2 _offset = vec2(uOffset, uOffset);
    vec2 uv = vec2(aTextureCoord.x, 1.0-aTextureCoord.y) * sampleScale;

    uv01.xy = uv - _texelSize * _offset;//top right
    uv01.zw = uv + _texelSize * _offset;//bottom left
    uv23.xy = uv - vec2(_texelSize.x, -_texelSize.y) * _offset;//top left
    uv23.zw = uv + vec2(_texelSize.x, -_texelSize.y) * _offset;//bottom right

    gl_Position = aPosition;

    vUV = uv;
}