#version 300 es
precision highp float;

uniform sampler2D uMainTex;

in vec4 uv01;
in vec4 uv23;
in vec4 uv45;
in vec4 uv67;
out vec4 fragColor;

float edgeMin = 0.001;
float edgeMax = 0.999;

void main() {

    vec4 uv011 = clamp(uv01, edgeMin, edgeMax);
    vec4 uv231 = clamp(uv23, edgeMin, edgeMax);
    vec4 uv451 = clamp(uv45, edgeMin, edgeMax);
    vec4 uv671 = clamp(uv67, edgeMin, edgeMax);

    vec4 sum = vec4(0.0);
    sum += texture(uMainTex, uv011.xy);
    sum += texture(uMainTex, uv011.zw) * 2.0;
    sum += texture(uMainTex, uv231.xy);
    sum += texture(uMainTex, uv231.zw) * 2.0;
    sum += texture(uMainTex, uv451.xy);
    sum += texture(uMainTex, uv451.zw) * 2.0;
    sum += texture(uMainTex, uv671.xy);
    sum += texture(uMainTex, uv671.zw) * 2.0;

    fragColor = sum * 0.0833;

    //fragColor = texture(uMainTex, vUV);
}