#version 300 es
precision mediump float;

uniform sampler2D uPassTex;

in vec4 uv01;
in vec4 uv23;
in vec2 vUV;

out vec4 fragColor;

float edgeMin = 0.008;
float edgeMax = 0.993;

void main() {

    vec4 uv011 = clamp(uv01, edgeMin, edgeMax);
    vec4 uv231 = clamp(uv23, edgeMin, edgeMax);

    vec4 sum = texture(uPassTex, vUV) * 4.0;
    sum += texture(uPassTex, uv011.xy);
    sum += texture(uPassTex, uv011.zw);
    sum += texture(uPassTex, uv231.xy);
    sum += texture(uPassTex, uv231.zw);

    fragColor = sum * 0.125;
}