#version 300 es
precision mediump float;

uniform sampler2D uPassTex;

in vec4 uv01;
in vec4 uv23;
in vec4 uv45;
in vec4 uv67;
in vec4 uv89;
in vec4 uv1011;
in vec2 vUV;
out vec4 fragColor;

float edgeMin = 0.008;
float edgeMax = 0.993;

void main() {

    vec4 uv011 = clamp(uv01, edgeMin, edgeMax);
    vec4 uv231 = clamp(uv23, edgeMin, edgeMax);
    vec4 uv451 = clamp(uv45, edgeMin, edgeMax);
    vec4 uv671 = clamp(uv67, edgeMin, edgeMax);
    vec4 uv891 = clamp(uv89, edgeMin, edgeMax);
    vec4 uv10111 = clamp(uv1011, edgeMin, edgeMax);

    vec4 sum = vec4(0.0);
    sum += texture(uPassTex, uv011.xy);
    sum += texture(uPassTex, uv011.zw) * 2.0;
    sum += texture(uPassTex, uv231.xy);
    sum += texture(uPassTex, uv231.zw) * 2.0;
    sum += texture(uPassTex, uv451.xy);
    sum += texture(uPassTex, uv451.zw) * 2.0;
    sum += texture(uPassTex, uv671.xy);
    sum += texture(uPassTex, uv671.zw) * 2.0;
    
    // Add the new sampling points with lower weights since they're further out
    sum += texture(uPassTex, uv891.xy) * 0.5;
    sum += texture(uPassTex, uv891.zw) * 0.5;
    sum += texture(uPassTex, uv10111.xy) * 0.5;
    sum += texture(uPassTex, uv10111.zw) * 0.5;

    // Adjust the normalization factor based on the new weights
    // Original: 8 regular samples (4 with weight 1, 4 with weight 2) = 12 total weight
    // New: Original 12 + 4 new samples with weight 0.5 = 14 total weight
    fragColor = sum * (1.0 / 14.0); // 0.0714 instead of 0.0833
}