#version 300 es
precision mediump float;

uniform sampler2D uPassTex;

in vec4 uv01;
in vec4 uv23;
in vec4 uv45;
in vec4 uv67;
in vec2 vUV;
out vec4 fragColor;

float edgeMin = 0.008;
float edgeMax = 0.993;

void main() {

    vec4 uv011 = clamp(uv01, edgeMin, edgeMax);
    vec4 uv231 = clamp(uv23, edgeMin, edgeMax);
    vec4 uv451 = clamp(uv45, edgeMin, edgeMax);
    vec4 uv671 = clamp(uv67, edgeMin, edgeMax);

    vec4 sum = vec4(0.0);
    sum += texture(uPassTex, uv011.xy);
    sum += texture(uPassTex, uv011.zw) * 2.0;
    sum += texture(uPassTex, uv231.xy);
    sum += texture(uPassTex, uv231.zw) * 2.0;
    sum += texture(uPassTex, uv451.xy);
    sum += texture(uPassTex, uv451.zw) * 2.0;
    sum += texture(uPassTex, uv671.xy);
    sum += texture(uPassTex, uv671.zw) * 2.0;

    fragColor = sum * 0.0833;
}