#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform vec2 uTexelSize;
uniform float uOffset;

out vec4 uv01;
out vec4 uv23;
out vec4 uv45;
out vec4 uv67;
out vec2 vUV;


void main() {
    vec2 _texelSize = uTexelSize * 0.5;
    vec2 _offset = vec2(uOffset, uOffset);
    vec2 uv = vec2(aTextureCoord.x, 1.0-aTextureCoord.y);

    uv01.xy = uv + vec2(-_texelSize.x * 2.0, 0.0) * _offset;
    uv01.zw = uv + vec2(-_texelSize.x, _texelSize.y) * _offset;
    uv23.xy = uv + vec2(0.0, _texelSize.y * 2.0) * _offset;
    uv23.zw = uv + _texelSize * _offset;
    uv45.xy = uv + vec2(_texelSize.x * 2.0, 0.0) * _offset;
    uv45.zw = uv + vec2(_texelSize.x, -_texelSize.y) * _offset;
    uv67.xy = uv + vec2(0.0, -_texelSize.y * 2.0) * _offset;
    uv67.zw = uv - _texelSize * _offset;

    gl_Position = aPosition;
    vUV = uv;
}