#version 300 es
precision highp float;

uniform sampler2D uPassTex;
uniform float uRate;
uniform float uAspect;
uniform float uBorderWidth;  // 边框宽度

in vec2 vUV;
in vec2 vUVScale1;
in vec2 vUVScale2;

out vec4 fragColor;

void main() {
    float borderWidth = uBorderWidth * uRate;
    float borderSmoothness = 0.001;
    float shrinkOffset = 0.02 * uRate;
    float outerShadowWidth = 0.02;
    float outerShadowIntensity = 0.25;

    // 计算到边缘的距离（考虑收缩和宽高比）
    vec2 dist = vec2(
        min(vUV.x - (vUVScale2.x + shrinkOffset/uAspect), (vUVScale1.x - shrinkOffset/uAspect) - vUV.x),
        min((vUV.y - (vUVScale2.y + shrinkOffset)) / uAspect, ((vUVScale1.y - shrinkOffset) - vUV.y) / uAspect)
    );

    float minDist = min(dist.x, dist.y);
    
    // 检测是否在收缩后的区域内
    float isInside = smoothstep(-borderSmoothness, borderSmoothness, minDist);
    
    // 计算卡片阴影（使用更平滑的渐变）
    float cardShadow = (1.0 - step(0.0, minDist)) * 
        smoothstep(-outerShadowWidth, 0.0, minDist) * 
        (1.0 - pow(-minDist / outerShadowWidth, 2.0)) *
        outerShadowIntensity;
    
    // 边框检测（使用平滑过渡）
    float border = smoothstep(minDist - borderSmoothness, minDist + borderSmoothness, borderWidth);
    
    // 获取原始纹理颜色
    vec4 texColor = texture(uPassTex, vUV);
    
    // 边框颜色
    vec4 borderColor = vec4(1.0, 1.0, 1.0, 1.0);
    
    // 最终混合边框和外部透明区域
    vec4 withBorder = mix(texColor, borderColor, border);
    vec4 withInside = mix(vec4(0.0, 0.0, 0.0, 0.0), withBorder, isInside);
    
    // 添加卡片阴影
    fragColor = mix(vec4(0.0, 0.0, 0.0, cardShadow), withInside, isInside);
}