#version 300 es

in vec4 aPosition;
in vec2 aTextureCoord;

uniform float uRate;
uniform float uAspect;
uniform float uRotateAngle;
uniform float uCardY;      // Y轴偏移
uniform float uScale;      // 整体缩放

out vec2 vUV;
out vec2 vUVScale1;
out vec2 vUVScale2;

void main() {
    float scale = (1.0 - (0.7 * uRate) * uScale);
    
    float angle = uRate * radians(uRotateAngle);
    float cosA = cos(angle);
    float sinA = sin(angle);

    // 应用5:3的宽高比缩放
    vec2 aspectScale = vec2(1.0+0.67 * uRate, 1.0);// 5:3 ≈ 1.67:1
    vec2 scaled = vec2(aPosition.x * uAspect, aPosition.y) * scale * aspectScale;
    vec2 rotated = vec2(
        scaled.x * cosA - scaled.y * sinA,
        (scaled.x * sinA + scaled.y * cosA) * uAspect
    );

    gl_Position = vec4(rotated.x / uAspect, rotated.y / uAspect + uCardY * uRate, aPosition.zw);

    // UV计算保持不变
    vec2 uvCenter = vec2(0.5, 0.5);
    float v = (1.0+1.87 * uRate);

    vec2 uvOffset1 = vec2(1.0) - uvCenter;
    vUVScale1 = uvCenter + (uvOffset1 * aspectScale)/v;

    vec2 uvOffset2 = vec2(0.0) - uvCenter;
    vUVScale2 = uvCenter + (uvOffset2 * aspectScale)/v;

    vec2 uvOffset = aTextureCoord - uvCenter;
    vec2 scaledUV = uvCenter + (uvOffset * aspectScale)/v;
    vUV = vec2(scaledUV.x, 1.0-scaledUV.y);
}